/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IComparableSymbol;
import com.ibm.wala.automaton.string.IEnumerableSymbol;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.ISymbolVisitor;
import com.ibm.wala.automaton.string.RangeSymbol;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MappingElement
implements IEnumerableSymbol {
    public static String SEPARATOR = ",";
    IEnumerableSymbol domain;
    IEnumerableSymbol image;

    public MappingElement(IEnumerableSymbol symbol1, IEnumerableSymbol symbol2) {
        this.domain = symbol1;
        this.image = symbol2;
    }

    public MappingElement(Character symbol1, Character symbol2) {
        this(new CharSymbol(symbol1.charValue()), new CharSymbol(symbol2.charValue()));
    }

    @Override
    public String getName() {
        return this.domain.getName() + SEPARATOR + this.image.getName();
    }

    public ISymbol[] getSymbols() {
        return new ISymbol[]{this.domain, this.image};
    }

    public IEnumerableSymbol getDomain() {
        return this.domain;
    }

    public IEnumerableSymbol getImage() {
        return this.image;
    }

    @Override
    public boolean matches(ISymbol symbol, IMatchContext ctx) {
        if (!symbol.getClass().equals(this.getClass())) {
            return false;
        }
        MappingElement psym = (MappingElement)symbol;
        return this.domain.matches(psym.domain, ctx) && this.image.matches(psym.image, ctx);
    }

    @Override
    public boolean possiblyMatches(ISymbol symbol, IMatchContext ctx) {
        if (!symbol.getClass().equals(this.getClass())) {
            return false;
        }
        MappingElement psym = (MappingElement)symbol;
        return this.domain.possiblyMatches(psym.domain, ctx) && this.image.possiblyMatches(psym.image, ctx);
    }

    @Override
    public void traverse(ISymbolVisitor visitor) {
        visitor.onVisit(this);
        this.domain.traverse(visitor);
        this.image.traverse(visitor);
        visitor.onLeave(this);
    }

    @Override
    public ISymbol copy(ISymbolCopier copier) {
        ISymbol s = copier.copy(this);
        if (s instanceof MappingElement) {
            MappingElement ps = (MappingElement)s;
            ps.image = (IEnumerableSymbol)copier.copySymbolReference(ps, ps.image);
            ps.domain = (IEnumerableSymbol)copier.copySymbolReference(ps, ps.domain);
        }
        return s;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        return 0;
    }

    public int hashCode() {
        return this.domain.hashCode() + this.image.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MappingElement)) {
            return false;
        }
        MappingElement psym = (MappingElement)obj;
        return this.domain.equals(psym.domain) && this.image.equals(psym.image);
    }

    public String toString() {
        return "'" + this.getName() + "'";
    }

    @Override
    public IComparableSymbol[] coerce(IComparableSymbol o) throws IComparableSymbol.NotComparableException {
        throw new IComparableSymbol.NotComparableException(o, this);
    }

    @Override
    public int compareTo(IComparableSymbol o) throws IComparableSymbol.NotComparableException {
        MappingElement p = (MappingElement)o;
        int r1 = this.domain.compareTo(p.domain);
        int r2 = this.image.compareTo(p.image);
        if (r1 == 0 && r2 == 0) {
            return 0;
        }
        if (r1 <= 0 && r2 <= 0) {
            return -1;
        }
        if (r1 >= 0 && r2 >= 0) {
            return 1;
        }
        throw new IComparableSymbol.NotComparableException(this, o);
    }

    @Override
    public IEnumerableSymbol getMax() {
        return new MappingElement(this.domain.getMax(), this.image.getMax());
    }

    @Override
    public IEnumerableSymbol getMin() {
        return new MappingElement(this.domain.getMin(), this.image.getMin());
    }

    @Override
    public IEnumerableSymbol getTop() {
        return new MappingElement(this.domain.getTop(), this.image.getTop());
    }

    @Override
    public IEnumerableSymbol getBottom() {
        return new MappingElement(this.domain.getBottom(), this.image.getBottom());
    }

    private IEnumerableSymbol getPred1() {
        IEnumerableSymbol pred1 = this.domain.getPred();
        IEnumerableSymbol pred2 = this.image.getPred();
        if (pred1 == null && pred2 == null) {
            return null;
        }
        return new MappingElement(pred1, pred2);
    }

    private IEnumerableSymbol getSucc1() {
        IEnumerableSymbol succ1 = this.domain.getSucc();
        IEnumerableSymbol succ2 = this.image.getSucc();
        if (succ1 == null && succ2 == null) {
            IEnumerableSymbol min = this.domain.getMin();
            assert (min.equals(this.image.getMin()));
            return new MappingElement(min, min).getSucc2();
        }
        return new MappingElement(succ1, succ2);
    }

    private IEnumerableSymbol getPred2() {
        MappingElement p = null;
        IEnumerableSymbol pred1 = this.domain.getPred();
        if (pred1 == null) {
            IEnumerableSymbol pred2 = this.image.getPred();
            if (pred2 == null) {
                IEnumerableSymbol max = this.domain.getMax();
                assert (max.equals(this.image.getMax()));
                return new MappingElement(max, max);
            }
            p = new MappingElement(this.domain, pred2);
        } else {
            p = new MappingElement(pred1, this.image);
        }
        if (p.getDomain().equals(p.getImage())) {
            return p.getPred2();
        }
        return p;
    }

    private IEnumerableSymbol getSucc2() {
        MappingElement p = null;
        IEnumerableSymbol succ1 = this.domain.getSucc();
        if (succ1 == null) {
            IEnumerableSymbol succ2 = this.image.getSucc();
            if (succ2 == null) {
                return null;
            }
            p = new MappingElement(this.domain, succ2);
        } else {
            p = new MappingElement(succ1, this.image);
        }
        if (p.getDomain().equals(p.getImage())) {
            return p.getSucc2();
        }
        return p;
    }

    @Override
    public IEnumerableSymbol getPred() {
        if (this.domain.equals(this.image)) {
            return this.getPred1();
        }
        return this.getPred2();
    }

    @Override
    public IEnumerableSymbol getSucc() {
        if (this.domain.equals(this.image)) {
            return this.getSucc1();
        }
        return this.getSucc2();
    }

    public static Map<RangeSymbol, ISymbol> createApproximatedMapping(Collection<MappingElement> elems) {
        Collection<RangeSymbol> ranges = new HashSet<RangeSymbol>();
        for (MappingElement e : elems) {
            ranges.add(new RangeSymbol(e, e));
        }
        ranges = RangeSymbol.mergeRanges(ranges);
        HashMap<RangeSymbol, ISymbol> map = new HashMap<RangeSymbol, ISymbol>();
        for (RangeSymbol r : ranges) {
            MappingElement elemMin = (MappingElement)r.getMin();
            MappingElement elemMax = (MappingElement)r.getMax();
            RangeSymbol r1 = new RangeSymbol(elemMin.getDomain(), elemMax.getDomain());
            RangeSymbol r2 = new RangeSymbol(elemMin.getImage(), elemMax.getImage());
            assert (!map.containsKey(r1));
            if (r2.getMin().equals(r2.getMax())) {
                map.put(r1, r2.getMin());
                continue;
            }
            map.put(r1, r2);
        }
        return map;
    }

    @Override
    public int rangeCompareTo(IEnumerableSymbol s) {
        try {
            return this.compareTo(s);
        }
        catch (IComparableSymbol.NotComparableException e) {
            return this.getClass().toString().compareTo(s.getClass().toString());
        }
    }
}

