/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IComparableSymbol;
import com.ibm.wala.automaton.string.IEnumerableSymbol;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.ISymbolVisitor;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;

public class RangeSymbol
implements ISymbol {
    IEnumerableSymbol min;
    IEnumerableSymbol max;

    public RangeSymbol(IEnumerableSymbol min, IEnumerableSymbol max) {
        this.min = min;
        this.max = max;
    }

    public RangeSymbol(char min, char max) {
        this(new CharSymbol(min), new CharSymbol(max));
    }

    @Override
    public String getName() {
        return "[" + this.min.getName() + "-" + this.max.getName() + "]";
    }

    public String toString() {
        return "[" + this.min.toString() + "-" + this.max.toString() + "]";
    }

    public IEnumerableSymbol getMin() {
        return this.min;
    }

    public IEnumerableSymbol getMax() {
        return this.max;
    }

    @Override
    public boolean matches(ISymbol symbol, IMatchContext ctx) {
        IEnumerableSymbol cs;
        RangeSymbol r;
        if (symbol instanceof RangeSymbol && this.contains(r = (RangeSymbol)symbol)) {
            ctx.put(this, r);
            return true;
        }
        if (symbol instanceof IEnumerableSymbol && this.contains(cs = (IEnumerableSymbol)symbol)) {
            ctx.put(this, cs);
            return true;
        }
        return false;
    }

    @Override
    public boolean possiblyMatches(ISymbol symbol, IMatchContext ctx) {
        if (!(symbol instanceof IEnumerableSymbol)) {
            return false;
        }
        IEnumerableSymbol cs = (IEnumerableSymbol)symbol;
        if (this.contains(cs)) {
            ctx.put(this, cs);
            return true;
        }
        return false;
    }

    @Override
    public void traverse(ISymbolVisitor visitor) {
        visitor.onVisit(this);
        this.getMin().traverse(visitor);
        this.getMax().traverse(visitor);
        visitor.onLeave(this);
    }

    @Override
    public ISymbol copy(ISymbolCopier copier) {
        ISymbol s = copier.copy(this);
        if (s instanceof RangeSymbol) {
            RangeSymbol ps = (RangeSymbol)s;
            ps.max = (IEnumerableSymbol)copier.copySymbolReference(ps, ps.max);
            ps.min = (IEnumerableSymbol)copier.copySymbolReference(ps, ps.min);
        }
        return s;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        return 0;
    }

    public int hashCode() {
        return this.min.hashCode() * 13 + this.max.hashCode() * 37;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RangeSymbol)) {
            return false;
        }
        RangeSymbol psym = (RangeSymbol)obj;
        return this.min.equals(psym.min) && this.max.equals(psym.max);
    }

    public boolean contains(IEnumerableSymbol min, IEnumerableSymbol max) {
        return this.min.rangeCompareTo(min) <= 0 && this.max.rangeCompareTo(max) >= 0;
    }

    public boolean contains(RangeSymbol r) {
        return this.contains(r.getMin(), r.getMax());
    }

    public boolean contains(IEnumerableSymbol s) {
        try {
            return s.compareTo(this.min) >= 0 && this.max.compareTo(s) >= 0;
        }
        catch (IComparableSymbol.NotComparableException e) {
            return false;
        }
    }

    private static void collectBounds(ISymbol s, Collection<IEnumerableSymbol> bounds) {
        if (s instanceof IEnumerableSymbol) {
            IEnumerableSymbol e = (IEnumerableSymbol)s;
            bounds.add(e);
            bounds.add(e.getSucc());
            bounds.add(e.getMin());
            bounds.add(e.getTop());
        } else if (s instanceof RangeSymbol) {
            RangeSymbol r = (RangeSymbol)s;
            IEnumerableSymbol bmin = r.getMin();
            bounds.add(bmin);
            bounds.add(bmin.getMin());
            IEnumerableSymbol bmax = r.getMax().getSucc();
            bounds.add(bmax);
            bounds.add(bmax.getTop());
        }
    }

    private static void collectBounds(Collection<? extends ISymbol> symbols, Collection<IEnumerableSymbol> bounds) {
        for (ISymbol iSymbol : symbols) {
            RangeSymbol.collectBounds(iSymbol, bounds);
        }
    }

    public static Collection<RangeSymbol> splitRanges(Collection<RangeSymbol> ranges, Collection<ISymbol> terminals) {
        ArrayList<IEnumerableSymbol> bounds = new ArrayList<IEnumerableSymbol>();
        HashSet<IEnumerableSymbol> boundSet = new HashSet<IEnumerableSymbol>();
        RangeSymbol.collectBounds(ranges, boundSet);
        RangeSymbol.collectBounds(terminals, boundSet);
        bounds.addAll(boundSet);
        Collections.sort(bounds, new Comparator<IEnumerableSymbol>(){

            @Override
            public int compare(IEnumerableSymbol o1, IEnumerableSymbol o2) {
                return o1.rangeCompareTo(o2);
            }
        });
        HashSet<RangeSymbol> result = new HashSet<RangeSymbol>();
        Iterator i = bounds.iterator();
        if (i.hasNext()) {
            IEnumerableSymbol min = (IEnumerableSymbol)i.next();
            IEnumerableSymbol max = null;
            while (i.hasNext()) {
                max = (IEnumerableSymbol)i.next();
                if (min.rangeCompareTo(max) < 0) {
                    for (RangeSymbol r : ranges) {
                        if (!r.contains(min, max.getPred())) continue;
                        result.add(new RangeSymbol(min, max.getPred()));
                        break;
                    }
                }
                min = max;
            }
        }
        return result;
    }

    public static Collection<RangeSymbol> splitRanges(Collection<RangeSymbol> ranges) {
        return RangeSymbol.splitRanges(ranges, new HashSet<ISymbol>());
    }

    public static Collection<RangeSymbol> splitRanges(RangeSymbol range, Collection<ISymbol> terminals) {
        HashSet<RangeSymbol> ranges = new HashSet<RangeSymbol>();
        ranges.add(range);
        return RangeSymbol.splitRanges(ranges, terminals);
    }

    public static Collection<ISymbol> unrange(Collection<? extends ISymbol> ranges) {
        HashSet<ISymbol> s = new HashSet<ISymbol>();
        for (ISymbol iSymbol : ranges) {
            s.add(RangeSymbol.unrange(iSymbol));
        }
        return s;
    }

    public static ISymbol unrange(ISymbol s) {
        if (s instanceof RangeSymbol) {
            RangeSymbol r = (RangeSymbol)s;
            if (r.getMin().equals(r.getMax())) {
                return r.getMin();
            }
            return r;
        }
        return s;
    }

    public static Collection<RangeSymbol> complement(RangeSymbol r) {
        HashSet<RangeSymbol> result = new HashSet<RangeSymbol>();
        result.add(new RangeSymbol(r.getMin().getMin(), r.getMin()));
        result.add(new RangeSymbol(r.getMax(), r.getMax().getMax()));
        return result;
    }

    public static RangeSymbol intersection(RangeSymbol r1, RangeSymbol r2) {
        Collection<RangeSymbol> ranges = new HashSet<RangeSymbol>();
        ranges.add(r1);
        ranges.add(r2);
        ranges = RangeSymbol.splitRanges(ranges);
        for (RangeSymbol r : ranges) {
            if (!r1.contains(r) || !r2.contains(r)) continue;
            return r;
        }
        return null;
    }

    public static Collection<RangeSymbol> mergeRanges(Collection<RangeSymbol> ranges) {
        ArrayList<RangeSymbol> sortedRanges = new ArrayList<RangeSymbol>();
        sortedRanges.addAll(ranges);
        Collections.sort(sortedRanges, new Comparator<RangeSymbol>(){

            @Override
            public int compare(RangeSymbol o1, RangeSymbol o2) {
                IEnumerableSymbol min1 = o1.getMin();
                IEnumerableSymbol min2 = o2.getMin();
                try {
                    return min1.compareTo(min2);
                }
                catch (IComparableSymbol.NotComparableException e) {
                    return 0;
                }
            }
        });
        IEnumerableSymbol min = null;
        IEnumerableSymbol max = null;
        HashSet<RangeSymbol> newRanges = new HashSet<RangeSymbol>();
        for (RangeSymbol r : sortedRanges) {
            if (min == null) {
                min = r.getMin();
                max = r.getMax();
                continue;
            }
            IEnumerableSymbol rMin = r.getMin();
            IEnumerableSymbol succ = max.getSucc();
            try {
                if (min.compareTo(rMin) <= 0 && rMin.compareTo(succ) <= 0) {
                    IEnumerableSymbol rMax = r.getMax();
                    if (max.compareTo(rMax) > 0) continue;
                    max = r.getMax();
                    continue;
                }
                RangeSymbol newRange = new RangeSymbol(min, max);
                newRanges.add(newRange);
                min = r.getMin();
                max = r.getMax();
            }
            catch (IComparableSymbol.NotComparableException e) {
                Assertions.UNREACHABLE();
            }
        }
        if (min != null) {
            RangeSymbol newRange = new RangeSymbol(min, max);
            newRanges.add(newRange);
        }
        return newRanges;
    }

    private static void splitNonChars(Collection<? extends ISymbol> symbols, Collection<ISymbol> chars, Collection<ISymbol> nonChars) {
        for (ISymbol iSymbol : symbols) {
            RangeSymbol r;
            if (iSymbol instanceof CharSymbol) {
                chars.add(iSymbol);
                continue;
            }
            if (iSymbol instanceof RangeSymbol && (r = (RangeSymbol)iSymbol).getMin() instanceof CharSymbol) {
                chars.add(iSymbol);
                continue;
            }
            nonChars.add(iSymbol);
        }
    }

    public static Collection<ISymbol> mergeSymbols(Collection<? extends ISymbol> symbols) {
        return RangeSymbol.mergeSymbols(symbols, CharSymbol.class);
    }

    public static Collection<ISymbol> mergeSymbols(Collection<? extends ISymbol> symbols, Class<? extends IEnumerableSymbol> klass) {
        Collection<Object> ranges = new HashSet();
        HashSet<ISymbol> chars = new HashSet<ISymbol>();
        HashSet<ISymbol> result = new HashSet<ISymbol>();
        RangeSymbol.splitNonChars(symbols, chars, result);
        ranges = RangeSymbol.splitSymbols(chars, result, klass);
        ranges = RangeSymbol.mergeRanges(ranges);
        for (RangeSymbol rangeSymbol : ranges) {
            if (rangeSymbol.getMin().equals(rangeSymbol.getMax())) {
                result.add(rangeSymbol.getMin());
                continue;
            }
            result.add(rangeSymbol);
        }
        return result;
    }

    public static Collection<ISymbol> splitSymbols(Collection<ISymbol> symbols) {
        return RangeSymbol.splitSymbols(symbols, CharSymbol.class);
    }

    public static Collection<ISymbol> splitSymbols(Collection<ISymbol> symbols, Class<? extends IEnumerableSymbol> klass) {
        HashSet<ISymbol> result = new HashSet<ISymbol>();
        Collection<RangeSymbol> ranges = RangeSymbol.splitSymbols(symbols, result, klass);
        for (RangeSymbol range : ranges) {
            if (range.getMin().equals(range.getMax())) {
                result.add(range.getMin());
                continue;
            }
            result.add(range);
        }
        return result;
    }

    private static Collection<RangeSymbol> splitSymbols(Collection<ISymbol> symbols, Collection<ISymbol> nonRanges, Class<? extends IEnumerableSymbol> klass) {
        Collection<RangeSymbol> ranges = new HashSet<RangeSymbol>();
        for (ISymbol s : symbols) {
            if (klass.isInstance(s)) {
                ranges.add(new RangeSymbol((IEnumerableSymbol)s, (IEnumerableSymbol)s));
                continue;
            }
            if (s instanceof RangeSymbol) {
                ranges.add((RangeSymbol)s);
                continue;
            }
            nonRanges.add(s);
        }
        ranges = RangeSymbol.splitRanges(ranges);
        return ranges;
    }
}

