/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.tree;

import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.ISymbolVisitor;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.Symbol;
import com.ibm.wala.automaton.tree.DeepBinaryTreeCopier;
import com.ibm.wala.automaton.tree.IBinaryTree;
import com.ibm.wala.automaton.tree.IBinaryTreeCopier;
import com.ibm.wala.automaton.tree.IParentBinaryTree;

public class BinaryTree
implements IParentBinaryTree {
    public static IBinaryTree LEAF = new Leaf("#");
    private ISymbol label;
    private IBinaryTree left;
    private IBinaryTree right;

    public BinaryTree(ISymbol label) {
        this(label, LEAF, LEAF);
    }

    public BinaryTree(String label) {
        this(new StringSymbol(label));
    }

    public BinaryTree(ISymbol label, IBinaryTree left, IBinaryTree right) {
        if (label == null) {
            throw new RuntimeException("should not be null.");
        }
        this.label = label;
        this.setLeft(left);
        this.setRight(right);
    }

    public BinaryTree(String label, IBinaryTree left, IBinaryTree right) {
        this(new StringSymbol(label), left, right);
    }

    @Override
    public ISymbol getLabel() {
        return this.label;
    }

    @Override
    public IBinaryTree getLeft() {
        return this.left;
    }

    @Override
    public IBinaryTree getRight() {
        return this.right;
    }

    @Override
    public void setLeft(IBinaryTree tree) {
        this.left = tree == null ? LEAF : tree;
    }

    @Override
    public void setRight(IBinaryTree tree) {
        this.right = tree == null ? LEAF : tree;
    }

    @Override
    public String getName() {
        return this.label.getName();
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        BinaryTree btree = (BinaryTree)obj;
        return this.label.equals(btree.getLabel()) && this.left.equals(btree.getLeft()) && this.right.equals(btree.getRight());
    }

    @Override
    public boolean matches(ISymbol symbol, IMatchContext ctx) {
        if (!(symbol instanceof IParentBinaryTree)) {
            return false;
        }
        IParentBinaryTree tree = (IParentBinaryTree)symbol;
        if (this.label.matches(tree.getLabel(), ctx) && this.left.matches(tree.getLeft(), ctx) && this.right.matches(tree.getRight(), ctx)) {
            ctx.put(this, symbol);
            return true;
        }
        return false;
    }

    @Override
    public boolean possiblyMatches(ISymbol symbol, IMatchContext ctx) {
        if (!(symbol instanceof IParentBinaryTree)) {
            return false;
        }
        IParentBinaryTree tree = (IParentBinaryTree)symbol;
        if (this.label.possiblyMatches(tree.getLabel(), ctx) && this.left.possiblyMatches(tree.getLeft(), ctx) && this.right.possiblyMatches(tree.getRight(), ctx)) {
            ctx.put(this, symbol);
            return true;
        }
        return false;
    }

    @Override
    public void traverse(ISymbolVisitor visitor) {
        visitor.onVisit(this);
        this.label.traverse(visitor);
        this.left.traverse(visitor);
        this.right.traverse(visitor);
        visitor.onLeave(this);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ISymbol copy(ISymbolCopier copier) {
        IBinaryTreeCopier btCopier = null;
        btCopier = copier instanceof IBinaryTreeCopier ? (IBinaryTreeCopier)copier : new DeepBinaryTreeCopier(copier);
        ISymbol s = btCopier.copy(this);
        if (s instanceof BinaryTree) {
            BinaryTree bt = (BinaryTree)s;
            bt.label = btCopier.copyLabel(bt, bt.label);
            bt.left = (IBinaryTree)btCopier.copySymbolReference(bt, bt.left);
            bt.right = (IBinaryTree)btCopier.copySymbolReference(bt, bt.right);
        }
        return s;
    }

    @Override
    public int size() {
        return 2;
    }

    public String toString() {
        return this.label.toString() + "[" + this.left.toString() + ", " + this.right.toString() + "]";
    }

    protected static class Leaf
    extends Symbol
    implements IBinaryTree {
        public Leaf(String name) {
            super(name);
        }

        @Override
        public ISymbol getLabel() {
            return this;
        }
    }
}

