/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.scanners.sast;

import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.error.InvalidTargetException;
import com.hcl.appscan.sdk.error.ScannerException;
import com.hcl.appscan.sdk.logging.DefaultProgress;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.scan.IScanServiceProvider;
import com.hcl.appscan.sdk.scanners.ASoCScan;
import com.hcl.appscan.sdk.scanners.sast.SAClient;
import com.hcl.appscan.sdk.scanners.sast.SASTConstants;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.util.Map;

public class SASTScan
extends ASoCScan
implements SASTConstants {
    private static final long serialVersionUID = 1L;
    private static final String REPORT_FORMAT = "html";
    private File m_irx;

    public SASTScan(Map<String, String> properties, IScanServiceProvider provider) {
        super(properties, new DefaultProgress(), provider);
    }

    public SASTScan(Map<String, String> properties, IProgress progress, IScanServiceProvider provider) {
        super(properties, progress, provider);
    }

    @Override
    public void run() throws ScannerException, InvalidTargetException {
        String target = this.getTarget();
        if (target == null || !new File(target).exists()) {
            throw new InvalidTargetException(Messages.getMessage("error.target.invalid", target));
        }
        try {
            this.generateIR();
            this.analyzeIR();
        }
        catch (IOException e) {
            throw new ScannerException(Messages.getMessage("error.scan.failed", e.getLocalizedMessage()));
        }
    }

    @Override
    public String getType() {
        return "Static Analyzer";
    }

    @Override
    public String getReportFormat() {
        return REPORT_FORMAT;
    }

    public File getIrx() {
        return this.m_irx;
    }

    private void generateIR() throws IOException, ScannerException {
        File targetFile = new File(this.getTarget());
        if (targetFile.getName().endsWith(".irx") && targetFile.isFile()) {
            this.m_irx = targetFile;
            return;
        }
        String targetDir = targetFile.isDirectory() ? targetFile.getAbsolutePath() : targetFile.getParent();
        Proxy proxy = this.getServiceProvider() == null ? Proxy.NO_PROXY : this.getServiceProvider().getAuthenticationProvider().getProxy();
        new SAClient(this.getProgress(), proxy).run(targetDir, this.getProperties());
        String irxDir = this.getProperties().containsKey("irxDir") ? this.getProperties().get("irxDir") : targetDir;
        this.m_irx = new File(irxDir, this.getName() + ".irx");
        if (!this.m_irx.isFile()) {
            throw new ScannerException(Messages.getMessage("error.generating.irx", this.getScanLogs().getAbsolutePath()));
        }
    }

    private void analyzeIR() throws IOException, ScannerException {
        if (this.getProperties().containsKey("prepareOnly")) {
            return;
        }
        String fileId = this.getServiceProvider().submitFile(this.m_irx);
        if (fileId == null) {
            throw new ScannerException(Messages.getMessage("error.file.upload", this.m_irx.getName()));
        }
        Map<String, String> params = this.getProperties();
        params.put("ARSAFileId", fileId);
        this.setScanId(this.getServiceProvider().createAndExecuteScan("StaticAnalyzer", params));
        if (this.getScanId() == null) {
            throw new ScannerException(Messages.getMessage("error.submitting.irx", new Object[0]));
        }
    }

    private File getScanLogs() {
        if (this.m_irx == null) {
            return new File("logs");
        }
        String logsFile = this.m_irx.getName();
        logsFile = logsFile.substring(0, logsFile.lastIndexOf("."));
        logsFile = logsFile + "_logs.zip";
        return new File(this.m_irx.getParentFile(), logsFile);
    }
}

