/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.internal.discovery.iac;

import com.hcl.appscan.discovery.iac.IaCConstants;
import com.hcl.appscan.internal.discovery.iac.IaCStrategy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.dir.BaseCustomCollector;
import java.io.File;
import java.util.Set;
import java.util.regex.Pattern;

public class IaCCollector
extends BaseCustomCollector
implements IaCConstants {
    private Pattern message_file_pattern = Pattern.compile("(?i)messages.*\\.(yaml|yml|properties)$");

    public IaCCollector(File crawlRoot, Set<StringPattern> includes, Set<StringPattern> excludes) {
        super(crawlRoot, includes, excludes);
    }

    public String getType() {
        return "IaCCollector";
    }

    protected String getFileExtensionSetName() {
        return "iac";
    }

    protected ScanTargetStrategy getScanTargetStrategy(ScanTargetStrategy parentStrategy) {
        return new IaCStrategy(this.getCrawlRoot(), this.getScanFiles());
    }

    protected boolean acceptFile(File file) {
        if (this.message_file_pattern.matcher(file.getName()).find()) {
            return false;
        }
        String extension = FileUtil.getFileExtension((File)file);
        if (extension.equalsIgnoreCase("ps1") || file.getName().equalsIgnoreCase("default.json") || file.getName().equalsIgnoreCase("config.json") || file.getName().equalsIgnoreCase("credentials.json") || this.isAppsettingsFile(file)) {
            return SystemUtil.isSecretsScanningEnabled() || SystemUtil.isSecretsOnly();
        }
        return file.getName().toLowerCase().endsWith("tf.json") || file.getName().equalsIgnoreCase("DockerFile") || file.getName().equalsIgnoreCase("docker-compose") || super.acceptFile(file);
    }

    private boolean isAppsettingsFile(File file) {
        return file.getName().toLowerCase().startsWith("appsettings.") && file.getName().toLowerCase().endsWith(".json");
    }
}

