/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.exclude;

import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.exclude.ExclusionFileInformation;
import com.ibm.appscan.exclude.ExclusionProvider;
import com.ibm.appscan.exclude.ExclusionScope;
import com.ibm.appscan.exclude.exclusions.BaseExclusion;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import com.ibm.appscan.exclude.exclusions.ExclusionWriter;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class Loader
extends ExclusionFileInformation {
    public Loader(BaseExclusion e) throws ExclusionException {
        super(e);
        this.load();
    }

    public Loader(BaseExclusion e, Map<String, ExclusionScope> items, ExclusionProvider.EXCLUSION_TYPE type) throws ExclusionException {
        super(e);
        this.load(items, type);
    }

    public void load() throws ExclusionException {
        this.load(false);
    }

    public void load(boolean reset) throws ExclusionException {
        boolean load_exclude = this.loadXML(ExclusionProvider.EXCLUSION_TYPE.EXCLUSION);
        boolean load_include = this.loadXML(ExclusionProvider.EXCLUSION_TYPE.INCLUSION);
        if (reset || !load_exclude && !load_include) {
            this.loadFromJar();
            ExclusionWriter writer = new ExclusionWriter(this.getExclusion());
            writer.write();
        }
    }

    private void loadFromJar() throws ExclusionException {
        if (this.getExclusion().hasPackages()) {
            HashSet<String> packages = this.getManualList("packages", ExclusionProvider.EXCLUSION_TYPE.EXCLUSION);
            this.getExclusion().getExcludedPackages().addAll(packages);
            this.getExclusion().getIncludedPackages().addAll(this.getManualList("packages", ExclusionProvider.EXCLUSION_TYPE.INCLUSION));
        }
        if (this.getExclusion().hasClasses()) {
            HashSet<String> classes = new HashSet<String>(this.getManualList("classes", ExclusionProvider.EXCLUSION_TYPE.EXCLUSION));
            this.getExclusion().getExcludedClasses().addAll(classes);
        }
        if (this.getExclusion().hasMethods()) {
            HashSet<String> methods = new HashSet<String>(this.getManualList("methods", ExclusionProvider.EXCLUSION_TYPE.EXCLUSION));
            this.getExclusion().getExcludedMethods().addAll(methods);
        }
        if (this.getExclusion().hasFiles()) {
            this.getExclusion().getExcludedFiles().addAll(this.getManualList("files", ExclusionProvider.EXCLUSION_TYPE.EXCLUSION));
        }
        this.getExclusion().getAutoMarkupPackages().addAll(this.getManualList("auto.packages", ExclusionProvider.EXCLUSION_TYPE.EXCLUSION));
    }

    private boolean loadXML(ExclusionProvider.EXCLUSION_TYPE type) throws ExclusionException {
        XMLStreamReader reader = null;
        try {
            reader = this.getReader(type);
            if (reader == null) {
                return false;
            }
            int eventType = reader.getEventType();
            while (reader.hasNext()) {
                eventType = reader.next();
                switch (eventType) {
                    case 1: {
                        if (reader.getLocalName().toLowerCase().equals("method") && this.getExclusion().hasMethods()) {
                            this.getExclusion().getExcludedMethods().add(reader.getAttributeValue(0));
                            break;
                        }
                        if (reader.getLocalName().toLowerCase().equals("package") && this.getExclusion().hasPackages()) {
                            if (type == ExclusionProvider.EXCLUSION_TYPE.EXCLUSION) {
                                this.getExclusion().getExcludedPackages().add(reader.getAttributeValue(0));
                                break;
                            }
                            this.getExclusion().getIncludedPackages().add(reader.getAttributeValue(0));
                            break;
                        }
                        if (reader.getLocalName().toLowerCase().equals("class") && this.getExclusion().hasClasses()) {
                            this.getExclusion().getExcludedClasses().add(reader.getAttributeValue(0));
                            break;
                        }
                        if (!reader.getLocalName().toLowerCase().equals("file") || !this.getExclusion().hasFiles()) break;
                        this.getExclusion().getExcludedFiles().add(reader.getAttributeValue(0));
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new ExclusionException(e);
        }
        return true;
    }

    @SuppressSecurityTrace
    protected HashSet<String> getManualList(String type, ExclusionProvider.EXCLUSION_TYPE excl_type) throws ExclusionException {
        HashSet<String> ret = new HashSet<String>();
        InputStream in = this.getClass().getResourceAsStream("/" + this.getExclusion().getExclusionLanguage().toVdbString() + ".manual." + type + "." + excl_type.toString());
        if (in != null) {
            BufferedReader reader = null;
            String line = null;
            try {
                reader = new BufferedReader(new InputStreamReader(in));
                while ((line = reader.readLine()) != null) {
                    ret.add(line);
                }
            }
            catch (IOException e) {
                try {
                    throw new ExclusionException(e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(reader);
                    throw throwable;
                }
            }
            IOUtil.close((Closeable)reader);
        }
        return ret;
    }

    private XMLStreamReader getReader(ExclusionProvider.EXCLUSION_TYPE type) throws ExclusionException {
        XMLStreamReader reader;
        File f;
        File file = f = type == ExclusionProvider.EXCLUSION_TYPE.EXCLUSION ? this.getExclusionFile() : this.getInclusionFile();
        if (!f.exists()) {
            return null;
        }
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            reader = factory.createXMLStreamReader(new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            throw new ExclusionException(e);
        }
        catch (XMLStreamException e) {
            throw new ExclusionException(e);
        }
        return reader;
    }

    private void load(Map<String, ExclusionScope> items, ExclusionProvider.EXCLUSION_TYPE type) throws ExclusionException {
        if (items == null) {
            return;
        }
        for (String item : items.keySet()) {
            switch (items.get(item)) {
                case PACKAGE: {
                    if (!this.getExclusion().hasPackages()) break;
                    if (type == ExclusionProvider.EXCLUSION_TYPE.EXCLUSION) {
                        this.getExclusion().getExcludedPackages().add(item);
                        break;
                    }
                    this.getExclusion().getIncludedPackages().add(item);
                    break;
                }
                case CLASS: {
                    if (!this.getExclusion().hasClasses()) break;
                    if (type == ExclusionProvider.EXCLUSION_TYPE.EXCLUSION) {
                        this.getExclusion().getExcludedClasses().add(item);
                        break;
                    }
                    this.getExclusion().getIncludedClasses().add(item);
                    break;
                }
                case METHOD: {
                    if (!this.getExclusion().hasMethods()) break;
                    if (type == ExclusionProvider.EXCLUSION_TYPE.EXCLUSION) {
                        this.getExclusion().getExcludedMethods().add(item);
                        break;
                    }
                    this.getExclusion().getIncludedMethods().add(item);
                    break;
                }
            }
        }
    }
}

