/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup.trainer;

import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.markup.data.MarkupActiveFeatures;
import com.ibm.appscan.ica.markup.trainer.MarkupTrainer;
import com.ibm.appscan.ifa.common.IfaException;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.ao.ActionObject;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.rule.Rule;

public class SinkArgTrainer
extends MarkupTrainer {
    @Override
    public boolean hasMarkup(Method m) {
        return m.getSinks().size() > 0;
    }

    @Override
    protected void applyMarkup(Method m, String markupString) throws MarkupException, BadMarkupException {
    }

    @Override
    public String predict_(Method m) throws MarkupException, IfaException {
        StringBuffer str = new StringBuffer();
        int i = 1;
        for (String a : m.getArgs()) {
            try {
                String simple = m.getSimpleArg(a);
                if (VdbProvider.isBoolean((String)simple) || VdbProvider.isNumber((String)simple) || VdbProvider.isTimeDateType((String)simple)) continue;
                str.append(Integer.toString(i));
                str.append(",");
                ++i;
            }
            catch (VDBException e) {
                throw new IfaException((Throwable)e);
            }
        }
        if (str.length() <= 1) {
            return "default";
        }
        str.deleteCharAt(str.length() - 1);
        return str.toString();
    }

    @Override
    public String getMarkupString(Method m) throws MarkupException {
        return this.hasMarkup(m) ? ((ActionObject)m.getSinks().get(0)).getParameter().toString() : "0";
    }

    @Override
    protected MarkupActiveFeatures.MARKUP_FEATURES getFeature() {
        return MarkupActiveFeatures.MARKUP_FEATURES.SINK_ARG;
    }

    @Override
    protected String getMarkupType() {
        return "sink_arg";
    }

    @Override
    protected void initRules() throws MarkupException, BadRuleException {
        Rule r = new Rule();
        r.setRuleName("1 arg - sink arg");
        r.getMethodRule().getArgCountRule().setRuleOperator(VDBEnums.RULE_OPERATOR.INTEGER_EQUALS);
        r.getMethodRule().getArgCountRule().setArgCountValue(1);
        r.getActionObjectRule().setParameter("1");
        this.getRules().add(r);
    }

    @Override
    protected void initAntiRules() throws MarkupException, BadRuleException {
    }

    @Override
    public String getMarkupFromRule(Method m) throws MarkupException {
        for (Rule r : this.getRules()) {
            if (!r.isMatch(m)) continue;
            return r.getActionObjectRule().getParameter();
        }
        return null;
    }

    @Override
    public boolean useNoMarkupMethods() {
        return false;
    }

    @Override
    protected String getAntiMatch() {
        return null;
    }
}

