/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.jaxwshandler.utils;

import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.jaxwshandler.utils.JAXWSUtils;
import com.ibm.appscan.frameworks.wsdl.util.internal.ServiceReportingUtil;
import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class JAXWSToWSDLUtil {
    public static final String TARGET_NAMESPACE = "targetNamespace";
    public static final String SERVICE_NAME = "serviceName";
    public static final String SERVICE_SUFFIX = "Service";
    public static final String OPERATION_NAME = "operationName";
    public static final String XMLTYPE_NAMESPACE_ATTR = "namespace";

    private static String classNameToTargetNamespace(String fqClassName) {
        StringBuilder targetNamespace = new StringBuilder();
        String packageName = JAXWSUtils.convertToSimpleName(fqClassName);
        packageName = packageName.substring(0, packageName.lastIndexOf("."));
        String[] packageFragments = packageName.split("\\.");
        targetNamespace.append("http://");
        for (int index = packageFragments.length - 1; index >= 0; --index) {
            targetNamespace.append(packageFragments[index] + ".");
        }
        targetNamespace.deleteCharAt(targetNamespace.length() - 1);
        targetNamespace.append("/");
        return targetNamespace.toString();
    }

    private static Annotation getWebServiceAnnotation(F4FApp app, IClass clazz) {
        Annotation webServiceAnnotation = JAXWSUtils.getAnnotation(app, clazz, "Ljavax/jws/WebService");
        if (webServiceAnnotation == null) {
            webServiceAnnotation = JAXWSUtils.getAnnotation(app, clazz, "Ljavax/xml/ws/WebServiceProvider");
        }
        return webServiceAnnotation;
    }

    public static String getTargetNamespace(F4FApp app, IClass clazz) {
        Annotation webServiceAnnotation = JAXWSToWSDLUtil.getWebServiceAnnotation(app, clazz);
        String targetNamespace = null;
        if (webServiceAnnotation != null && (targetNamespace = JAXWSToWSDLUtil.getAnnotationAttrValue(app, webServiceAnnotation, TARGET_NAMESPACE)) != null) {
            return targetNamespace;
        }
        Annotation xmlTypeAnnotation = JAXWSUtils.getAnnotation(app, clazz, "Ljavax/xml/bind/annotation/XmlType");
        if (xmlTypeAnnotation != null) {
            targetNamespace = JAXWSToWSDLUtil.getAnnotationAttrValue(app, xmlTypeAnnotation, XMLTYPE_NAMESPACE_ATTR);
            return targetNamespace;
        }
        targetNamespace = JAXWSToWSDLUtil.classNameToTargetNamespace(clazz.getName().toString());
        return targetNamespace;
    }

    private static String getAnnotationAttrValue(F4FApp app, Annotation webServiceAnnotation, String attributeName) {
        Map namedArgs = webServiceAnnotation.getNamedArguments();
        if (namedArgs != null && namedArgs.containsKey(attributeName)) {
            String attrValue = ((AnnotationsReader.ElementValue)namedArgs.get(attributeName)).toString();
            return attrValue;
        }
        return null;
    }

    public static String getServiceName(F4FApp app, IClass clazz) {
        Annotation webServiceAnnotation = JAXWSToWSDLUtil.getWebServiceAnnotation(app, clazz);
        String serviceName = null;
        if (webServiceAnnotation != null && (serviceName = JAXWSToWSDLUtil.getAnnotationAttrValue(app, webServiceAnnotation, SERVICE_NAME)) != null) {
            return serviceName;
        }
        String qNClassName = clazz.getName().toString();
        String classNameOnly = qNClassName.substring(qNClassName.lastIndexOf("/") + 1);
        serviceName = classNameOnly + SERVICE_SUFFIX;
        return serviceName;
    }

    public static String getOperationName(F4FApp app, IMethod method) {
        Annotation webMethodAnnotation = JAXWSUtils.getAnnotation(app, method, "Ljavax/jws/WebMethod");
        String operationName = null;
        if (webMethodAnnotation != null && (operationName = JAXWSToWSDLUtil.getAnnotationAttrValue(app, webMethodAnnotation, OPERATION_NAME)) != null && operationName.length() != 0) {
            return operationName;
        }
        operationName = method.getName().toString();
        return operationName;
    }

    public static ArrayList<String> convertJavaParamToWSDL(F4FApp app, IMethod method, String defaultTNS) {
        ArrayList<String> wsdlTypes = new ArrayList<String>();
        Collection[] methodParamAnnotations = app.getMethodParametersAnnotations(method);
        for (int index = 1; index < method.getNumberOfParameters(); ++index) {
            int actualParamIndex = index - 1;
            Collection paramAnnotationColl = methodParamAnnotations[actualParamIndex];
            JAXWSUtils.WebParamDirection paramDirection = JAXWSUtils.getWebPramDirection(paramAnnotationColl);
            if (paramDirection == JAXWSUtils.WebParamDirection.OUT) continue;
            String wsdlType = null;
            TypeReference argType = method.getParameterType(index);
            IClass typeClass = method.getDeclaringClass().getClassHierarchy().lookupClass(argType);
            if (typeClass != null) {
                String type;
                if (paramDirection == JAXWSUtils.WebParamDirection.IN_OUT || paramDirection == JAXWSUtils.WebParamDirection.IN) {
                    type = JAXWSUtils.getHolderType(method, index);
                    if (type != null) {
                        wsdlType = ServiceReportingUtil.convertJavaTypeToWSDL(app, type, defaultTNS);
                    }
                } else if (JAXWSUtils.findInterface(typeClass, "Ljava/util/Collection") != null && (type = JAXWSUtils.getHolderType(method, index)) != null) {
                    wsdlType = ServiceReportingUtil.convertJavaTypeToWSDL(app, type, defaultTNS);
                    wsdlType = wsdlType + "[]";
                }
            }
            if (wsdlType == null) {
                wsdlType = ServiceReportingUtil.convertJavaTypeToWSDL(app, argType, defaultTNS);
                if (typeClass instanceof ArrayClass && !"[B".equals(argType.getName().toString())) {
                    wsdlType = wsdlType + "[]";
                }
            }
            wsdlTypes.add(wsdlType);
        }
        return wsdlTypes;
    }
}

