/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.jsf2;

import com.ibm.appscan.frameworks.handlers.jsf2.FacesConfigParser;
import com.ibm.appscan.frameworks.handlers.jsf2.JSFBeanScope;
import com.ibm.appscan.frameworks.handlers.jsf2.Jsf2GeneralUtil;
import com.ibm.appscan.frameworks.handlers.jsf2.JsfConfigurationManager;
import com.ibm.appscan.frameworks.handlers.jsf2.ManagedBean;
import com.ibm.appscan.frameworks.handlers.jsf2.NavigationCaseInfo;
import com.ibm.appscan.frameworks.handlers.jsf2.Validator;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.types.annotations.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsfInfoManager {
    private JsfConfigurationManager m_jsfConfigManager;
    private List<Validator> m_validators = new ArrayList<Validator>();
    private Map<String, List<NavigationCaseInfo>> m_fromViewId2ToViewId = new HashMap<String, List<NavigationCaseInfo>>();
    private Map<String, ManagedBean> m_beanMap = new HashMap<String, ManagedBean>();
    private String m_webDirectory;
    private F4FApp m_app;

    public JsfInfoManager(JsfConfigurationManager jsfConfigManager, F4FApp app, String webPath) {
        this.m_jsfConfigManager = jsfConfigManager;
        this.m_app = app;
        this.m_webDirectory = webPath;
    }

    public void addManagedBean(ManagedBean bean) {
        this.m_beanMap.put(bean.getName(), bean);
    }

    private List<String> getConcreteFileNames(String viewIdPattern) {
        ArrayList<String> concreteFileNames = new ArrayList<String>();
        if (!viewIdPattern.contains("*")) {
            concreteFileNames.add(Jsf2GeneralUtil.combineFilePath(this.m_webDirectory, viewIdPattern));
            return concreteFileNames;
        }
        if (viewIdPattern.equalsIgnoreCase("*")) {
            return this.m_jsfConfigManager.getViewFiles();
        }
        if (viewIdPattern.endsWith("*")) {
            String viewIdWithoutAsterisk = viewIdPattern.substring(0, viewIdPattern.length() - 1);
            String viewIdPrefix = Jsf2GeneralUtil.combineFilePath(this.m_webDirectory, viewIdWithoutAsterisk);
            List<String> viewFileList = this.m_jsfConfigManager.getViewFiles();
            for (String viewName : viewFileList) {
                if (!viewName.startsWith(viewIdPrefix)) continue;
                concreteFileNames.add(viewName);
            }
            return concreteFileNames;
        }
        TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.getting.from", (Object[])new Object[]{"concrete file", viewIdPattern}));
        return concreteFileNames;
    }

    public void addForward(String fromViewId, List<NavigationCaseInfo> toViewInfoList) {
        ArrayList<NavigationCaseInfo> toViewConcreteFileNames = new ArrayList<NavigationCaseInfo>();
        for (NavigationCaseInfo toViewInfo : toViewInfoList) {
            List<String> concreteFileNames = this.getConcreteFileNames(toViewInfo.getToViewId());
            for (String concreteFileName : concreteFileNames) {
                NavigationCaseInfo ncInfo = NavigationCaseInfo.make(toViewInfo.getFromOutcome(), concreteFileName, toViewInfo.getFilePositionInfo());
                if (toViewConcreteFileNames.contains(ncInfo)) continue;
                toViewConcreteFileNames.add(ncInfo);
            }
        }
        List<String> fromViewConcreteFileNames = this.getConcreteFileNames(fromViewId);
        for (String fromViewFileName : fromViewConcreteFileNames) {
            List<NavigationCaseInfo> oldToViewInfoList = this.m_fromViewId2ToViewId.get(fromViewFileName);
            if (oldToViewInfoList == null) {
                this.m_fromViewId2ToViewId.put(fromViewFileName, toViewConcreteFileNames);
                continue;
            }
            this.mergeList(oldToViewInfoList, toViewConcreteFileNames);
        }
    }

    public void addValidator(Validator validator) {
        this.m_validators.add(validator);
    }

    public void populateBeansForwardsAndValidators() {
        this.populateBeansFromJavaAnnotations();
        this.populateValidatorsBeansForwards();
    }

    private void populateBeansFromJavaAnnotations() {
        ArrayList theSetterMethods = new ArrayList();
        try {
            Collection theClasses = this.m_app.getAllApplicationClasses();
            for (IClass currentClass : theClasses) {
                theSetterMethods.clear();
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.class.found", (Object[])new Object[]{currentClass.getName().toString()}));
                Collection classAnnotations = this.m_app.getClassAnnotations(currentClass);
                String beanName = null;
                JSFBeanScope beanScope = null;
                for (Annotation annot : classAnnotations) {
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{annot.getType().toString()}));
                    if (annot.getType().toString().contains("javax/inject/Named")) {
                        if (annot.getNamedArguments().size() == 0) {
                            beanName = currentClass.getName().getClassName().toString();
                            beanName = beanName.substring(0, 1).toLowerCase() + beanName.substring(1);
                            continue;
                        }
                        beanName = ((AnnotationsReader.ElementValue)annot.getNamedArguments().get("value")).toString();
                        continue;
                    }
                    if (annot.getType().toString().contains("ManagedBean")) {
                        if (annot.getNamedArguments().size() == 0) {
                            beanName = currentClass.getName().getClassName().toString();
                            beanName = beanName.substring(0, 1).toLowerCase() + beanName.substring(1);
                            continue;
                        }
                        beanName = ((AnnotationsReader.ElementValue)annot.getNamedArguments().get("name")).toString();
                        continue;
                    }
                    if (annot.getType().toString().contains("ApplicationScoped")) {
                        beanScope = JSFBeanScope.Application;
                        continue;
                    }
                    if (annot.getType().toString().contains("SessionScoped")) {
                        beanScope = JSFBeanScope.Session;
                        continue;
                    }
                    if (annot.getType().toString().contains("RequestScoped")) {
                        beanScope = JSFBeanScope.Request;
                        continue;
                    }
                    if (annot.getType().toString().contains("NoneScoped")) {
                        beanScope = JSFBeanScope.None;
                        continue;
                    }
                    if (annot.getType().toString().contains("ViewScoped")) {
                        beanScope = JSFBeanScope.View;
                        continue;
                    }
                    if (!annot.getType().toString().contains("Scoped")) continue;
                    beanScope = JSFBeanScope.None;
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.unknown.scope", (Object[])new Object[]{annot.getType().toString()}));
                }
                JSFBeanScope jSFBeanScope = beanScope = beanScope == null ? JSFBeanScope.None : beanScope;
                if (beanName == null || beanScope == null) continue;
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.bean.found", (Object[])new Object[]{" class:" + currentClass.getName().toString() + " name:" + beanName + " scope:" + beanScope.toString()}));
                ManagedBean bean = new ManagedBean(beanName, currentClass, beanScope);
                this.m_beanMap.put(beanName, bean);
            }
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
    }

    private void mergeList(List<NavigationCaseInfo> targetList, List<NavigationCaseInfo> sourceList) {
        if (targetList == null || sourceList == null) {
            return;
        }
        for (NavigationCaseInfo ncInfo : sourceList) {
            if (targetList.contains(ncInfo)) continue;
            targetList.add(ncInfo);
        }
    }

    public void populateValidatorsBeansForwards() {
        List<String> configFiles = this.m_jsfConfigManager.getFacesConfigFiles();
        for (String configFile : configFiles) {
            FacesConfigParser configParser = new FacesConfigParser(configFile, this);
            configParser.populateAll();
        }
    }

    public ManagedBean findBean(String beanName) {
        return this.m_beanMap.get(beanName);
    }

    public Map<String, ManagedBean> getBeans() {
        return this.m_beanMap;
    }

    public List<Validator> getValidators() {
        return this.m_validators;
    }

    public Validator getValidator(String validatorId) {
        for (Validator currValidator : this.m_validators) {
            String currVId = currValidator.getVaildatorId();
            if (currVId == null || !currVId.equalsIgnoreCase(validatorId)) continue;
            return currValidator;
        }
        return null;
    }

    public JsfConfigurationManager getJsfConfigManager() {
        return this.m_jsfConfigManager;
    }

    public List<NavigationCaseInfo> findForward(String CanonicalPathOfFromView) {
        ArrayList ret = this.m_fromViewId2ToViewId.get(CanonicalPathOfFromView);
        return ret != null ? ret : new ArrayList();
    }

    public NavigationCaseInfo findForward(String CanonicalPathOfFromView, String fromOutcomeValue) {
        List<NavigationCaseInfo> forwardList = this.m_fromViewId2ToViewId.get(CanonicalPathOfFromView);
        if (forwardList == null) {
            return null;
        }
        for (NavigationCaseInfo ncInfo : forwardList) {
            if (!ncInfo.getFromOutcome().equals(fromOutcomeValue)) continue;
            return ncInfo;
        }
        return null;
    }

    public String getWebDirectory() {
        return this.m_webDirectory;
    }
}

