/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.jsf2;

import com.ibm.appscan.frameworks.handlers.jsf2.JSFBeanScope;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.Global;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.HighLevelSyntheticMethod;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Local;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Param;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import java.util.ArrayList;
import java.util.List;

public class ManagedBean {
    private JSFBeanScope m_scope;
    private String m_name;
    private String m_beanVdbClassName;
    private List<String> m_properties;
    private IClass m_beanClass;

    public ManagedBean(String beanName, String beanClassFullName, JSFBeanScope scope) {
        this.m_name = beanName;
        this.m_scope = scope;
        this.m_beanVdbClassName = beanClassFullName;
        this.m_properties = new ArrayList<String>();
    }

    public ManagedBean(String name, IClass beanClass, JSFBeanScope scope) {
        this.m_name = name;
        this.m_scope = scope;
        this.m_beanClass = beanClass;
        this.m_properties = new ArrayList<String>();
        this.m_beanVdbClassName = this.m_beanClass.getName().toString();
        this.m_beanVdbClassName = this.m_beanVdbClassName.replace("/", ".");
        if (this.m_beanVdbClassName.startsWith("L")) {
            this.m_beanVdbClassName = this.m_beanVdbClassName.substring(1, this.m_beanVdbClassName.length());
        }
        System.out.println(this.m_beanVdbClassName);
    }

    public void addProperty(String property) {
        this.m_properties.add(property);
    }

    public String getVdbClassName() {
        return this.m_beanVdbClassName;
    }

    public boolean hasProperty() {
        return this.m_properties.size() != 0;
    }

    public IClass getClassType(F4FApp app) {
        if (this.m_beanClass == null) {
            this.m_beanClass = app.getIClass(this.m_beanVdbClassName);
        }
        return this.m_beanClass;
    }

    public JSFBeanScope getScope() {
        return this.m_scope;
    }

    public List<String> getProperties() {
        return this.m_properties;
    }

    public String getName() {
        return this.m_name;
    }

    public Param createWAFLVariable(F4FApp app, F4FActions actions, HighLevelSyntheticMethod synMethod) {
        Local variable = null;
        if (this.m_beanClass == null) {
            this.m_beanClass = app.getIClass(this.m_beanVdbClassName);
        }
        if (this.m_beanClass == null) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.unknown.class", (Object[])new Object[]{this.m_beanVdbClassName}));
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.variable", (Object[])new Object[]{this.m_name}));
            return null;
        }
        switch (this.m_scope) {
            case Request: {
                String globalVariableName = this.m_scope.name() + "." + this.m_name;
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.global", (Object[])new Object[]{globalVariableName}));
                variable = actions.createGlobal(globalVariableName, this.m_beanClass, true);
                break;
            }
            case Session: {
                String globalVariableName = this.m_scope.name() + "." + this.m_name;
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.global", (Object[])new Object[]{globalVariableName}));
                variable = actions.createGlobal(globalVariableName, this.m_beanClass, false);
                break;
            }
            case Application: {
                String globalVariableName = this.m_scope.name() + "." + this.m_name;
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.global", (Object[])new Object[]{globalVariableName}));
                variable = actions.createGlobal(globalVariableName, this.m_beanClass, false);
                break;
            }
            case None: 
            case View: {
                variable = synMethod.newLocal(this.m_beanClass);
                break;
            }
            default: {
                TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.unknown.scope", (Object[])new Object[]{""}));
                TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.variable", (Object[])new Object[]{this.m_name}));
            }
        }
        return variable;
    }

    public boolean match(Global global) {
        if (this.m_scope.isGlobal()) {
            String fullName = global.getName();
            return fullName.equals(this.m_scope.name() + "." + this.m_name);
        }
        return false;
    }
}

