/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.AbstractAlgorithmConstraints;
import org.bouncycastle.jsse.provider.DisabledAlgorithmConstraints;
import org.bouncycastle.jsse.provider.ProvAlgorithmDecomposer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    private static final Logger LOG = Logger.getLogger(ProvAlgorithmConstraints.class.getName());
    private static final String PROPERTY_CERTPATH_DISABLED_ALGORITHMS = "jdk.certpath.disabledAlgorithms";
    private static final String PROPERTY_TLS_DISABLED_ALGORITHMS = "jdk.tls.disabledAlgorithms";
    private static final String DEFAULT_CERTPATH_DISABLED_ALGORITHMS = "MD2, MD5, SHA1 jdkCA & usage TLSServer, RSA keySize < 1024, DSA keySize < 1024, EC keySize < 224, SHA1 usage SignedJAR & denyAfter 2019-01-01";
    private static final String DEFAULT_TLS_DISABLED_ALGORITHMS = "SSLv3, TLSv1, TLSv1.1, DTLSv1.0, RC4, DES, MD5withRSA, DH keySize < 1024, EC keySize < 224, 3DES_EDE_CBC, anon, NULL, ECDH";
    private static final DisabledAlgorithmConstraints provTlsDisabledAlgorithms = DisabledAlgorithmConstraints.create(ProvAlgorithmDecomposer.INSTANCE_TLS, "jdk.tls.disabledAlgorithms", "SSLv3, TLSv1, TLSv1.1, DTLSv1.0, RC4, DES, MD5withRSA, DH keySize < 1024, EC keySize < 224, 3DES_EDE_CBC, anon, NULL, ECDH");
    private static final DisabledAlgorithmConstraints provX509DisabledAlgorithms = DisabledAlgorithmConstraints.create(ProvAlgorithmDecomposer.INSTANCE_X509, "jdk.certpath.disabledAlgorithms", "MD2, MD5, SHA1 jdkCA & usage TLSServer, RSA keySize < 1024, DSA keySize < 1024, EC keySize < 224, SHA1 usage SignedJAR & denyAfter 2019-01-01");
    static final ProvAlgorithmConstraints DEFAULT = new ProvAlgorithmConstraints(null, true);
    static final ProvAlgorithmConstraints DEFAULT_TLS_ONLY = new ProvAlgorithmConstraints(null, false);
    private final BCAlgorithmConstraints configAlgorithmConstraints;
    private final Set<String> supportedSignatureAlgorithms;
    private final boolean enableX509Constraints;

    ProvAlgorithmConstraints(BCAlgorithmConstraints configAlgorithmConstraints, boolean enableX509Constraints) {
        super(null);
        this.configAlgorithmConstraints = configAlgorithmConstraints;
        this.supportedSignatureAlgorithms = null;
        this.enableX509Constraints = enableX509Constraints;
    }

    ProvAlgorithmConstraints(BCAlgorithmConstraints configAlgorithmConstraints, String[] supportedSignatureAlgorithms, boolean enableX509Constraints) {
        super(null);
        this.configAlgorithmConstraints = configAlgorithmConstraints;
        this.supportedSignatureAlgorithms = ProvAlgorithmConstraints.asUnmodifiableSet(supportedSignatureAlgorithms);
        this.enableX509Constraints = enableX509Constraints;
    }

    @Override
    public boolean permits(Set<BCCryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
        this.checkPrimitives(primitives);
        this.checkAlgorithmName(algorithm);
        if (null != this.supportedSignatureAlgorithms) {
            String algorithmBC = algorithm;
            algorithm = this.getAlgorithm(algorithmBC);
            if (!this.isSupportedSignatureAlgorithm(algorithmBC)) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Signature algorithm '" + algorithmBC + "' not in supported signature algorithms");
                }
                return false;
            }
        }
        if (null != this.configAlgorithmConstraints && !this.configAlgorithmConstraints.permits(primitives, algorithm, parameters)) {
            return false;
        }
        if (null != provTlsDisabledAlgorithms && !provTlsDisabledAlgorithms.permits(primitives, algorithm, parameters)) {
            return false;
        }
        return !this.enableX509Constraints || null == provX509DisabledAlgorithms || provX509DisabledAlgorithms.permits(primitives, algorithm, parameters);
    }

    @Override
    public boolean permits(Set<BCCryptoPrimitive> primitives, Key key) {
        this.checkPrimitives(primitives);
        this.checkKey(key);
        if (null != this.configAlgorithmConstraints && !this.configAlgorithmConstraints.permits(primitives, key)) {
            return false;
        }
        if (null != provTlsDisabledAlgorithms && !provTlsDisabledAlgorithms.permits(primitives, key)) {
            return false;
        }
        return !this.enableX509Constraints || null == provX509DisabledAlgorithms || provX509DisabledAlgorithms.permits(primitives, key);
    }

    @Override
    public boolean permits(Set<BCCryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        this.checkPrimitives(primitives);
        this.checkAlgorithmName(algorithm);
        this.checkKey(key);
        if (null != this.supportedSignatureAlgorithms) {
            String algorithmBC = algorithm;
            algorithm = this.getAlgorithm(algorithmBC);
            if (!this.isSupportedSignatureAlgorithm(algorithmBC)) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Signature algorithm '" + algorithmBC + "' not in supported signature algorithms");
                }
                return false;
            }
        }
        if (null != this.configAlgorithmConstraints && !this.configAlgorithmConstraints.permits(primitives, algorithm, key, parameters)) {
            return false;
        }
        if (null != provTlsDisabledAlgorithms && !provTlsDisabledAlgorithms.permits(primitives, algorithm, key, parameters)) {
            return false;
        }
        return !this.enableX509Constraints || null == provX509DisabledAlgorithms || provX509DisabledAlgorithms.permits(primitives, algorithm, key, parameters);
    }

    private String getAlgorithm(String algorithmBC) {
        int colonPos = algorithmBC.indexOf(58);
        return colonPos < 0 ? algorithmBC : algorithmBC.substring(0, colonPos);
    }

    private boolean isSupportedSignatureAlgorithm(String algorithmBC) {
        return this.containsIgnoreCase(this.supportedSignatureAlgorithms, algorithmBC);
    }
}

