/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsDHGroupVerifier;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.DHGroup;
import org.bouncycastle.tls.crypto.DHStandardGroups;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsDHUtils {
    public static TlsDHConfig createNamedDHConfig(TlsContext context, int namedGroup) {
        if (namedGroup < 0 || NamedGroup.getFiniteFieldBits(namedGroup) < 1) {
            return null;
        }
        boolean padded = TlsUtils.isTLSv13(context);
        return new TlsDHConfig(namedGroup, padded);
    }

    public static DHGroup getDHGroup(TlsDHConfig dhConfig) {
        int namedGroup = dhConfig.getNamedGroup();
        if (namedGroup >= 0) {
            return TlsDHUtils.getNamedDHGroup(namedGroup);
        }
        return dhConfig.getExplicitGroup();
    }

    public static DHGroup getNamedDHGroup(int namedGroup) {
        switch (namedGroup) {
            case 256: {
                return DHStandardGroups.rfc7919_ffdhe2048;
            }
            case 257: {
                return DHStandardGroups.rfc7919_ffdhe3072;
            }
            case 258: {
                return DHStandardGroups.rfc7919_ffdhe4096;
            }
            case 259: {
                return DHStandardGroups.rfc7919_ffdhe6144;
            }
            case 260: {
                return DHStandardGroups.rfc7919_ffdhe8192;
            }
        }
        return null;
    }

    public static int getMinimumFiniteFieldBits(int cipherSuite) {
        return TlsDHUtils.isDHCipherSuite(cipherSuite) ? 1 : 0;
    }

    public static boolean isDHCipherSuite(int cipherSuite) {
        switch (TlsUtils.getKeyExchangeAlgorithm(cipherSuite)) {
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public static int getNamedGroupForDHParameters(BigInteger p, BigInteger g) {
        int[] namedGroups = new int[]{256, 257, 258, 259, 260};
        for (int i = 0; i < namedGroups.length; ++i) {
            int namedGroup = namedGroups[i];
            DHGroup dhGroup = TlsDHUtils.getNamedDHGroup(namedGroup);
            if (dhGroup == null || !dhGroup.getP().equals(p) || !dhGroup.getG().equals(g)) continue;
            return namedGroup;
        }
        return -1;
    }

    public static DHGroup getStandardGroupForDHParameters(BigInteger p, BigInteger g) {
        DHGroup[] standardGroups = new DHGroup[]{DHStandardGroups.rfc7919_ffdhe2048, DHStandardGroups.rfc7919_ffdhe3072, DHStandardGroups.rfc7919_ffdhe4096, DHStandardGroups.rfc7919_ffdhe6144, DHStandardGroups.rfc7919_ffdhe8192, DHStandardGroups.rfc3526_1536, DHStandardGroups.rfc3526_2048, DHStandardGroups.rfc3526_3072, DHStandardGroups.rfc3526_4096, DHStandardGroups.rfc3526_6144, DHStandardGroups.rfc3526_8192, DHStandardGroups.rfc5996_768, DHStandardGroups.rfc5996_1024};
        for (int i = 0; i < standardGroups.length; ++i) {
            DHGroup dhGroup = standardGroups[i];
            if (dhGroup == null || !dhGroup.getP().equals(p) || !dhGroup.getG().equals(g)) continue;
            return dhGroup;
        }
        return null;
    }

    public static TlsDHConfig receiveDHConfig(TlsContext context, TlsDHGroupVerifier dhGroupVerifier, InputStream input) throws IOException {
        BigInteger g;
        BigInteger p = TlsDHUtils.readDHParameter(input);
        int namedGroup = TlsDHUtils.getNamedGroupForDHParameters(p, g = TlsDHUtils.readDHParameter(input));
        if (namedGroup < 0) {
            DHGroup dhGroup = TlsDHUtils.getStandardGroupForDHParameters(p, g);
            if (null == dhGroup) {
                dhGroup = new DHGroup(p, null, g, 0);
            }
            if (!dhGroupVerifier.accept(dhGroup)) {
                throw new TlsFatalAlert(71);
            }
            return new TlsDHConfig(dhGroup);
        }
        int[] clientSupportedGroups = context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (null == clientSupportedGroups || Arrays.contains((int[])clientSupportedGroups, (int)namedGroup)) {
            return new TlsDHConfig(namedGroup, false);
        }
        throw new TlsFatalAlert(47);
    }

    public static BigInteger readDHParameter(InputStream input) throws IOException {
        return new BigInteger(1, TlsUtils.readOpaque16(input, 1));
    }

    public static void writeDHConfig(TlsDHConfig dhConfig, OutputStream output) throws IOException {
        DHGroup group = TlsDHUtils.getDHGroup(dhConfig);
        TlsDHUtils.writeDHParameter(group.getP(), output);
        TlsDHUtils.writeDHParameter(group.getG(), output);
    }

    public static void writeDHParameter(BigInteger x, OutputStream output) throws IOException {
        TlsUtils.writeOpaque16(BigIntegers.asUnsignedByteArray((BigInteger)x), output);
    }
}

