/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa;

import com.ibm.wala.cast.ir.ssa.SSAConversion;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ssa.DefaultIRFactory;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAIndirectionData;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import java.util.Map;

public class AstIRFactory<T extends IMethod>
implements IRFactory<T> {
    public ControlFlowGraph makeCFG(IMethod method, Context context) {
        return ((AstMethod)method).getControlFlowGraph();
    }

    public IR makeIR(IMethod method, Context context, SSAOptions options) {
        assert (method instanceof AstMethod) : method.toString();
        AbstractCFG oldCfg = ((AstMethod)method).cfg();
        SSAInstruction[] oldInstrs = (SSAInstruction[])oldCfg.getInstructions();
        SSAInstruction[] instrs = new SSAInstruction[oldInstrs.length];
        System.arraycopy(oldInstrs, 0, instrs, 0, instrs.length);
        AstIR newIR = new AstIR((AstMethod)method, instrs, ((AstMethod)method).symbolTable().copy(), new SSACFG(method, oldCfg, instrs), options);
        return newIR;
    }

    public static IRFactory<IMethod> makeDefaultFactory() {
        return new AstDefaultIRFactory();
    }

    public boolean contextIsIrrelevant(IMethod method) {
        return true;
    }

    public class AstIR
    extends IR {
        private final AstMethod.LexicalInformation lexicalInfo;
        private final IR.SSA2LocalMap localMap;

        public AstMethod.LexicalInformation lexicalInfo() {
            return this.lexicalInfo;
        }

        private void setCatchInstructions(SSACFG ssacfg, AbstractCFG oldcfg) {
            for (int i = 0; i < oldcfg.getNumberOfNodes(); ++i) {
                if (!oldcfg.isCatchBlock(i)) continue;
                SSACFG.ExceptionHandlerBasicBlock B = (SSACFG.ExceptionHandlerBasicBlock)ssacfg.getNode(i);
                B.setCatchInstruction((SSAGetCaughtExceptionInstruction)this.getInstructions()[B.getFirstInstructionIndex()]);
                this.getInstructions()[B.getFirstInstructionIndex()] = null;
            }
        }

        private void setupCatchTypes(SSACFG cfg, Map<IBasicBlock, TypeReference[]> map) {
            for (Map.Entry<IBasicBlock, TypeReference[]> e : map.entrySet()) {
                if (e.getKey().getNumber() == -1) continue;
                SSACFG.ExceptionHandlerBasicBlock bb = (SSACFG.ExceptionHandlerBasicBlock)cfg.getNode(e.getKey().getNumber());
                for (int j = 0; j < e.getValue().length; ++j) {
                    bb.addCaughtExceptionType(e.getValue()[j]);
                }
            }
        }

        protected IR.SSA2LocalMap getLocalMap() {
            return this.localMap;
        }

        protected String instructionPosition(int instructionIndex) {
            CAstSourcePositionMap.Position pos = this.getMethod().getSourcePosition(instructionIndex);
            if (pos == null) {
                return "";
            }
            return pos.toString();
        }

        public AstMethod getMethod() {
            return (AstMethod)super.getMethod();
        }

        private AstIR(AstMethod method, SSAInstruction[] instructions, SymbolTable symbolTable, SSACFG cfg, SSAOptions options) {
            super((IMethod)method, instructions, symbolTable, cfg, options);
            this.lexicalInfo = method.cloneLexicalInfo();
            this.localMap = SSAConversion.convert(method, this, options);
            this.setCatchInstructions(this.getControlFlowGraph(), method.cfg());
            this.setupCatchTypes(this.getControlFlowGraph(), method.catchTypes());
            this.setupLocationMap();
        }

        protected SSAIndirectionData<SSAIndirectionData.Name> getIndirectionData() {
            return null;
        }
    }

    public static class AstDefaultIRFactory
    extends DefaultIRFactory {
        private final AstIRFactory astFactory;

        public AstDefaultIRFactory() {
            this(new AstIRFactory());
        }

        public AstDefaultIRFactory(AstIRFactory astFactory) {
            this.astFactory = astFactory;
        }

        public IR makeIR(IMethod method, Context context, SSAOptions options) {
            if (method instanceof AstMethod) {
                return this.astFactory.makeIR(method, context, options);
            }
            return super.makeIR(method, context, options);
        }

        public ControlFlowGraph makeCFG(IMethod method, Context context) {
            if (method instanceof AstMethod) {
                return this.astFactory.makeCFG(method, context);
            }
            return super.makeCFG(method, context);
        }
    }
}

