/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.common;

import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.Messages;
import com.ibm.appscan.cli.common.commands.HelpCommand;
import com.ibm.appscan.cli.common.components.BaseShell;
import com.ibm.appscan.cli.common.model.ICommand;
import com.ibm.appscan.cli.common.model.ICommandManager;
import com.ibm.appscan.cli.common.model.IPrompt;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IConsole;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DefaultShell
extends BaseShell {
    private ILogManager m_logManager = CommonCLICore.getLogManager();
    private ICommandManager m_commandManager = CommonCLICore.getCommandManager();
    private IConsole m_console = CommonCLICore.getIOConsole();
    private IPrompt m_prompt = CommonCLICore.getPrompt();
    private List<String> m_history = new ArrayList<String>();

    public DefaultShell() {
    }

    public DefaultShell(InputStream in, OutputStream out, OutputStream err) {
        this.m_console.setInputSource(in);
        this.m_console.setOutputTarget(out);
        this.m_console.setErrorTarget(err);
    }

    public IPrompt getPrompt() {
        return this.m_prompt;
    }

    public ICommandManager getCommandManager() {
        return this.m_commandManager;
    }

    public ILogManager getLogger() {
        return this.m_logManager;
    }

    @Override
    public void prompt() {
        this.m_prompt.prompt();
    }

    private boolean process() {
        String input = this.m_console.readInput();
        if (input == null || input.isEmpty()) {
            return true;
        }
        String[] inputArr = input.replaceAll("\\s+", " ").trim().split(" ");
        ICommand cmd = this.parseCommand(Arrays.copyOfRange(inputArr, 1, inputArr.length));
        this.m_logManager.log(new Message(1, Messages.getMessage("command.issuing", inputArr[1])));
        this.m_history.add(input);
        if (cmd != null && cmd.canExecute()) {
            try {
                cmd.execute();
            }
            catch (Exception e) {
                this.m_logManager.log(new Message((Throwable)e));
                this.m_console.println(e.toString());
                this.m_console.println(Messages.getMessage("command.execute.err", input));
            }
        }
        return true;
    }

    private boolean process(String[] input) {
        if (input == null || input.length < 1) {
            return true;
        }
        ICommand cmd = this.parseCommand(input);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < input.length; ++i) {
            if (i > 0) {
                builder.append(" ");
            }
            builder.append(input[i]);
        }
        String inputString = builder.toString();
        this.m_logManager.log(new Message(1, Messages.getMessage("command.issuing", input[0])));
        this.m_history.add(inputString);
        if (cmd != null && cmd.canExecute()) {
            try {
                cmd.execute();
            }
            catch (Exception e) {
                Message message = new Message((Throwable)e);
                this.m_logManager.log(message);
                this.m_console.println(message);
            }
        }
        return true;
    }

    private ICommand parseCommand(String[] input) {
        String commandKey = input[0];
        if (!this.m_commandManager.hasCommand(commandKey)) {
            if (!HelpCommand.isHelpAlias(commandKey)) {
                this.m_console.println(Messages.getMessage("command.invalid", commandKey));
            }
            commandKey = "help";
        }
        String[] inputArr = Arrays.copyOfRange(input, 1, input.length);
        ICommand cmd = this.m_commandManager.createCommand(commandKey, inputArr);
        return cmd;
    }

    public int run() {
        this.m_console.println(Messages.getMessage("welcome.default", "help"));
        boolean loopRunning = true;
        while (loopRunning) {
            this.prompt();
            loopRunning = this.process();
        }
        return loopRunning ? 0 : 1;
    }

    @Override
    public boolean exec(String[] args) {
        return this.process(args);
    }
}

