/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.util;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.MapUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TaintFilter
implements Filter<MethodReference> {
    private final Collection<MethodReference> taintAPIs;
    private final Map<Selector, Set<IClass>> methodRefsAsMap;
    private final IClassHierarchy cha;

    private TaintFilter(IClassHierarchy cha, Collection<MethodReference> taintAPIs, Map<Selector, Set<IClass>> methodRefsAsMap) {
        this.cha = cha;
        this.taintAPIs = taintAPIs;
        this.methodRefsAsMap = methodRefsAsMap;
    }

    public boolean accepts(MethodReference o) {
        Selector targetSelector;
        Set<IClass> S;
        IClass targetClass = this.cha.lookupClass(o.getDeclaringClass());
        if (targetClass != null && (S = this.methodRefsAsMap.get(targetSelector = o.getSelector())) != null) {
            for (IClass c : S) {
                if (c == null || !this.cha.isAssignableFrom(c, targetClass)) continue;
                return true;
            }
        }
        return false;
    }

    public static TaintFilter createFilter(IClassHierarchy cha, Collection<MethodReference> methodRefs) {
        HashMap methodRefsAsMap = HashMapFactory.make();
        for (MethodReference mr : methodRefs) {
            Set S = MapUtil.findOrCreateSet((Map)methodRefsAsMap, (Object)mr.getSelector());
            IClass c = cha.lookupClass(mr.getDeclaringClass());
            S.add(c);
        }
        return new TaintFilter(cha, methodRefs, methodRefsAsMap);
    }

    public Collection<MethodReference> getTaintAPIs() {
        return this.taintAPIs;
    }
}

