/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.condition;

import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.stringAnalysis.condition.BooleanConditionCollector;
import com.ibm.wala.stringAnalysis.condition.IPathCondition;
import com.ibm.wala.stringAnalysis.condition.IPathConditionAnalysis;
import com.ibm.wala.stringAnalysis.condition.IPathConditionCollector;
import com.ibm.wala.stringAnalysis.ssa.SSACFGWithConditions;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.MonitorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PathConditionAnalysis
implements IPathConditionAnalysis {
    final IPathConditionCollector conditionCollector;
    final SSACFGWithConditions conditioned;

    public PathConditionAnalysis(IR ir, MonitorUtil.IProgressMonitor monitor) {
        this.conditioned = new SSACFGWithConditions(ir);
        this.conditionCollector = new BooleanConditionCollector(this.conditioned, monitor);
    }

    public PathConditionAnalysis(IR ir) {
        this(ir, SAUtil.nullProgressMonitor);
    }

    @Override
    public IPathCondition getCondition(ISSABasicBlock block) {
        return this.conditionCollector.getCondition(block.getNumber(), 10);
    }

    @Override
    public List<IPathCondition> getConditions(ISSABasicBlock block) {
        return this.conditionCollector.getConditions(block.getNumber(), 10);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("{" + SAUtil.lineSeparator);
        ArrayList<Integer> keys = new ArrayList<Integer>();
        Iterator<ISSABasicBlock> i = this.conditioned.iterator();
        while (i.hasNext()) {
            keys.add(i.next().getNumber());
        }
        Collections.sort(keys);
        for (Integer n : keys) {
            IPathCondition cond = this.conditionCollector.getCondition(n, -1);
            buff.append("  BB" + n + "=" + cond + SAUtil.lineSeparator);
        }
        buff.append("}");
        return buff.toString();
    }
}

