/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.ssa;

import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractUnaryInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;

public class SAInstructionVisitor
implements SSAInstruction.IVisitor {
    protected final Processor processor;

    public SAInstructionVisitor(Processor processor) {
        this.processor = processor;
    }

    public void visitGoto(SSAGotoInstruction instruction) {
        this.processor.onGotoInstruction(instruction);
    }

    public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
        this.processor.onSSAArrayLoadInstruction(instruction);
    }

    public void visitArrayStore(SSAArrayStoreInstruction instruction) {
        this.processor.onSSAArrayStoreInstruction(instruction);
    }

    public void visitBinaryOp(SSABinaryOpInstruction instruction) {
        this.processor.onSSABinaryOpInstruction(instruction);
    }

    public void visitUnaryOp(SSAUnaryOpInstruction instruction) {
        this.processor.onSSAAbstractUnaryInstruction((SSAAbstractUnaryInstruction)instruction);
    }

    public void visitConversion(SSAConversionInstruction instruction) {
        this.processor.onSSAConversionInstruction(instruction);
    }

    public void visitComparison(SSAComparisonInstruction instruction) {
        this.processor.onComparisonInstruction(instruction);
    }

    public void visitConditionalBranch(SSAConditionalBranchInstruction instruction) {
        this.processor.onSSAConditionalBranchInstruction(instruction);
    }

    public void visitSwitch(SSASwitchInstruction instruction) {
        this.processor.onSSASwitchInstruction(instruction);
    }

    public void visitReturn(SSAReturnInstruction instruction) {
        this.processor.onReturnInstruction(instruction);
    }

    public void visitGet(SSAGetInstruction instruction) {
        this.processor.onSSAGetInstruction(instruction);
    }

    public void visitPut(SSAPutInstruction instruction) {
        this.processor.onSSAPutInstruction(instruction);
    }

    public void visitInvoke(SSAInvokeInstruction instruction) {
        this.processor.onSSAAbstractInvokeInstruction((SSAAbstractInvokeInstruction)instruction);
    }

    public void visitNew(SSANewInstruction instruction) {
        this.processor.onSSANewInstruction(instruction);
    }

    public void visitArrayLength(SSAArrayLengthInstruction instruction) {
        this.processor.onArrayLengthInstruction(instruction);
    }

    public void visitThrow(SSAThrowInstruction instruction) {
        this.processor.onThrowInstruction(instruction);
    }

    public void visitMonitor(SSAMonitorInstruction instruction) {
        this.processor.onMonitorInstruction(instruction);
    }

    public void visitCheckCast(SSACheckCastInstruction instruction) {
        this.processor.onCheckCastInstruction(instruction);
    }

    public void visitInstanceof(SSAInstanceofInstruction instruction) {
        this.processor.onInstanceofInstruction(instruction);
    }

    public void visitPhi(SSAPhiInstruction instruction) {
        this.processor.onSSAPhiInstruction(instruction);
    }

    public void visitPi(SSAPiInstruction instruction) {
        this.processor.onSSAPiInstruction(instruction);
    }

    public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
        this.processor.onGetCaughtExceptionInstruction(instruction);
    }

    public void visitLoadMetadata(SSALoadMetadataInstruction instruction) {
        this.processor.onLoadMetadataInstruction(instruction);
    }

    public static interface Processor {
        public void onSSAAbstractInvokeInstruction(SSAAbstractInvokeInstruction var1);

        public void onSSABinaryOpInstruction(SSABinaryOpInstruction var1);

        public void onSSAAbstractUnaryInstruction(SSAAbstractUnaryInstruction var1);

        public void onSSANewInstruction(SSANewInstruction var1);

        public void onSSAPhiInstruction(SSAPhiInstruction var1);

        public void onSSAPiInstruction(SSAPiInstruction var1);

        public void onSSAConditionalBranchInstruction(SSAConditionalBranchInstruction var1);

        public void onSSASwitchInstruction(SSASwitchInstruction var1);

        public void onSSAArrayLoadInstruction(SSAArrayLoadInstruction var1);

        public void onSSAArrayStoreInstruction(SSAArrayStoreInstruction var1);

        public void onSSAConversionInstruction(SSAConversionInstruction var1);

        public void onSSAReturnInstruction(SSAReturnInstruction var1);

        public void onSSAPutInstruction(SSAPutInstruction var1);

        public void onSSAGetInstruction(SSAGetInstruction var1);

        public void onGotoInstruction(SSAGotoInstruction var1);

        public void onComparisonInstruction(SSAComparisonInstruction var1);

        public void onReturnInstruction(SSAReturnInstruction var1);

        public void onArrayLengthInstruction(SSAArrayLengthInstruction var1);

        public void onThrowInstruction(SSAThrowInstruction var1);

        public void onMonitorInstruction(SSAMonitorInstruction var1);

        public void onCheckCastInstruction(SSACheckCastInstruction var1);

        public void onInstanceofInstruction(SSAInstanceofInstruction var1);

        public void onGetCaughtExceptionInstruction(SSAGetCaughtExceptionInstruction var1);

        public void onLoadMetadataInstruction(SSALoadMetadataInstruction var1);
    }
}

