/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.ISimplify;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerSiteContext;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.stringAnalysis.grammar.GR;
import com.ibm.wala.stringAnalysis.grammar.GRule;
import com.ibm.wala.stringAnalysis.grammar.InvocationSymbol;
import com.ibm.wala.stringAnalysis.grammar.SignatureSymbol;
import com.ibm.wala.stringAnalysis.translator.ICG2Grammar;
import com.ibm.wala.stringAnalysis.translator.IIR2Grammar;
import com.ibm.wala.stringAnalysis.translator.ISSA2Rule;
import com.ibm.wala.stringAnalysis.translator.ISymbolFactory;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.ITypeInferenceBuilder;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.viz.DotUtil;
import com.ibm.wala.viz.NodeDecorator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class CG2Grammar<T>
implements ICG2Grammar<T> {
    private final IIR2Grammar<T> ir2gr;
    private final ITranslatorRepository<T> repository;
    private ITypeInferenceBuilder typeInferenceBuilder;
    protected final MonitorUtil.IProgressMonitor progressMonitor;
    protected final Logger logger;
    public static final ITypeInferenceBuilder defaultTypeInferenceBuilder = new ITypeInferenceBuilder(){

        @Override
        public TypeInference createTypeInference(IR ir) {
            return null;
        }
    };
    static int dotNum = 0;

    public CG2Grammar(IIR2Grammar<T> ir2gr, ITypeInferenceBuilder builder, MonitorUtil.IProgressMonitor progressMonitor, Logger logger) {
        this.ir2gr = ir2gr;
        this.typeInferenceBuilder = builder;
        this.progressMonitor = progressMonitor;
        this.logger = logger;
        this.repository = ir2gr.getBB2Grammar().getSSA2Rule().getSymbolFactory().getRepository();
    }

    public CG2Grammar(IIR2Grammar<T> ir2gr, MonitorUtil.IProgressMonitor progressMonitor, Logger logger) {
        this(ir2gr, defaultTypeInferenceBuilder, progressMonitor, logger);
    }

    public CG2Grammar(IIR2Grammar<T> ir2gr, Logger logger) {
        this(ir2gr, null, logger);
    }

    protected void debugDump(CallGraph callGraph) {
        NodeDecorator decorator = new NodeDecorator(){

            public String getLabel(Object o) throws WalaException {
                CGNode node = (CGNode)o;
                return node.getGraphNodeId() + ":" + node.getMethod().getSignature();
            }
        };
        try {
            DotUtil.writeDotFile((Graph)callGraph, (NodeDecorator)decorator, (String)"call graph for SA", (String)("C:\\tmp\\wala\\" + dotNum + ".dot"));
        }
        catch (WalaException e) {
            e.printStackTrace();
        }
        ++dotNum;
    }

    protected Iterator<CGNode> sortedNodeIterator(CallGraph cg) {
        ArrayList<CGNode> nodes = new ArrayList<CGNode>(cg.getNumberOfNodes());
        for (CGNode node : cg) {
            nodes.add(node);
        }
        Collections.sort(nodes, new Comparator<CGNode>(){

            @Override
            public int compare(CGNode o1, CGNode o2) {
                IR ir1 = o1.getIR();
                IR ir2 = o2.getIR();
                ClassLoaderReference loader1 = ir1 == null ? ClassLoaderReference.Primordial : ir1.getMethod().getDeclaringClass().getClassLoader().getReference();
                ClassLoaderReference loader2 = ir2 == null ? ClassLoaderReference.Primordial : ir2.getMethod().getDeclaringClass().getClassLoader().getReference();
                int n1 = 0;
                int n2 = 0;
                if (loader1.equals((Object)ClassLoaderReference.Extension)) {
                    n1 = 1;
                } else if (loader1.equals((Object)ClassLoaderReference.Primordial)) {
                    n1 = 2;
                }
                if (loader2.equals((Object)ClassLoaderReference.Extension)) {
                    n2 = 1;
                } else if (loader2.equals((Object)ClassLoaderReference.Primordial)) {
                    n2 = 2;
                }
                if (n1 == n2) {
                    int i1 = ir1 == null ? 0 : ir1.getInstructions().length;
                    int i2 = ir2 == null ? 0 : ir2.getInstructions().length;
                    return i1 - i2;
                }
                return n1 - n2;
            }
        });
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"-- sorted nodes:");
            for (CGNode node : nodes) {
                SAUtil.println((Object)node.getMethod());
            }
        }
        return nodes.iterator();
    }

    protected Iterator<CGNode> nodeIterator(CallGraph cg) {
        return cg.iterator();
    }

    protected void translateNodes(Collection<IProductionRule> rules, CallGraph callGraph, PointerAnalysis pointerAnalysis, CGNode fakeRootNode, ISSA2Rule<T> ssa2rule) {
        Iterator<CGNode> i = this.nodeIterator(callGraph);
        while (i.hasNext()) {
            CGNode node = i.next();
            if (node.equals(fakeRootNode)) continue;
            this.translateNode(rules, node, callGraph, pointerAnalysis, ssa2rule);
        }
    }

    protected void translateNode(Collection<IProductionRule> rules, CGNode node, CallGraph callGraph, PointerAnalysis pointerAnalysis, ISSA2Rule<T> ssa2rule) {
        IR ir = node.getIR();
        if (ir == null) {
            return;
        }
        IClassLoader loader = node.getMethod().getDeclaringClass().getClassLoader();
        if (ssa2rule.getSymbolFactory().getRepository().isBuiltin(node, loader.getReference())) {
            return;
        }
        this.translateNodeImpl(rules, ir, node, callGraph, pointerAnalysis, ssa2rule);
    }

    protected void translateNodeImpl(Collection<IProductionRule> rules, IR ir, CGNode node, CallGraph callGraph, PointerAnalysis pointerAnalysis, ISSA2Rule<T> ssa2rule) {
        TypeInference typeInference = this.getTypeInferenceBuilder().createTypeInference(ir);
        if (typeInference != null) {
            typeInference.solve();
        }
        TranslationContext ctx = new TranslationContext(ir, node, callGraph, pointerAnalysis, typeInference, null, this.progressMonitor, this.logger);
        GR gr = this.getIR2Grammar().translate(ctx);
        boolean emptyGR = gr.getRules().isEmpty();
        this.addRules(rules, gr.getRules(), callGraph);
        Context c = node.getContext();
        if (c instanceof CallerSiteContext) {
            CallerSiteContext cc = (CallerSiteContext)c;
            CGNode caller = cc.getCaller();
            CallSiteReference site = cc.getCallSite();
            if (!emptyGR) {
                this.addRules(rules, this.createAliasRules(site, caller, node, callGraph, ctx), callGraph);
            }
            this.addRules(rules, this.createReturnRules(site, caller, node, callGraph, ctx), callGraph);
        } else {
            Iterator j = callGraph.getPredNodes((Object)node);
            while (j.hasNext()) {
                CGNode caller = (CGNode)j.next();
                if (caller == null) continue;
                Iterator k = callGraph.getPossibleSites(caller, node);
                while (k.hasNext()) {
                    CallSiteReference site = (CallSiteReference)k.next();
                    if (!emptyGR) {
                        this.addRules(rules, this.createAliasRules(site, caller, node, callGraph, ctx), callGraph);
                    }
                    this.addRules(rules, this.createReturnRules(site, caller, node, callGraph, ctx), callGraph);
                }
            }
        }
    }

    protected void addRules(Collection<IProductionRule> rules, Collection<IProductionRule> rs, CallGraph callGraph) {
        for (IProductionRule r : rs) {
            this.addRule(rules, r, callGraph);
        }
    }

    protected boolean addRule(Collection<IProductionRule> rules, IProductionRule rule, CallGraph callGraph) {
        if (rule.getRight().size() == 1) {
            if (rule.getRight(0) instanceof InvocationSymbol) {
                InvocationSymbol invokeSymbol = (InvocationSymbol)rule.getRight(0);
                SignatureSymbol func = invokeSymbol.getFunction();
                if (func == null) {
                    return false;
                }
                SSAInstruction instruction = invokeSymbol.getInstruction();
                if (instruction instanceof SSAAbstractInvokeInstruction) {
                    SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instruction;
                    String funcName = invokeSymbol.getFunction().getName();
                    if (this.repository.isBuiltin(funcName, invoke, callGraph)) {
                        return rules.add((IProductionRule)((GRule)rule));
                    }
                    return false;
                }
                return rules.add((IProductionRule)((GRule)rule));
            }
            return rules.add((IProductionRule)((GRule)rule));
        }
        return rules.add((IProductionRule)((GRule)rule));
    }

    @Override
    public ISimplify translate(CallGraph callGraph, PointerAnalysis pointerAnalysis) {
        CGNode fakeRootNode;
        try {
            fakeRootNode = callGraph.getFakeRootNode();
        }
        catch (UnsupportedOperationException e) {
            fakeRootNode = null;
        }
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"CG2Grammar.translate()");
        }
        ISSA2Rule<T> ssa2rule = this.getIR2Grammar().getBB2Grammar().getSSA2Rule();
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>(1000, 0.75f);
        this.translateNodes(rules, callGraph, pointerAnalysis, fakeRootNode, ssa2rule);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"end of CG2Grammar.translate()");
        }
        return new GR(rules);
    }

    private Collection<IProductionRule> createReturnRules(CallSiteReference site, CGNode caller, CGNode callee, CallGraph cg, TranslationContext ctx) {
        try {
            IClass klass = callee.getMethod().getDeclaringClass();
            if (this.repository.isBuiltin(callee, klass.getClassLoader().getReference())) {
                return Collections.emptySet();
            }
        }
        catch (UnimplementedError klass) {
            // empty catch block
        }
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        SSAAbstractInvokeInstruction[] invoke = caller.getIR().getCalls(site);
        for (int k = 0; k < invoke.length; ++k) {
            Collection<IProductionRule> aliases = this.createReturnRules(invoke[k], caller, callee, cg, ctx);
            rules.addAll(aliases);
        }
        return rules;
    }

    private Collection<Integer> getReturnValues(IR ir) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (SSAInstruction instruction : ir.getInstructions()) {
            if (!(instruction instanceof SSAReturnInstruction)) continue;
            SSAReturnInstruction ret = (SSAReturnInstruction)instruction;
            result.add(ret.getResult());
        }
        return result;
    }

    private Collection<IProductionRule> createReturnRules(SSAAbstractInvokeInstruction invoke, CGNode caller, CGNode callee, CallGraph cg, TranslationContext ctx) {
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        ISSA2Rule<T> ssa2rule = this.getIR2Grammar().getBB2Grammar().getSSA2Rule();
        ISymbolFactory<T> symFactory = ssa2rule.getSymbolFactory();
        for (IVariable lhs : symFactory.createCDVariable(invoke.getDef(0), new TranslationContext(caller.getIR(), caller, cg, ctx.getPointerAnalysis(), ctx.getTypeInference(), ctx.getPathConditionAnalysis(), ctx.getProgressMonitor(), ctx.getLogger()))) {
            for (int retVal : this.getReturnValues(callee.getIR())) {
                for (IVariable rhs : symFactory.createCDVariable(retVal, new TranslationContext(callee.getIR(), callee, cg, ctx.getPointerAnalysis(), ctx.getTypeInference(), ctx.getPathConditionAnalysis(), ctx.getProgressMonitor(), ctx.getLogger()))) {
                    rhs = this.manageReturnVariable(rhs);
                    if (SAUtil.DEBUG) {
                        SAUtil.println((Object)("  add return rule: " + lhs + " -> " + rhs));
                    }
                    rules.add((IProductionRule)new GRule(lhs, (ISymbol)rhs));
                }
            }
        }
        return rules;
    }

    protected IVariable manageReturnVariable(IVariable v) {
        return v;
    }

    private Collection<IProductionRule> createAliasRules(CallSiteReference site, CGNode caller, CGNode callee, CallGraph cg, TranslationContext ctx) {
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        SSAAbstractInvokeInstruction[] invoke = caller.getIR().getCalls(site);
        for (int k = 0; k < invoke.length; ++k) {
            Collection<IProductionRule> aliases = this.createAliasRules(invoke[k], caller, callee, cg, ctx);
            rules.addAll(aliases);
        }
        return rules;
    }

    private Collection<IProductionRule> createAliasRules(SSAAbstractInvokeInstruction invoke, CGNode caller, CGNode callee, CallGraph cg, TranslationContext ctx) {
        TypeInference ti = this.typeInferenceBuilder.createTypeInference(caller.getIR());
        if (ti != null) {
            ti.solve();
        }
        TranslationContext callerCtx = new TranslationContext(caller.getIR(), caller, cg, ctx.getPointerAnalysis(), ti, null, ctx.getProgressMonitor(), ctx.getLogger());
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        ISSA2Rule<T> ssa2rule = this.getIR2Grammar().getBB2Grammar().getSSA2Rule();
        ISymbolFactory<T> symFactory = ssa2rule.getSymbolFactory();
        int callerRecv = ssa2rule.getSymbolFactory().getRepository().getReceiver(invoke, callerCtx);
        int[] callerParams = ssa2rule.getSymbolFactory().getRepository().getParams(invoke, callerCtx);
        int calleeRecv = ssa2rule.getSymbolFactory().getRepository().getReceiver(callee.getIR());
        int[] calleeParams = ssa2rule.getSymbolFactory().getRepository().getParams(callee.getIR());
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)("invoke: " + invoke));
            SAUtil.println((Object)("caller: " + caller.getMethod().getSignature()));
            SAUtil.println((Object)("callee: " + callee.getMethod().getSignature()));
            SAUtil.println((Object)("caller: " + callerRecv + ", " + Arrays.toString(callerParams)));
            SAUtil.println((Object)("callee: " + calleeRecv + ", " + Arrays.toString(calleeParams)));
        }
        ArrayList<Collection<ISymbol>> callerVParams = new ArrayList<Collection<ISymbol>>();
        new ArrayList();
        Collection<IVariable> callerVRecv = symFactory.createCDVariable(callerRecv, new TranslationContext(caller.getIR(), caller, cg, ctx.getPointerAnalysis(), ctx.getTypeInference(), ctx.getPathConditionAnalysis(), ctx.getProgressMonitor(), ctx.getLogger()));
        for (int i = 0; i < callerParams.length; ++i) {
            Collection<ISymbol> var = symFactory.createValueSymbol(callerParams[i], (SSAInstruction)invoke, callerCtx);
            callerVParams.add(var);
        }
        Collection<IVariable> calleeVRecv = symFactory.createCDVariable(calleeRecv, new TranslationContext(callee.getIR(), callee, cg, ctx.getPointerAnalysis(), ctx.getTypeInference(), ctx.getPathConditionAnalysis(), ctx.getProgressMonitor(), ctx.getLogger()));
        ArrayList<HashSet<IVariable>> calleeVParams = new ArrayList<HashSet<IVariable>>();
        for (int i = 0; i < calleeParams.length; ++i) {
            Collection<IVariable> var = symFactory.createCDVariable(calleeParams[i], new TranslationContext(callee.getIR(), callee, cg, ctx.getPointerAnalysis(), ctx.getTypeInference(), ctx.getPathConditionAnalysis(), ctx.getProgressMonitor(), ctx.getLogger()));
            calleeVParams.add(new HashSet<IVariable>(var));
        }
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)("caller: " + callerVRecv + ", " + callerVParams));
            SAUtil.println((Object)("callee: " + calleeVRecv + ", " + calleeVParams));
            SAUtil.println((Object)("  add parameter rule: " + calleeVRecv + " -> " + callerVRecv));
        }
        for (IVariable calleeVRecvElem : calleeVRecv) {
            for (IVariable callerVRecvElem : callerVRecv) {
                rules.add((IProductionRule)new GRule(calleeVRecvElem, (ISymbol)callerVRecvElem));
            }
        }
        for (List callerVParamsElem : SAUtil.combination1(callerVParams)) {
            for (List calleeVParamsElem : SAUtil.combination1(calleeVParams)) {
                int idx;
                int callerParamSize = callerVParamsElem.size();
                int calleeParamSize = calleeVParamsElem.size();
                if (calleeParamSize >= callerParamSize) {
                    for (idx = 0; idx < callerParamSize; ++idx) {
                        if (SAUtil.DEBUG) {
                            SAUtil.println((Object)("  add parameter rule: " + calleeVParamsElem.get(idx) + " -> " + callerVParamsElem.get(idx)));
                        }
                        rules.add((IProductionRule)new GRule((IVariable)calleeVParamsElem.get(idx), (ISymbol)callerVParamsElem.get(idx)));
                    }
                    while (idx < calleeParamSize) {
                        ISymbol rhs = symFactory.getDefaultParameterValueSymbol();
                        if (SAUtil.DEBUG) {
                            SAUtil.println((Object)("  add default parameter rule: " + calleeVParams.get(idx) + " -> " + rhs));
                        }
                        rules.add((IProductionRule)new GRule((IVariable)calleeVParamsElem.get(idx), rhs));
                        ++idx;
                    }
                    continue;
                }
                while (idx < calleeParamSize) {
                    if (SAUtil.DEBUG) {
                        SAUtil.println((Object)("  add parameter rule: " + calleeVParamsElem.get(idx) + " -> " + callerVParamsElem.get(idx)));
                    }
                    rules.add((IProductionRule)new GRule((IVariable)calleeVParamsElem.get(idx), (ISymbol)callerVParamsElem.get(idx)));
                    ++idx;
                }
            }
        }
        return rules;
    }

    @Override
    public ISimplify translate(PropagationCallGraphBuilder callGraphBuilder) {
        return this.translate((CallGraph)callGraphBuilder.getCallGraph(), callGraphBuilder.getPointerAnalysis(), callGraphBuilder.getOptions(), callGraphBuilder.getContextSelector());
    }

    @Override
    public ISimplify translate(CallGraph callGraph, PointerAnalysis pointerAnalysis, AnalysisOptions options, ContextSelector contextSelector) {
        return this.translate(callGraph, pointerAnalysis);
    }

    protected boolean hasTranslator(TranslationContext ctx) {
        if (ctx.getCallGraph().getEntrypointNodes().contains(ctx.getCGNode())) {
            return true;
        }
        if (ctx.getCGNode().getContext().equals(Everywhere.EVERYWHERE)) {
            return false;
        }
        CallerSiteContext cctx = (CallerSiteContext)ctx.getCGNode().getContext();
        SSAAbstractInvokeInstruction[] invoke = cctx.getCaller().getIR().getCalls(cctx.getCallSite());
        HashSet<String> signatures = new HashSet<String>();
        for (int i = 0; i < invoke.length; ++i) {
            Set<String> s = this.repository.getSignature(invoke[i], ctx);
            signatures.addAll(s);
        }
        return !signatures.isEmpty() && !this.repository.hasAllSignatures(signatures);
    }

    @Override
    public IIR2Grammar<T> getIR2Grammar() {
        return this.ir2gr;
    }

    @Override
    public ITypeInferenceBuilder getTypeInferenceBuilder() {
        return this.typeInferenceBuilder;
    }

    @Override
    public void setTypeInferenceBuilder(ITypeInferenceBuilder builder) {
        this.typeInferenceBuilder = builder;
    }
}

