/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class GRCache<K, V>
implements Map<K, V> {
    private final Map<K, V> M;
    private final Queue<K> queue;
    private final ISizeMeasurement<V> measurement;
    private final int limit;
    private int totalSize;

    public GRCache(Map<K, V> origMap, int limit, ISizeMeasurement<V> measurement) {
        this.M = origMap;
        this.queue = new LinkedList<K>();
        this.limit = limit;
        this.totalSize = 0;
        this.measurement = measurement;
    }

    public GRCache(int limit) {
        this(limit, new DefaultSizeMeasurement());
    }

    public GRCache(int limit, ISizeMeasurement<V> measurement) {
        this(new HashMap(), limit, measurement);
    }

    @Override
    public void clear() {
        this.M.clear();
        this.queue.clear();
        this.totalSize = 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.M.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.M.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.M.entrySet();
    }

    @Override
    public V get(Object key) {
        V val = this.M.get(key);
        if (val != null) {
            this.rotate(key, val);
        }
        return val;
    }

    @Override
    public boolean isEmpty() {
        return this.M.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.M.keySet();
    }

    @Override
    public V put(K key, V value) {
        if (this.rotate(key, value)) {
            return this.M.put(key, value);
        }
        return null;
    }

    private boolean rotate(K key, V val) {
        if (this.M.containsKey(key)) {
            this.queue.remove(key);
            this.queue.add(key);
            return true;
        }
        int m = this.measureSize(val);
        if (m >= this.limit) {
            return false;
        }
        this.totalSize += m;
        this.queue.add(key);
        while (this.totalSize >= this.limit) {
            K k = this.queue.poll();
            V v = this.M.get(k);
            this.M.remove(k);
            this.totalSize -= this.measureSize(v);
        }
        return true;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    private int measureSize(V val) {
        return this.measurement.measure(val);
    }

    @Override
    public V remove(Object key) {
        V val = this.M.get(key);
        this.queue.remove(key);
        this.totalSize -= this.measureSize(val);
        return this.M.remove(key);
    }

    @Override
    public int size() {
        return this.M.size();
    }

    @Override
    public Collection<V> values() {
        return this.M.values();
    }

    public static class DefaultSizeMeasurement<V>
    implements ISizeMeasurement<V> {
        @Override
        public int measure(V v) {
            return 1;
        }
    }

    public static interface ISizeMeasurement<V> {
        public int measure(V var1);
    }
}

