/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.cfg.repository;

import com.ibm.wala.automaton.grammar.string.ContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IllegalGrammarException;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.regex.string.StringPatternSymbol;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.stringAnalysis.grammar.InvocationSymbol;
import com.ibm.wala.stringAnalysis.translator.IConstraintSolver;
import com.ibm.wala.stringAnalysis.translator.ISymbolFactory;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.stringAnalysis.translator.TranslationException;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.StringTranslator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class JavaMatcher
extends StringTranslator {
    private final String matcherSignature = "java.util.regex.Pattern.matcher(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;";

    public JavaMatcher(String matcherSignature) {
    }

    public boolean acceptCyclic() {
        return false;
    }

    private SSAAbstractInvokeInstruction findMatcher(SSAAbstractInvokeInstruction invoke, CGNode node) {
        int matcher = invoke.getReceiver();
        SSAInstruction mi = node.getDU().getDef(matcher);
        if (!(mi instanceof SSAAbstractInvokeInstruction)) {
            return null;
        }
        SSAAbstractInvokeInstruction minvoke = (SSAAbstractInvokeInstruction)mi;
        if (!minvoke.getDeclaredTarget().getSignature().equals("java.util.regex.Pattern.matcher(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;")) {
            return null;
        }
        return minvoke;
    }

    @Override
    public SimpleGrammar prepare(IConstraintSolver<IContextFreeGrammar> solver, String funcName, ISymbol recv, List<ISymbol> params, IProductionRule rule, SimpleGrammar grammar) {
        super.prepare(solver, funcName, recv, params, rule, grammar);
        return null;
    }

    @Override
    public IContextFreeGrammar translate(IContextFreeGrammar a) throws TranslationException {
        CGNode node;
        InvocationSymbol invokeSym = (InvocationSymbol)this.rule.getRight(0);
        if (!(invokeSym.getInstruction() instanceof SSAAbstractInvokeInstruction)) {
            return JavaMatcher.createAnyCFG();
        }
        SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)invokeSym.getInstruction();
        SSAAbstractInvokeInstruction minvoke = this.findMatcher(invoke, node = invokeSym.getCGNode());
        if (minvoke == null) {
            return JavaMatcher.createAnyCFG();
        }
        for (IProductionRule g : this.grammar.getRules()) {
            InvocationSymbol is;
            SSAInstruction isInst;
            ISymbol s;
            List l = g.getRight();
            if (l.isEmpty() || !((s = (ISymbol)l.get(0)) instanceof InvocationSymbol) || (isInst = (is = (InvocationSymbol)s).getInstruction()) == null || !isInst.equals((Object)minvoke)) continue;
            ISymbol pat = is.getReceiver();
            ISymbol text = is.getParameter(0);
            try {
                String regex = this.solveStringConstantParameter(pat);
                IAutomaton fst = new StringPatternSymbol(this.solver.getRegexParser().parse(regex), this.monitor).getCompiledPattern();
                IContextFreeGrammar cfg = (IContextFreeGrammar)this.solveString(text).getLanguage();
                return this.translate(fst, (IContextFreeGrammar)new ContextFreeGrammar(cfg.getStartSymbol(), (Collection)cfg.getRules()));
            }
            catch (IllegalGrammarException illegalGrammarException) {
            }
        }
        return JavaMatcher.createAnyCFG();
    }

    protected Collection<IVariable> getConstraintTarget(SSAAbstractInvokeInstruction invoke, ISymbolFactory<IContextFreeGrammar> symFactory, ISSABasicBlock bb, TranslationContext ctx, int useVN) {
        SSAAbstractInvokeInstruction minvoke = this.findMatcher(invoke, ctx.getCGNode());
        if (minvoke == null) {
            return null;
        }
        int str = minvoke.getUse(useVN);
        IVariable v = symFactory.createValueNumberVariable(str, ctx.getCGNode(), ctx.getCallGraph());
        return Collections.singleton(v);
    }

    protected abstract IContextFreeGrammar translate(IAutomaton var1, IContextFreeGrammar var2) throws TranslationException;
}

