/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.cfg.repository;

import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IEnumerableSymbol;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.CharTranslator;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Homomorphism;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ToLowerCase
extends CharTranslator {
    private static Set<ISymbol> terminals = new HashSet<ISymbol>();

    public ToLowerCase(int target) {
        super(target);
    }

    public ToLowerCase() {
    }

    @Override
    protected Collection<ISymbol> getTerminals(Collection<Homomorphism.Rule> ruleSet) {
        return terminals;
    }

    @Override
    protected ISymbol translate(char c) {
        if ('A' <= c && c <= 'Z') {
            return new CharSymbol(Character.toLowerCase(c));
        }
        return new CharSymbol(c);
    }

    @Override
    protected List<ISymbol> translate(RangeSymbol range) {
        IEnumerableSymbol min = range.getMin();
        IEnumerableSymbol max = range.getMax();
        if (min instanceof CharSymbol) {
            min = (IEnumerableSymbol)this.translate(((CharSymbol)min).charValue());
        }
        if (max instanceof CharSymbol) {
            max = (IEnumerableSymbol)this.translate(((CharSymbol)max).charValue());
        }
        return Arrays.asList(new RangeSymbol(min, max));
    }

    static {
        terminals.add((ISymbol)new RangeSymbol((IEnumerableSymbol)new CharSymbol('\u0000'), (IEnumerableSymbol)new CharSymbol('@')));
        terminals.add((ISymbol)new RangeSymbol((IEnumerableSymbol)new CharSymbol('A'), (IEnumerableSymbol)new CharSymbol('Z')));
        terminals.add((ISymbol)new RangeSymbol((IEnumerableSymbol)new CharSymbol('['), (IEnumerableSymbol)new CharSymbol('\uffff')));
    }
}

