/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular.repository;

import com.ibm.wala.automaton.grammar.string.IllegalGrammarException;
import com.ibm.wala.automaton.regex.string.StringPatternSymbol;
import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.AutomatonSymbol;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.ComplementTransition;
import com.ibm.wala.automaton.string.FilteredTransition;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.ILanguageSymbol;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.PredTransitionSet;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.Transition;
import com.ibm.wala.automaton.string.Variable;
import com.ibm.wala.stringAnalysis.translator.TranslationException;
import com.ibm.wala.stringAnalysis.translator.regular.repository.Transducer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Strreplace
extends Transducer {
    private int repStrIndex;
    private int searchStrIndex;
    private boolean regexSearch;

    public Strreplace(int target, int search, int replace, boolean regexSearch) {
        super(target);
        this.repStrIndex = replace;
        this.searchStrIndex = search;
        this.regexSearch = regexSearch;
    }

    public Strreplace(int search, int replace, boolean regexSearch) {
        this.repStrIndex = replace;
        this.searchStrIndex = search;
        this.regexSearch = regexSearch;
    }

    protected Collection<IAutomaton> solveSearchPatterns(int searchStrIndex) throws IllegalGrammarException {
        Collection<String> strs = this.solveStringConstantParameters(searchStrIndex);
        HashSet<IAutomaton> fsas = new HashSet<IAutomaton>();
        for (String searchStr : strs) {
            Automaton searchFsa;
            Object object = searchFsa = this.regexSearch ? new StringPatternSymbol(this.solver.getRegexParser().parse(searchStr), this.monitor).getCompiledPattern() : Automatons.createAutomaton((List)StringSymbol.toCharSymbols((String)searchStr));
            if (searchFsa == null) {
                throw new IllegalGrammarException("failed to parse " + searchStr);
            }
            fsas.add((IAutomaton)searchFsa);
        }
        return fsas;
    }

    protected Collection<ISymbol> solveReplacementString(int repStrIndex) {
        try {
            Collection<String> strs = this.solveStringConstantParameters(repStrIndex);
            HashSet<ISymbol> syms = new HashSet<ISymbol>();
            for (String s : strs) {
                syms.add((ISymbol)new StringSymbol(s));
            }
            return syms;
        }
        catch (IllegalGrammarException e) {
            ILanguageSymbol s = this.solveStringParameter(repStrIndex);
            return Collections.singleton(s);
        }
    }

    @Override
    public IAutomaton createTransducer() throws TranslationException {
        try {
            Collection<IAutomaton> searchFsas = this.solveSearchPatterns(this.searchStrIndex);
            Collection<ISymbol> repStrs = this.solveReplacementString(this.repStrIndex);
            IAutomaton tr = null;
            for (IAutomaton searchFsa : searchFsas) {
                for (ISymbol repStr : repStrs) {
                    if (tr == null) {
                        tr = Strreplace.createTransducerFor(searchFsa, repStr, (IVariableFactory<IVariable>)this.varFactory);
                        continue;
                    }
                    IAutomaton tr2 = Strreplace.createTransducerFor(searchFsa, repStr, (IVariableFactory<IVariable>)this.varFactory);
                    tr = Automatons.createUnion((IAutomaton)tr, (IAutomaton)tr2);
                }
            }
            return tr;
        }
        catch (IllegalGrammarException e) {
            throw new TranslationException("cannot handle the search key.");
        }
    }

    public static IAutomaton createTransducerFor(IAutomaton searchFSA, ISymbol repStr, IVariableFactory<IVariable> vf) {
        Automatons.eliminateEpsilonTransitions((IAutomaton)searchFSA);
        IState s0 = searchFSA.getInitialState();
        HashSet<Transition> newTransitions = new HashSet<Transition>();
        PredTransitionSet predSet = new PredTransitionSet((Collection)searchFSA.getTransitions());
        for (IState s : searchFSA.getStates()) {
            Set nextTransitions;
            Transition t;
            if (searchFSA.getFinalStates().contains(s)) {
                for (ITransition pred : predSet.getSet((Object)s)) {
                    t = new Transition(pred.getPreState(), s0, pred.getInputSymbol(), new ISymbol[]{repStr});
                    newTransitions.add(t);
                }
            }
            if ((nextTransitions = searchFSA.getTransitions(s)).isEmpty()) continue;
            IAutomaton sub = Automatons.createSublanguageAutomaton((IAutomaton)searchFSA, (IState)s0, (IState)s);
            t = new ComplementTransition(s, s0, (IVariable)new Variable("_"), s == s0 ? Arrays.asList(new Variable("_")) : Collections.singletonList(new AutomatonSymbol(sub)), new FilteredTransition.IFilter(){

                public List<ISymbol> invoke(ISymbol symbol, List<ISymbol> outputs) {
                    return outputs;
                }
            }, (Collection)nextTransitions);
            newTransitions.add(t);
        }
        searchFSA.getTransitions().addAll(newTransitions);
        searchFSA.getFinalStates().clear();
        searchFSA.getFinalStates().add(s0);
        return searchFSA;
    }
}

