/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular.repository;

import com.ibm.wala.analysis.typeInference.JavaPrimitiveType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.automaton.grammar.string.ContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.stringAnalysis.translator.IConstraintSolver;
import com.ibm.wala.stringAnalysis.translator.regular.repository.StringTranslator;
import java.util.HashSet;
import java.util.List;

public class ToCardinalNumberString
extends StringTranslator {
    private int type;
    private PrimitiveType primitiveType;
    public static final int BINARY = 1;
    public static final int HEX = 2;
    public static final int OCTAL = 3;

    public ToCardinalNumberString(int target, int type, PrimitiveType primitiveType) {
        super(target);
        this.type = type;
        this.primitiveType = primitiveType;
    }

    @Override
    public IAutomaton translate(IAutomaton a) {
        return a;
    }

    @Override
    public SimpleGrammar prepare(IConstraintSolver<IAutomaton> translator, String funcName, ISymbol recv, List<ISymbol> params, IProductionRule rule, SimpleGrammar g) {
        super.prepare(translator, funcName, recv, params, rule, g);
        switch (this.type) {
            case 1: {
                return this.createBinaryString();
            }
            case 2: {
                return this.createHexString();
            }
            case 3: {
                return this.createOctalString();
            }
        }
        return null;
    }

    protected SimpleGrammar createBinaryString() {
        HashSet<RangeSymbol> chars = new HashSet<RangeSymbol>();
        chars.add(new RangeSymbol('0', '1'));
        return this.possibleStrings(chars, false);
    }

    protected SimpleGrammar createHexString() {
        HashSet<Object> chars = new HashSet<Object>();
        if (this.primitiveType == JavaPrimitiveType.DOUBLE || this.primitiveType == JavaPrimitiveType.FLOAT) {
            chars.add(new RangeSymbol('0', '9'));
            chars.add(new RangeSymbol('a', 'f'));
            chars.add(new CharSymbol('p'));
            chars.add(new CharSymbol('.'));
            SimpleGrammar g = this.possibleStrings(chars, false);
            IVariable newStart = this.createVariable();
            IVariable origStart = g.getStartSymbol();
            HashSet<ProductionRule> rules = new HashSet<ProductionRule>(g.getRules());
            rules.add(new ProductionRule(newStart, new ISymbol[]{new StringSymbol("0x"), origStart}));
            rules.add(new ProductionRule(newStart, new ISymbol[]{new StringSymbol("-0x"), origStart}));
            rules.add(new ProductionRule(newStart, (ISymbol)new StringSymbol("Infinity")));
            rules.add(new ProductionRule(newStart, (ISymbol)new StringSymbol("-Infinity")));
            rules.add(new ProductionRule(newStart, (ISymbol)new StringSymbol("NaN")));
            return new SimpleGrammar(newStart, rules);
        }
        chars.add(new RangeSymbol('0', '9'));
        chars.add(new RangeSymbol('a', 'f'));
        return this.possibleStrings(chars, false);
    }

    protected SimpleGrammar createOctalString() {
        HashSet<RangeSymbol> chars = new HashSet<RangeSymbol>();
        chars.add(new RangeSymbol('0', '8'));
        return this.possibleStrings(chars, false);
    }

    public boolean acceptCyclic() {
        return true;
    }

    @Override
    public SimpleGrammar possibleGrammar(SimpleGrammar g) {
        ContextFreeGrammar cfg1 = new ContextFreeGrammar(this.createBinaryString());
        ContextFreeGrammar cfg2 = new ContextFreeGrammar(this.createHexString());
        ContextFreeGrammar cfg3 = new ContextFreeGrammar(this.createOctalString());
        return Grammars.createUnion((IContextFreeGrammar)cfg1, (IContextFreeGrammar)Grammars.createUnion((IContextFreeGrammar)cfg2, (IContextFreeGrammar)cfg3)).toSimple();
    }
}

