/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular.repository;

import com.ibm.wala.analysis.typeInference.JavaPrimitiveType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IllegalAutomatonException;
import com.ibm.wala.automaton.string.NumberSymbol;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.Transition;
import com.ibm.wala.stringAnalysis.translator.IConstraintSolver;
import com.ibm.wala.stringAnalysis.translator.regular.repository.StringTranslator;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ToString
extends StringTranslator {
    private PrimitiveType type;

    public ToString(int target, PrimitiveType type) {
        super(target);
        this.type = type;
    }

    public ToString(PrimitiveType type) {
        this.type = type;
    }

    public ToString(int target) {
        super(target);
        this.type = null;
    }

    public ToString() {
        this.type = null;
    }

    @Override
    public SimpleGrammar prepare(IConstraintSolver<IAutomaton> translator, String funcName, ISymbol recv, List<ISymbol> params, IProductionRule rule, SimpleGrammar g) {
        SimpleGrammar sg = super.prepare(translator, funcName, recv, params, rule, g);
        sg.getRules().remove(rule);
        sg.getRules().add(new ProductionRule(rule.getLeft(), params));
        return sg;
    }

    @Override
    public IAutomaton translate(IAutomaton a) {
        Collection symbols;
        if (this.type == null) {
            return a;
        }
        HashSet<Object> terminals = new HashSet<Object>();
        HashSet<Object> strings = new HashSet<Object>();
        boolean useSign = false;
        if (this.type.equals((Object)JavaPrimitiveType.DOUBLE) || this.type.equals((Object)JavaPrimitiveType.FLOAT)) {
            try {
                symbols = Automatons.numberValues((IAutomaton)a);
                for (NumberSymbol s : symbols) {
                    strings.add(new StringSymbol(Double.toString(s.doubleValue())));
                }
            }
            catch (IllegalAutomatonException e) {
                terminals.add(new RangeSymbol('0', '9'));
                terminals.add(new CharSymbol('.'));
                useSign = true;
            }
        } else if (this.type.equals((Object)JavaPrimitiveType.INT) || this.type.equals((Object)JavaPrimitiveType.LONG) || this.type.equals((Object)JavaPrimitiveType.BYTE) || this.type.equals((Object)JavaPrimitiveType.SHORT)) {
            try {
                symbols = Automatons.numberValues((IAutomaton)a);
                for (NumberSymbol s : symbols) {
                    strings.add(new StringSymbol(Long.toString(s.longValue())));
                }
            }
            catch (IllegalAutomatonException e) {
                terminals.add(new RangeSymbol('0', '9'));
                useSign = true;
            }
        } else if (this.type.equals((Object)JavaPrimitiveType.CHAR)) {
            try {
                symbols = Automatons.constantValues((IAutomaton)a, ISymbol.class);
                for (ISymbol s : symbols) {
                    if (s instanceof NumberSymbol) {
                        NumberSymbol n = (NumberSymbol)s;
                        strings.add(new CharSymbol((char)n.intValue()));
                        continue;
                    }
                    if (s instanceof CharSymbol) {
                        strings.add(s);
                        continue;
                    }
                    if (!(s instanceof RangeSymbol)) continue;
                    strings.add(s);
                }
            }
            catch (IllegalAutomatonException e) {
                terminals.add(new RangeSymbol('\u0000', '\uffff'));
            }
        } else if (this.type.equals((Object)JavaPrimitiveType.BOOLEAN)) {
            try {
                symbols = Automatons.numberValues((IAutomaton)a);
                for (NumberSymbol s : symbols) {
                    strings.add(new StringSymbol(s.intValue() == 0 ? "false" : "true"));
                }
            }
            catch (IllegalAutomatonException e) {
                terminals.add(new StringSymbol("true"));
                terminals.add(new StringSymbol("false"));
            }
        } else {
            Assertions.UNREACHABLE((Object)this.type);
        }
        if (terminals.isEmpty()) {
            return this.unionStringsAsFST(strings);
        }
        IAutomaton result = ToString.possibleStringsAsFST(terminals, false);
        if (useSign) {
            IState s0 = result.getInitialState();
            result.getTransitions().add(new Transition(s0, s0, (ISymbol)new CharSymbol('-')));
        }
        return result;
    }

    public IAutomaton translateCyclic(IAutomaton a, Set<ISymbol> terminals) {
        return this.translate(a);
    }

    public Set<ISymbol> possibleOutputs(Set<ISymbol> terminals) {
        return terminals;
    }

    public boolean acceptCyclic() {
        return true;
    }
}

