/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.aspdotnetmvc3;

import com.ibm.appscan.frameworks.FrameworksInput;
import com.ibm.appscan.frameworks.aspdotnet.CompiledFileInfo;
import com.ibm.appscan.frameworks.aspdotnet.util.DotNetVDBUtil;
import com.ibm.appscan.frameworks.aspdotnet.util.DotNetWalaUtil;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MvcViewFinder {
    private FrameworksInput fwInput;
    private F4FApp app;
    private Map<String, IClass> urlToClassMap;
    private static String[] viewLocationFormats = new String[]{"/Web/Views/%2$s/%1$s.aspx", "/Web/Views/%2$s/%1$s.ascx", "/Web/Views/Shared/%1$s.aspx", "/Web/Views/Shared/%1$s.ascx", "/Web/Views/%2$s/%1$s.cshtml", "/Web/Views/%2$s/%1$s.vbhtml", "/Web/Views/Shared/%1$s.cshtml", "/Web/Views/Shared/%1$s.vbhtml"};

    public MvcViewFinder(FrameworksInput fwInput, F4FApp app) {
        this.fwInput = fwInput;
        this.app = app;
    }

    public void findViews() {
        Set<String> compiledFileNames = this.findCompiledFiles();
        this.urlToClassMap = new TreeMap<String, IClass>();
        for (String compiledFileName : compiledFileNames) {
            this.handleCompiledFile(compiledFileName, this.urlToClassMap);
        }
    }

    private Set<String> findCompiledFiles() {
        File[] compiledFiles;
        String precompileOutputDir = this.fwInput.getOptions().getProperty("aspnet.precompile.dir");
        File binDir = new File(precompileOutputDir + "/bin");
        if (!binDir.exists() || !binDir.isDirectory()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (File f : compiledFiles = binDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().endsWith(".compiled");
            }
        })) {
            result.add(f.getAbsolutePath());
        }
        return result;
    }

    private void handleCompiledFile(String compiledFile, Map<String, IClass> results) {
        CompiledFileInfo info;
        TaintLogger.i().getLogger().info((Object)("AspDotNetMvc3Handler:: Handling compiled file " + compiledFile));
        try {
            info = new CompiledFileInfo(compiledFile);
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().error((Object)("AspDotNetMvc3Handler:: Error reading file " + compiledFile), (Throwable)e);
            return;
        }
        String url = info.getVirtualPath();
        if (url == null) {
            TaintLogger.i().getLogger().info((Object)("AspDotNetMvc3Handler:: virtual path null in compiled file " + compiledFile));
            return;
        }
        String type = info.getType();
        if (type == null) {
            TaintLogger.i().getLogger().info((Object)("AspDotNetMvc3Handler:: type attribute null in compiled file " + compiledFile));
            return;
        }
        String assembly = info.getAssembly();
        if (assembly == null) {
            TaintLogger.i().getLogger().info((Object)("AspDotNetMvc3Handler:: assembly attribute null in compiled file " + compiledFile));
            return;
        }
        IClass klass = DotNetWalaUtil.getIClass((String)type, (String)assembly, (IClassHierarchy)this.app.getClassHierarchy());
        if (klass == null) {
            TaintLogger.i().getLogger().info((Object)("AspDotNetMvc3Handler:: could not find type " + type + " from assembly " + assembly));
            return;
        }
        TaintLogger.i().getLogger().info((Object)("AspDotNetMvc3Handler:: Found view " + DotNetVDBUtil.walaDotNet2VDBType((String)klass.getName().toString()) + " at url " + url));
        results.put(url.toLowerCase(), klass);
    }

    public IClass getViewForAction(String controllerName, String actionName) {
        return this.getViewByName(controllerName, actionName);
    }

    public IClass getViewByName(String controllerName, String viewName) {
        for (String viewLocFormat : viewLocationFormats) {
            String viewLocation = String.format(viewLocFormat, viewName, controllerName).toLowerCase();
            IClass result = this.urlToClassMap.get(viewLocation);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

