/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.client;

import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.samso.client.IM2LStringAnalyzer;
import com.ibm.wala.samso.client.IPathVerifier;
import com.ibm.wala.samso.m2lstr.DeclarationSets;
import com.ibm.wala.samso.m2lstr.IExtendedFormulaFactory;
import com.ibm.wala.samso.path.PathFeasibilityAnalysis;
import com.ibm.wala.samso.translator.IDeclarationSet;
import com.ibm.wala.samso.translator.repository.M2LTranslatorRepository;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.stringAnalysis.client.IGrammarBasedStringAnalyzer;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.MonitorUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class M2LPathVerifier
implements IPathVerifier {
    private final IGrammarBasedStringAnalyzer<IDeclarationSet> analyzer;
    private final MonitorUtil.IProgressMonitor monitor;
    private final Logger logger;

    public M2LPathVerifier(IGrammarBasedStringAnalyzer<IDeclarationSet> analyzer, MonitorUtil.IProgressMonitor monitor, Logger logger) {
        this.analyzer = analyzer;
        this.monitor = monitor;
        this.logger = logger;
    }

    protected Collection<ISSABasicBlock> collectBasicBlocks(CGNode node, boolean bval, boolean conservativeCollection) {
        IR ir = node.getIR();
        SymbolTable tbl = ir.getSymbolTable();
        SSACFG cfg = ir.getControlFlowGraph();
        HashSet<ISSABasicBlock> bbs = new HashSet<ISSABasicBlock>();
        block0: for (ISSABasicBlock bb : node.getIR().getControlFlowGraph()) {
            for (SSAInstruction instruction : bb) {
                if (!(instruction instanceof SSAReturnInstruction)) continue;
                SSAReturnInstruction retInst = (SSAReturnInstruction)instruction;
                int retv = retInst.getResult();
                this.collectBasicBlocks(node, cfg, tbl, bval, bb, retv, conservativeCollection, bbs);
                continue block0;
            }
        }
        return bbs;
    }

    private void collectBasicBlocks(CGNode node, SSACFG cfg, SymbolTable tbl, boolean bval, ISSABasicBlock bb, int retv, boolean conservativeCollection, Collection<ISSABasicBlock> bbs) {
        if (tbl.isConstant(retv)) {
            Object obj = tbl.getConstantValue(retv);
            if (obj instanceof Integer) {
                Integer intval = (Integer)obj;
                if (bval && intval > 0 || !bval && intval == 0) {
                    bbs.add(bb);
                }
                return;
            }
        } else {
            SSAInstruction d = node.getDU().getDef(retv);
            if (d instanceof SSAPhiInstruction) {
                SSAPhiInstruction phi = (SSAPhiInstruction)d;
                for (int i = 0; i < phi.getNumberOfUses(); ++i) {
                    int retvp = phi.getUse(i);
                    ISSABasicBlock pbb = this.getPredecessor(cfg, bb, i);
                    this.collectBasicBlocks(node, cfg, tbl, bval, pbb, retvp, conservativeCollection, bbs);
                }
                return;
            }
        }
        if (conservativeCollection) {
            SAUtil.println((Object)("the basic block " + bb + " was conservatively collected."));
            bbs.add(bb);
        } else {
            SAUtil.println((Object)("the basic block " + bb + " was conservatively excluded."));
        }
    }

    private ISSABasicBlock getPredecessor(SSACFG cfg, ISSABasicBlock bb, int nth) {
        Iterator iter = cfg.getPredNodes(bb);
        while (nth > 0) {
            iter.next();
            --nth;
        }
        return (ISSABasicBlock)iter.next();
    }

    protected PathFeasibilityAnalysis createPathFeasibilityAnalysis(CGNode node) {
        PathFeasibilityAnalysis pfa = new PathFeasibilityAnalysis(node, (IM2LStringAnalyzer)this.analyzer, SAUtil.nullProgressMonitor, this.logger);
        return pfa;
    }

    protected void setInputPattern(PathFeasibilityAnalysis pfa, String pat) {
        M2LTranslatorRepository repository = (M2LTranslatorRepository)this.analyzer.getRepository();
        IExtendedFormulaFactory ffactory = repository.getFormulaFactory();
        IDeclarationSet inputSpec = DeclarationSets.createDeclarationSetForRegexp(pat, ffactory);
        pfa.setInputPattern(inputSpec);
    }

    @Override
    public boolean checkFeasibility(CGNode node, String pat, boolean bval) {
        Collection<ISSABasicBlock> bbs = this.collectBasicBlocks(node, bval, true);
        PathFeasibilityAnalysis pfa = this.createPathFeasibilityAnalysis(node);
        this.setInputPattern(pfa, pat);
        return pfa.isFeasible(bbs);
    }

    @Override
    public boolean checkInfeasibility(CGNode node, String pat, boolean bval) {
        Collection<ISSABasicBlock> bbs = this.collectBasicBlocks(node, bval, true);
        PathFeasibilityAnalysis pfa = this.createPathFeasibilityAnalysis(node);
        this.setInputPattern(pfa, pat);
        return pfa.isInfeasible(bbs);
    }
}

