#ifndef _PdbParser_h
#define _PdbParser_h

#include "dia2.h"
#include "range.hpp"
#include <map>
#include <vector>

#ifndef DECLSPEC
#define DECLSPEC __declspec(dllimport)
#endif

extern BSTR g_wszFilename;
extern IDiaDataSource* g_pDiaDataSource;
extern IDiaSession* g_pDiaSession;
extern IDiaSymbol* g_pGlobalSymbol;
extern DWORD g_dwMachineType;

std::map<BSTR, std::vector<BSTR> *> *GetAllSourceFiles( IDiaSession *, IDiaSymbol * );
bool LoadDataFromPdb( wchar_t *, IDiaDataSource  **, IDiaSession **, IDiaSymbol ** );

extern "C" {
	DECLSPEC void __stdcall Cleanup();
	DECLSPEC bool __stdcall LoadDataFromPdb( wchar_t * );
	DECLSPEC std::map<BSTR, std::vector<BSTR> *> * __stdcall GetAllSourceFiles();
	DECLSPEC std::map<range<DWORD> *,std::pair<unsigned long,BSTR> *> * __stdcall GetLineNumbers( BSTR, BSTR );
}

#endif