BEGIN {
    FS="[. ]+";
}

match($2, /^0x/) == 0 {
    bytecode = $1;
    opcode = $2;
    opcodes[opcode] = 1;
    name = "inst_" opcode;

    inst = "((byte)" bytecode ", Opcode.op_" opcode;
    if (NF >=3) {
	for(i = 3; i <= NF; i++) {
	    flags[$i] = 1;
	    inst = inst ((i==3)? ", EnumSet.of(": ", ") "Flag.flag_"  $i;
	    name = name "_" $i;
	}
	inst = inst ")";
    } 
    inst = sprintf("%-20s", name) inst ")";
    insts[inst] = 1;
}

match($2, /^0x/) != 0 {
    second_byte = $2;
    prefix_code = $3;
    prefixes[prefix_code] = 1;
    name = "prefix_" prefix_code;

    inst = "((byte)" second_byte ", Prefix.op_" prefix_code;
    if (NF >= 4) {
	for(i = 4; i <= NF; i++) {
	    flags[$i] = 1;
	    inst = inst ((i==4)? ", EnumSet.of(": ", ") "Flag.flag_"  $i;
	    name = name "_" $i;
	}
	inst = inst ")";
    } 

    inst = sprintf("%-20s", name) inst ")";
    prefixed[inst] = 1;
}

END {
    print "// Generated file -- do not edit";
    print "package com.ibm.wala.dotnet.cil;\n";
    print "import java.util.*;\n";
    print "import com.ibm.wala.dotnet.Constants;\n";
    print "public class Bytecode {";

    print "\n  public final static byte prefixByte = (byte)0xFE;";

    print "\n  public final static Inst[] insts = new Inst[256];";

    print "\n  public final static InstPrefix[] instPrefixes = new InstPrefix[256];";

    printf("\n  public enum Flag { ");
    first = 0;
    for(flag in flags) {
	if (first == 0) {
	    first = 1;
	    printf("flag_%s", flag);
	} else {
	    printf(", flag_%s", flag);
	}
    }
    print " }";

    print "\n  public interface CILVisitor {";
    for(opcode in opcodes) {
	print "    void visit_" opcode "(Set<Flag> flags);";
    }
    print "}";

    print "\n  public enum Opcode {";
    first = 0;
    for(opcode in opcodes) {
	if (first == 0) {
	    first = 1;
	    printf("    ");
	} else {
	    printf(",\n    ");
	}

	print "op_" opcode " {";
        print "       public void visit(CILVisitor v, Set<Flag> flags) {";
	print "         if (Constants.TRACE_VISITORS) {";
	print "           System.err.println(\"visit " opcode " with \" + flags);";
	print "         }";
        print "         v.visit_" opcode "(flags);";
	print "       }";
	printf("    }")
    }
    print ";";
    print "\n    public abstract void visit(CILVisitor v, Set<Flag> flags);";
    print "\n }";

    print "\n  public interface CILPrefixVisitor {";
    for(opcode in prefixes) {
	print "    void visit_" opcode "(Set<Flag> flags);";
    }
    print "}";

    printf("\n  public enum Prefix {\n");
    first = 0;
    for(prefix in prefixes) {
	if (first == 0) {
	    first = 1;
	    printf("    ");
	} else {
	    printf(",\n    ");
	}

	print "op_" prefix " {";
        print "       public void visit(CILPrefixVisitor v, Set<Flag> flags) {";
	print "         if (Constants.TRACE_VISITORS) {";
	print "           System.err.println(\"visit " prefix " with \" + flags);";
	print "         }";
        print "         v.visit_" prefix "(flags);";
	print "       }";
	printf("    }")

    }
    print ";";
    print "\n    public abstract void visit(CILPrefixVisitor v, Set<Flag> flags);";
    print "\n }";

    printf("\n  public enum Inst {\n");
    first = 0;
    for(inst in insts) {
	if (first == 0) {
	    first = 1;
	    printf("    %s", inst);
	} else {
	    printf(",\n    %s", inst);
	}
    }
    print ";";
    print "";
    print "    private final byte opcode;";
    print "    private final Opcode op;";
    print "    private final Set<Flag> flags;";
    print "";
    print "    public void visit(CILVisitor v) {";
    print "      op.visit(v, flags);";
    print "    }";
    print "";
    print "    public String toString() {";
    print "      StringBuffer sb = new StringBuffer(opcode).append(op);";
    print "      for(Flag f : flags) {";
    print "        sb.append(\".\").append(f);";
    print "      }";
    print "      return sb.toString();";
    print "    }";
    print "";
    print "    private Inst(byte opcode, Opcode op, Set<Flag> flags) {";
    print "      this.opcode = opcode;";
    print "      this.op = op;";
    print "      this.flags = flags;";
    print "    }";
    print "";
    print "    private Inst(byte opcode, Opcode op) {";
    print "      this(opcode, op, Collections.<Flag>emptySet());";
    print "    }";
    print "  }";

    printf("\n  public enum InstPrefix {\n");
    first = 0;
    for(prefix in prefixed) {
	if (first == 0) {
	    first = 1;
	    printf("    %s", prefix);
	} else {
	    printf(",\n    %s", prefix);
	}
    }
    print ";";
    print "";
    print "    private final byte opcode;";
    print "    private final Prefix op;";
    print "    private final Set<Flag> flags;";
    print "";
    print "    public void visit(CILPrefixVisitor v) {";
    print "      op.visit(v, flags);";
    print "    }";
    print "";
    print "    public String toString() {";
    print "      StringBuffer sb = new StringBuffer(opcode).append(op);";
    print "      for(Flag f : flags) {";
    print "        sb.append(\".\").append(f);";
    print "      }";
    print "      return sb.toString();";
    print "    }";
    print "";
    print "    private InstPrefix(byte opcode, Prefix op, Set<Flag> flags) {";
    print "      this.opcode = opcode;";
    print "      this.op = op;";
    print "      this.flags = flags;";
    print "    }";
    print "";
    print "    private InstPrefix(byte opcode, Prefix op) {";
    print "      this(opcode, op, Collections.<Flag>emptySet());";
    print "    }";
    print "  }";
    print "";
    print "  static {";
    print "    for(Inst i : Inst.values()) {";
    print "      insts[ i.opcode + 128 ] = i;";
    print "    }";
    print "    for(InstPrefix p : InstPrefix.values()) {";
    print "      instPrefixes[ p.opcode ] = p;";
    print "    }";
    print "  }";

    print "}";
}