using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;

namespace CSharpImpl
{
	public struct AttributeArgumentInfo {
		readonly Type _type;
		readonly string _val;
		
		#region CTOR
		public AttributeArgumentInfo(Type type, string val) {
			_type = type;
			_val = val;
		}
		#endregion
		
		#region Properties
		public ClassInfo type 
		{
			get {
				return new ClassInfo(_type);
			}
		}
		
		public string val
		{
			get {
				return _val;
			}
		}
		#endregion
	}
	
    public class AttributeInfo
    {
        private readonly System.Type attribute;
		private readonly AttributeArgumentInfo[] arguments;

        #region CTOR
		public AttributeInfo(CustomAttributeData att) {
			int i = 0;
			IList<CustomAttributeTypedArgument> args = att.ConstructorArguments;
			AttributeArgumentInfo[] arguments = new AttributeArgumentInfo[args.Count];
			foreach (CustomAttributeTypedArgument arg in args) {
				Type t = arg.ArgumentType;
				object v = arg.Value;
				arguments[i++] = new AttributeArgumentInfo(t,String.Format("{0}", v));
			}
			this.attribute = att.Constructor.DeclaringType;
			this.arguments = arguments;
		}
			
        public AttributeInfo(System.Type attribute, AttributeArgumentInfo[] arguments)
        {
            this.attribute = attribute;
			this.arguments = arguments;
        }
        #endregion

        #region Properties
		public AttributeArgumentInfo[] Arguments 
		{
			get
			{
				return arguments;
			}
		}
		
        public System.Type Attribute
        {
            get
            {
                return attribute;
            }
        }

        public ClassInfo Type
        {
            get
            {
                 return new ClassInfo(attribute);
            }
        }
		
		public override int GetHashCode()
        {
                 return attribute.GetHashCode();
        }

        public override Boolean Equals(Object other)
        {
            if (! (other is AttributeInfo)) {
				return false;
			}
			AttributeInfo otherCI = (AttributeInfo) other;
			
			if (! this.attribute.Equals(otherCI.attribute)) {
				return false;
			}
			
			if (arguments.Length != otherCI.arguments.Length) {
				return false;
			}
			for(int i = 0; i < arguments.Length; i++) {
				if (! arguments[i].Equals(otherCI.arguments[i])) {
					return false;
				}
            }
			
            return true;
        }

        #endregion
    }
}
