/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection.java7;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAFieldAccessInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;

public class MethodHandles {
    private static final IntSet self = IntSetUtil.make((int[])new int[0]);
    private static ContextKey METHOD_KEY = new ContextKey(){

        public String toString() {
            return "METHOD_KEY";
        }
    };

    private static boolean isInvoke(IMethod node) {
        return node.getName().toString().startsWith("invoke");
    }

    private static boolean isType(IMethod node) {
        return node.getName().toString().equals("type");
    }

    private static boolean isInvoke(CGNode node) {
        return MethodHandles.isInvoke(node.getMethod());
    }

    private static boolean isType(CGNode node) {
        return MethodHandles.isType(node.getMethod());
    }

    public static class ContextInterpreterImpl
    implements SSAContextInterpreter {
        private final Map<CGNode, SoftReference<IR>> irs = HashMapFactory.make();

        @Override
        public Iterator<NewSiteReference> iterateNewSites(CGNode node) {
            return this.getIR(node).iterateNewSites();
        }

        public Iterator<FieldReference> iterateFields(CGNode node, Predicate<SSAInstruction> filter) {
            return new MapIterator((Iterator)new FilterIterator(this.getIR(node).iterateNormalInstructions(), filter), (Function)new Function<SSAInstruction, FieldReference>(){

                public FieldReference apply(SSAInstruction object) {
                    return ((SSAFieldAccessInstruction)object).getDeclaredField();
                }
            });
        }

        @Override
        public Iterator<FieldReference> iterateFieldsRead(CGNode node) {
            return this.iterateFields(node, new Predicate<SSAInstruction>(){

                public boolean test(SSAInstruction o) {
                    return o instanceof SSAGetInstruction;
                }
            });
        }

        @Override
        public Iterator<FieldReference> iterateFieldsWritten(CGNode node) {
            return this.iterateFields(node, new Predicate<SSAInstruction>(){

                public boolean test(SSAInstruction o) {
                    return o instanceof SSAPutInstruction;
                }
            });
        }

        @Override
        public boolean recordFactoryType(CGNode node, IClass klass) {
            return false;
        }

        @Override
        public boolean understands(CGNode node) {
            return (MethodHandles.isInvoke(node) || MethodHandles.isType(node)) && node.getContext() instanceof MethodContext;
        }

        @Override
        public Iterator<CallSiteReference> iterateCallSites(CGNode node) {
            return this.getIR(node).iterateCallSites();
        }

        @Override
        public IR getIR(CGNode node) {
            if (!this.irs.containsKey(node) || this.irs.get(node).get() == null) {
                MethodSummary code = new MethodSummary(node.getMethod().getReference());
                SummarizedMethod m = new SummarizedMethod(node.getMethod().getReference(), code, node.getMethod().getDeclaringClass());
                SSAInstructionFactory insts = node.getMethod().getDeclaringClass().getClassLoader().getLanguage().instructionFactory();
                assert (node.getContext() instanceof MethodContext);
                MethodReference ref = ((MethodContext)node.getContext()).method;
                boolean isStatic = node.getClassHierarchy().resolveMethod(ref).isStatic();
                if (MethodHandles.isInvoke(node)) {
                    String name = node.getMethod().getName().toString();
                    if ("invokeWithArguments".equals(name)) {
                        int nargs = ref.getNumberOfParameters();
                        int[] params = new int[nargs];
                        for (int i = 0; i < nargs; ++i) {
                            code.addConstant(i + nargs + 3, new ConstantValue(i));
                            code.addStatement(insts.ArrayLoadInstruction(code.getNextProgramCounter(), i + 3, 1, i + nargs + 3, TypeReference.JavaLangObject));
                            params[i] = i + 3;
                        }
                        CallSiteReference site = CallSiteReference.make(nargs + 1, ref, (IInvokeInstruction.IDispatch)(isStatic ? IInvokeInstruction.Dispatch.STATIC : IInvokeInstruction.Dispatch.SPECIAL));
                        code.addStatement(insts.InvokeInstruction(code.getNextProgramCounter(), 2 * nargs + 3, params, 2 * nargs + 4, site, null));
                        code.addStatement(insts.ReturnInstruction(code.getNextProgramCounter(), 2 * nargs + 3, false));
                    } else {
                        int n = node.getMethod().getNumberOfParameters();
                    }
                } else {
                    assert (MethodHandles.isType(node));
                    code.addStatement(insts.LoadMetadataInstruction(code.getNextProgramCounter(), 2, TypeReference.JavaLangInvokeMethodType, ref.getDescriptor()));
                    code.addStatement(insts.ReturnInstruction(code.getNextProgramCounter(), 2, false));
                }
                this.irs.put(node, new SoftReference<IR>(m.makeIR(node.getContext(), SSAOptions.defaultOptions())));
            }
            return this.irs.get(node).get();
        }

        @Override
        public DefUse getDU(CGNode node) {
            return new DefUse(this.getIR(node));
        }

        @Override
        public int getNumberOfStatements(CGNode node) {
            return this.getIR(node).getInstructions().length;
        }

        @Override
        public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG(CGNode n) {
            return this.getIR(n).getControlFlowGraph();
        }
    }

    public static class ContextSelectorImpl
    implements ContextSelector {
        private final ContextSelector base;

        public ContextSelectorImpl(ContextSelector base) {
            this.base = base;
        }

        @Override
        public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] actualParameters) {
            InstanceKey selfKey;
            Context baseContext = this.base.getCalleeTarget(caller, site, callee, actualParameters);
            if ((MethodHandles.isInvoke(callee) || MethodHandles.isType(callee)) && callee.getDeclaringClass().getReference().equals(TypeReference.JavaLangInvokeMethodHandle) && actualParameters != null && actualParameters.length > 0 && (selfKey = actualParameters[0]) instanceof ConstantKey && ((ConstantKey)selfKey).getConcreteType().getReference().equals(TypeReference.JavaLangInvokeMethodHandle)) {
                MethodReference ref = ((IMethod)((ConstantKey)selfKey).getValue()).getReference();
                return new MethodContext(baseContext, ref);
            }
            return baseContext;
        }

        @Override
        public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
            return self;
        }
    }

    public static class MethodContext
    implements Context {
        private final Context base;
        private final MethodReference method;

        public MethodContext(Context base, MethodReference method) {
            this.base = base;
            this.method = method;
        }

        @Override
        public ContextItem get(ContextKey name) {
            if (METHOD_KEY.equals(name)) {
                return new MethodItem(this.method);
            }
            return this.base.get(name);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodContext other = (MethodContext)obj;
            if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
                return false;
            }
            return !(this.method == null ? other.method != null : !this.method.equals(other.method));
        }

        public String toString() {
            return "ctxt:" + this.method.getName();
        }
    }

    public static class MethodItem
    implements ContextItem {
        private final MethodReference method;

        public MethodItem(MethodReference method) {
            this.method = method;
        }

        public MethodReference getMethod() {
            return this.method;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodItem other = (MethodItem)obj;
            return !(this.method == null ? other.method != null : !this.method.equals(other.method));
        }
    }
}

