/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.ShrikeCFG;
import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.ssa.SSABuilder;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.ShrikeIndirectionData;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.ssa.analysis.DeadAssignmentElimination;
import com.ibm.wala.util.WalaRuntimeException;

public class ShrikeIRFactory
implements IRFactory<IBytecodeMethod> {
    public static final boolean buildLocalMap = true;

    public ControlFlowGraph makeCFG(IBytecodeMethod method, Context C) {
        return ShrikeCFG.make(method);
    }

    @Override
    public IR makeIR(final IBytecodeMethod method, Context C, final SSAOptions options) throws IllegalArgumentException {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        IInstruction[] shrikeInstructions = null;
        try {
            shrikeInstructions = method.getInstructions();
        }
        catch (InvalidClassFileException e) {
            throw new WalaRuntimeException("bad method bytecodes", (Throwable)e);
        }
        final ShrikeCFG shrikeCFG = (ShrikeCFG)this.makeCFG(method, C);
        final SymbolTable symbolTable = new SymbolTable(method.getNumberOfParameters());
        final SSAInstruction[] newInstrs = new SSAInstruction[shrikeInstructions.length];
        final SSACFG newCfg = new SSACFG(method, shrikeCFG, newInstrs);
        return new IR(method, newInstrs, symbolTable, newCfg, options){
            private final IR.SSA2LocalMap localMap;
            private final ShrikeIndirectionData indirectionData;
            {
                super(method2, instructions, symbolTable3, cfg, options2);
                SSABuilder builder = SSABuilder.make(method, newCfg, shrikeCFG, newInstrs, symbolTable, true, options.getPiNodePolicy());
                builder.build();
                this.localMap = builder.getLocalMap();
                this.indirectionData = builder.getIndirectionData();
                this.eliminateDeadPhis();
                this.setupLocationMap();
            }

            private void eliminateDeadPhis() {
                DeadAssignmentElimination.perform(this);
            }

            @Override
            protected String instructionPosition(int instructionIndex) {
                try {
                    int bcIndex = method.getBytecodeIndex(instructionIndex);
                    int lineNumber = method.getLineNumber(bcIndex);
                    if (lineNumber == -1) {
                        return "";
                    }
                    return "(line " + lineNumber + ")";
                }
                catch (InvalidClassFileException e) {
                    return "";
                }
            }

            @Override
            public IR.SSA2LocalMap getLocalMap() {
                return this.localMap;
            }

            protected ShrikeIndirectionData getIndirectionData() {
                return this.indirectionData;
            }
        };
    }

    @Override
    public boolean contextIsIrrelevant(IBytecodeMethod method) {
        return true;
    }
}

