/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.rta;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.rta.CallSite;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.Set;

public class DelegatingExplicitCallGraph
extends ExplicitCallGraph {
    private final IBinaryNaturalRelation delegateR = new BasicNaturalRelation();

    public DelegatingExplicitCallGraph(IClassHierarchy cha, AnalysisOptions options, AnalysisCache cache) {
        super(cha, options, cache);
    }

    @Override
    protected ExplicitCallGraph.ExplicitNode makeNode(IMethod method, Context context) {
        return new DelegatingCGNode(method, context);
    }

    @Override
    protected ExplicitCallGraph.ExplicitEdgeManager makeEdgeManger() {
        return new DelegatingEdgeManager();
    }

    private class DelegatingEdgeManager
    extends ExplicitCallGraph.ExplicitEdgeManager {
        private DelegatingEdgeManager() {
        }

        @Override
        public void addEdge(CGNode src, CGNode dst) {
            super.addEdge(src, dst);
        }

        @Override
        public void removeAllIncidentEdges(CGNode node) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeIncomingEdges(CGNode node) {
            Assertions.UNREACHABLE();
        }

        @Override
        public void removeOutgoingEdges(CGNode node) {
            Assertions.UNREACHABLE();
        }

        @Override
        public boolean hasEdge(CGNode src, CGNode dst) {
            if (super.hasEdge(src, dst)) {
                return true;
            }
            DelegatingCGNode s = (DelegatingCGNode)src;
            int y = DelegatingExplicitCallGraph.this.getNumber(dst);
            return s.hasTarget(y);
        }

        @Override
        public int getPredNodeCount(CGNode N) {
            IntSet s = this.getPredNodeNumbers(N);
            return s == null ? 0 : s.size();
        }

        @Override
        public IntSet getPredNodeNumbers(CGNode node) {
            IntSet superR = super.getPredNodeNumbers(node);
            if (superR == null) {
                return null;
            }
            MutableSparseIntSet result = MutableSparseIntSet.make((IntSet)superR);
            BitVectorIntSet allPossiblePreds = new BitVectorIntSet(superR);
            IntIterator it = superR.intIterator();
            while (it.hasNext()) {
                int x = it.next();
                IntSet ySet = DelegatingExplicitCallGraph.this.delegateR.getRelated(x);
                if (ySet == null) continue;
                allPossiblePreds.addAll(ySet);
            }
            it = allPossiblePreds.intIterator();
            while (it.hasNext()) {
                int y = it.next();
                DelegatingCGNode yNode = (DelegatingCGNode)DelegatingExplicitCallGraph.this.getNode(y);
                if (!this.hasEdge(yNode, node)) continue;
                result.add(y);
            }
            return result;
        }
    }

    public class DelegatingCGNode
    extends ExplicitCallGraph.ExplicitNode {
        protected DelegatingCGNode(IMethod method, Context C) {
            super(method, C);
        }

        @Override
        public MutableSharedBitVectorIntSet getAllTargetNumbers() {
            MutableSharedBitVectorIntSet result = new MutableSharedBitVectorIntSet(super.getAllTargetNumbers());
            for (Object n : this.targets) {
                ExplicitCallGraph.ExplicitNode delegate;
                IntSet s;
                if (!(n instanceof CallSite) || (s = DelegatingExplicitCallGraph.this.getPossibleTargetNumbers(delegate = (ExplicitCallGraph.ExplicitNode)((CallSite)((Object)n)).getNode(), ((CallSite)((Object)n)).getSite())) == null) continue;
                result.addAll(s);
            }
            return result;
        }

        @Override
        public Set<CGNode> getPossibleTargets(CallSiteReference site) {
            Object result = this.targets.get(site.getProgramCounter());
            if (result != null && result instanceof CallSite) {
                CallSite p = (CallSite)((Object)result);
                CGNode n = p.getNode();
                CallSiteReference s = p.getSite();
                return DelegatingExplicitCallGraph.this.getPossibleTargets(n, s);
            }
            return super.getPossibleTargets(site);
        }

        @Override
        public IntSet getPossibleTargetNumbers(CallSiteReference site) {
            Object t = this.targets.get(site.getProgramCounter());
            if (t != null && t instanceof CallSite) {
                CallSite p = (CallSite)((Object)t);
                DelegatingCGNode n = (DelegatingCGNode)p.getNode();
                CallSiteReference s = p.getSite();
                return n.getPossibleTargetNumbers(s);
            }
            return super.getPossibleTargetNumbers(site);
        }

        private boolean hasTarget(int y) {
            if (super.getAllTargetNumbers().contains(y)) {
                return true;
            }
            for (Object n : this.targets) {
                ExplicitCallGraph.ExplicitNode delegate;
                IntSet s;
                if (!(n instanceof CallSite) || (s = DelegatingExplicitCallGraph.this.getPossibleTargetNumbers(delegate = (ExplicitCallGraph.ExplicitNode)((CallSite)((Object)n)).getNode(), ((CallSite)((Object)n)).getSite())) == null || !s.contains(y)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getNumberOfTargets(CallSiteReference site) {
            Object result = this.targets.get(site.getProgramCounter());
            if (result != null && result instanceof CallSite) {
                CallSite p = (CallSite)((Object)result);
                CGNode n = p.getNode();
                CallSiteReference s = p.getSite();
                return DelegatingExplicitCallGraph.this.getNumberOfTargets(n, s);
            }
            return super.getNumberOfTargets(site);
        }

        public void delegate(CallSiteReference site, CGNode delegateNode, CallSiteReference delegateSite) {
            CallSite d = new CallSite(delegateSite, delegateNode);
            this.targets.set(site.getProgramCounter(), (Object)d);
            int y = this.getCallGraph().getNumber(this);
            int x = this.getCallGraph().getNumber(delegateNode);
            DelegatingExplicitCallGraph.this.delegateR.add(x, y);
        }
    }
}

