/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer;

import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.slicer.ExceptionalReturnCaller;
import com.ibm.wala.ipa.slicer.HeapStatement;
import com.ibm.wala.ipa.slicer.ISDG;
import com.ibm.wala.ipa.slicer.MethodEntryStatement;
import com.ibm.wala.ipa.slicer.MethodExitStatement;
import com.ibm.wala.ipa.slicer.NormalReturnCaller;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.PDG;
import com.ibm.wala.ipa.slicer.ParamCaller;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.intset.IntSet;
import java.util.Iterator;

class SDGSupergraph
implements ISupergraph<Statement, PDG> {
    private final ISDG sdg;
    private final boolean backward;

    public SDGSupergraph(ISDG sdg, boolean backward) {
        this.sdg = sdg;
        this.backward = backward;
    }

    @Override
    public Graph<PDG> getProcedureGraph() {
        Assertions.UNREACHABLE();
        return null;
    }

    public Object[] getEntry(Statement n) {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public byte classifyEdge(Statement src, Statement dest) {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public Iterator<? extends Statement> getCallSites(Statement r, PDG callee) {
        switch (r.getKind()) {
            case EXC_RET_CALLER: {
                ExceptionalReturnCaller n = (ExceptionalReturnCaller)r;
                SSAAbstractInvokeInstruction call = n.getInstruction();
                PDG pdg = this.getProcOf(r);
                return pdg.getCallStatements(call).iterator();
            }
            case NORMAL_RET_CALLER: {
                NormalReturnCaller n = (NormalReturnCaller)r;
                SSAAbstractInvokeInstruction call = n.getInstruction();
                PDG pdg = this.getProcOf(r);
                return pdg.getCallStatements(call).iterator();
            }
            case HEAP_RET_CALLER: {
                HeapStatement.HeapReturnCaller n = (HeapStatement.HeapReturnCaller)r;
                SSAAbstractInvokeInstruction call = n.getCall();
                PDG pdg = this.getProcOf(r);
                return pdg.getCallStatements(call).iterator();
            }
        }
        Assertions.UNREACHABLE((String)r.getKind().toString());
        return null;
    }

    @Override
    public Iterator<? extends Statement> getCalledNodes(Statement call) {
        switch (call.getKind()) {
            case NORMAL: {
                Predicate f = new Predicate(){

                    public boolean test(Object o) {
                        Statement s = (Statement)o;
                        return SDGSupergraph.this.isEntry(s);
                    }
                };
                return new FilterIterator(this.getSuccNodes(call), f);
            }
            case PARAM_CALLER: 
            case HEAP_PARAM_CALLER: {
                return this.getSuccNodes(call);
            }
        }
        Assertions.UNREACHABLE((String)call.getKind().toString());
        return null;
    }

    public Statement[] getEntriesForProcedure(PDG procedure) {
        Statement[] normal = procedure.getParamCalleeStatements();
        Statement[] result = new Statement[normal.length + 1];
        result[0] = new MethodEntryStatement(procedure.getCallGraphNode());
        System.arraycopy(normal, 0, result, 1, normal.length);
        return result;
    }

    public Statement[] getExitsForProcedure(PDG procedure) {
        Statement[] normal = procedure.getReturnStatements();
        Statement[] result = new Statement[normal.length + 1];
        result[0] = new MethodExitStatement(procedure.getCallGraphNode());
        System.arraycopy(normal, 0, result, 1, normal.length);
        return result;
    }

    @Override
    public Statement getLocalBlock(PDG procedure, int i) {
        return procedure.getNode(i);
    }

    @Override
    public int getLocalBlockNumber(Statement n) {
        PDG pdg = this.getProcOf(n);
        return pdg.getNumber(n);
    }

    @Override
    public Iterator<Statement> getNormalSuccessors(Statement call) {
        if (!this.backward) {
            return EmptyIterator.instance();
        }
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public int getNumberOfBlocks(PDG procedure) {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public PDG getProcOf(Statement n) {
        CGNode node = n.getNode();
        PDG result = this.sdg.getPDG(node);
        if (result == null) {
            Assertions.UNREACHABLE((String)("panic: " + n + " " + node));
        }
        return result;
    }

    @Override
    public Iterator<? extends Statement> getReturnSites(Statement call, PDG callee) {
        switch (call.getKind()) {
            case PARAM_CALLER: {
                ParamCaller n = (ParamCaller)call;
                SSAAbstractInvokeInstruction st = n.getInstruction();
                PDG pdg = this.getProcOf(call);
                return pdg.getCallerReturnStatements(st).iterator();
            }
            case HEAP_PARAM_CALLER: {
                HeapStatement.HeapParamCaller n = (HeapStatement.HeapParamCaller)call;
                SSAAbstractInvokeInstruction st = n.getCall();
                PDG pdg = this.getProcOf(call);
                return pdg.getCallerReturnStatements(st).iterator();
            }
            case NORMAL: {
                NormalStatement n = (NormalStatement)call;
                SSAAbstractInvokeInstruction st = (SSAAbstractInvokeInstruction)n.getInstruction();
                PDG pdg = this.getProcOf(call);
                return pdg.getCallerReturnStatements(st).iterator();
            }
        }
        Assertions.UNREACHABLE((String)call.getKind().toString());
        return null;
    }

    @Override
    public boolean isCall(Statement n) {
        switch (n.getKind()) {
            case EXC_RET_CALLER: 
            case NORMAL_RET_CALLER: 
            case HEAP_RET_CALLER: 
            case EXC_RET_CALLEE: 
            case HEAP_PARAM_CALLEE: 
            case NORMAL_RET_CALLEE: 
            case PARAM_CALLEE: 
            case PHI: 
            case HEAP_RET_CALLEE: 
            case METHOD_ENTRY: 
            case METHOD_EXIT: 
            case CATCH: 
            case PI: {
                return false;
            }
            case PARAM_CALLER: 
            case HEAP_PARAM_CALLER: {
                return true;
            }
            case NORMAL: {
                if (this.sdg.getCOptions().equals((Object)Slicer.ControlDependenceOptions.NONE)) {
                    return false;
                }
                NormalStatement s = (NormalStatement)n;
                return s.getInstruction() instanceof SSAAbstractInvokeInstruction;
            }
        }
        Assertions.UNREACHABLE((String)((Object)((Object)n.getKind()) + " " + n.toString()));
        return false;
    }

    @Override
    public boolean isEntry(Statement n) {
        switch (n.getKind()) {
            case HEAP_PARAM_CALLEE: 
            case PARAM_CALLEE: 
            case METHOD_ENTRY: {
                return true;
            }
            case EXC_RET_CALLER: 
            case NORMAL_RET_CALLER: 
            case HEAP_RET_CALLER: 
            case NORMAL: 
            case PARAM_CALLER: 
            case HEAP_PARAM_CALLER: 
            case EXC_RET_CALLEE: 
            case NORMAL_RET_CALLEE: 
            case PHI: 
            case HEAP_RET_CALLEE: 
            case CATCH: 
            case PI: {
                return false;
            }
        }
        Assertions.UNREACHABLE((String)n.toString());
        return false;
    }

    @Override
    public boolean isExit(Statement n) {
        switch (n.getKind()) {
            case EXC_RET_CALLER: 
            case NORMAL_RET_CALLER: 
            case HEAP_RET_CALLER: 
            case NORMAL: 
            case PARAM_CALLER: 
            case HEAP_PARAM_CALLER: 
            case HEAP_PARAM_CALLEE: 
            case PARAM_CALLEE: 
            case PHI: 
            case METHOD_ENTRY: 
            case CATCH: 
            case PI: {
                return false;
            }
            case EXC_RET_CALLEE: 
            case NORMAL_RET_CALLEE: 
            case HEAP_RET_CALLEE: 
            case METHOD_EXIT: {
                return true;
            }
        }
        Assertions.UNREACHABLE((String)n.toString());
        return false;
    }

    @Override
    public boolean isReturn(Statement n) {
        switch (n.getKind()) {
            case EXC_RET_CALLER: 
            case NORMAL_RET_CALLER: 
            case HEAP_RET_CALLER: {
                return true;
            }
            case NORMAL: 
            case PARAM_CALLER: 
            case HEAP_PARAM_CALLER: 
            case EXC_RET_CALLEE: 
            case HEAP_PARAM_CALLEE: 
            case NORMAL_RET_CALLEE: 
            case PARAM_CALLEE: 
            case PHI: 
            case HEAP_RET_CALLEE: 
            case METHOD_ENTRY: 
            case CATCH: 
            case PI: {
                return false;
            }
        }
        Assertions.UNREACHABLE((String)n.getKind().toString());
        return false;
    }

    public void removeNodeAndEdges(Statement N) {
        Assertions.UNREACHABLE();
    }

    public void addNode(Statement n) {
        Assertions.UNREACHABLE();
    }

    public boolean containsNode(Statement N) {
        return this.sdg.containsNode(N);
    }

    public int getNumberOfNodes() {
        Assertions.UNREACHABLE();
        return 0;
    }

    public Iterator<Statement> iterator() {
        return this.sdg.iterator();
    }

    public void removeNode(Statement n) {
        Assertions.UNREACHABLE();
    }

    public void addEdge(Statement src, Statement dst) {
        Assertions.UNREACHABLE();
    }

    public int getPredNodeCount(Statement N) {
        Assertions.UNREACHABLE();
        return 0;
    }

    public Iterator<Statement> getPredNodes(Statement N) {
        return this.sdg.getPredNodes(N);
    }

    public int getSuccNodeCount(Statement N) {
        Assertions.UNREACHABLE();
        return 0;
    }

    public Iterator<Statement> getSuccNodes(Statement N) {
        return this.sdg.getSuccNodes(N);
    }

    public boolean hasEdge(Statement src, Statement dst) {
        return this.sdg.hasEdge(src, dst);
    }

    public void removeAllIncidentEdges(Statement node) {
        Assertions.UNREACHABLE();
    }

    public void removeEdge(Statement src, Statement dst) {
        Assertions.UNREACHABLE();
    }

    public void removeIncomingEdges(Statement node) {
        Assertions.UNREACHABLE();
    }

    public void removeOutgoingEdges(Statement node) {
        Assertions.UNREACHABLE();
    }

    public int getMaxNumber() {
        return this.sdg.getMaxNumber();
    }

    public Statement getNode(int number) {
        return (Statement)this.sdg.getNode(number);
    }

    public int getNumber(Statement N) {
        return this.sdg.getNumber(N);
    }

    public Iterator<Statement> iterateNodes(IntSet s) {
        Assertions.UNREACHABLE();
        return null;
    }

    public IntSet getPredNodeNumbers(Statement node) {
        return this.sdg.getPredNodeNumbers(node);
    }

    public IntSet getSuccNodeNumbers(Statement node) {
        return this.sdg.getSuccNodeNumbers(node);
    }
}

