/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.slicer.thin;

import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.modref.DelegatingExtendedHeapModel;
import com.ibm.wala.ipa.modref.ModRef;
import com.ibm.wala.ipa.slicer.NormalStatement;
import com.ibm.wala.ipa.slicer.SDG;
import com.ibm.wala.ipa.slicer.Slicer;
import com.ibm.wala.ipa.slicer.Statement;
import com.ibm.wala.ipa.slicer.thin.CISDG;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CISlicer {
    private final Graph<Statement> depGraph;

    public CISlicer(CallGraph cg, PointerAnalysis<InstanceKey> pa, Slicer.DataDependenceOptions dOptions, Slicer.ControlDependenceOptions cOptions) {
        this(cg, pa, ModRef.make(), dOptions, cOptions);
    }

    public CISlicer(CallGraph cg, PointerAnalysis<InstanceKey> pa, ModRef modRef, Slicer.DataDependenceOptions dOptions, Slicer.ControlDependenceOptions cOptions) throws IllegalArgumentException {
        if (dOptions == null) {
            throw new IllegalArgumentException("dOptions == null");
        }
        if (dOptions.equals((Object)Slicer.DataDependenceOptions.NO_BASE_PTRS) || dOptions.equals((Object)Slicer.DataDependenceOptions.FULL)) {
            throw new IllegalArgumentException("Heap data dependences requested in CISlicer!");
        }
        SDG sdg = new SDG(cg, pa, modRef, dOptions, cOptions, null);
        Map<Statement, Set<PointerKey>> mod = CISlicer.scanForMod(sdg, pa, modRef);
        Map<Statement, Set<PointerKey>> ref = CISlicer.scanForRef(sdg, pa, modRef);
        this.depGraph = GraphInverter.invert((NumberedGraph)new CISDG(sdg, mod, ref));
    }

    public CISlicer(SDG sdg, PointerAnalysis<InstanceKey> pa, ModRef modRef) {
        Map<Statement, Set<PointerKey>> mod = CISlicer.scanForMod(sdg, pa, modRef);
        Map<Statement, Set<PointerKey>> ref = CISlicer.scanForRef(sdg, pa, modRef);
        this.depGraph = GraphInverter.invert((NumberedGraph)new CISDG(sdg, mod, ref));
    }

    public Collection<Statement> computeBackwardThinSlice(Statement seed) {
        Set slice = DFS.getReachableNodes(this.depGraph, Collections.singleton(seed));
        return slice;
    }

    public Collection<Statement> computeBackwardThinSlice(Collection<Statement> seeds) {
        Set slice = DFS.getReachableNodes(this.depGraph, seeds);
        return slice;
    }

    public static Map<Statement, Set<PointerKey>> scanForMod(SDG sdg, PointerAnalysis<InstanceKey> pa) {
        return CISlicer.scanForMod(sdg, pa, false, ModRef.make());
    }

    public static Map<Statement, Set<PointerKey>> scanForRef(SDG sdg, PointerAnalysis<InstanceKey> pa) {
        if (sdg == null) {
            throw new IllegalArgumentException("null sdg");
        }
        return CISlicer.scanForRef(sdg, pa, ModRef.make());
    }

    public static Map<Statement, Set<PointerKey>> scanForMod(SDG sdg, PointerAnalysis<InstanceKey> pa, ModRef modRef) {
        return CISlicer.scanForMod(sdg, pa, false, modRef);
    }

    public static Map<Statement, Set<PointerKey>> scanForMod(SDG sdg, PointerAnalysis<InstanceKey> pa, boolean ignoreAllocHeapDefs, ModRef modRef) {
        if (pa == null) {
            throw new IllegalArgumentException("null pa");
        }
        DelegatingExtendedHeapModel h = new DelegatingExtendedHeapModel(pa.getHeapModel());
        HashMap result = HashMapFactory.make();
        Iterator iterator = sdg.getCallGraph().iterator();
        while (iterator.hasNext()) {
            CGNode n = (CGNode)iterator.next();
            IR ir = n.getIR();
            if (ir == null) continue;
            for (int i = 0; i < ir.getInstructions().length; ++i) {
                Set<PointerKey> mod;
                SSAInstruction st = ir.getInstructions()[i];
                if (st == null || (mod = modRef.getMod(n, h, pa, st, null, ignoreAllocHeapDefs)).isEmpty()) continue;
                NormalStatement normal = new NormalStatement(n, i);
                result.put(normal, mod);
            }
        }
        return result;
    }

    public static Map<Statement, Set<PointerKey>> scanForRef(SDG sdg, PointerAnalysis<InstanceKey> pa, ModRef modRef) {
        if (pa == null) {
            throw new IllegalArgumentException("null pa");
        }
        DelegatingExtendedHeapModel h = new DelegatingExtendedHeapModel(pa.getHeapModel());
        HashMap result = HashMapFactory.make();
        Iterator iterator = sdg.getCallGraph().iterator();
        while (iterator.hasNext()) {
            CGNode n = (CGNode)iterator.next();
            IR ir = n.getIR();
            if (ir == null) continue;
            for (int i = 0; i < ir.getInstructions().length; ++i) {
                Set<PointerKey> mod;
                SSAInstruction st = ir.getInstructions()[i];
                if (st == null || (mod = modRef.getRef(n, h, pa, st, null)).isEmpty()) continue;
                NormalStatement normal = new NormalStatement(n, i);
                result.put(normal, mod);
            }
        }
        return result;
    }
}

