/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks;

import com.ibm.appscan.frameworks.FrameworkGeneratorHarness;
import com.ibm.appscan.frameworks.FrameworkInfoGenerator;
import com.ibm.appscan.frameworks.FrameworksInput;
import com.ibm.appscan.frameworks.aspdotnet.AspDotNetFrameworkInfoGenerator;
import com.ibm.appscan.frameworks.highlevelapi.processing.F4FActionProcessor;
import com.ibm.appscan.frameworks.highlevelapi.processing.F4FHandlerJarUtil;
import com.ibm.appscan.frameworks.java.JavaFrameworkInfoGenerator;
import com.ibm.appscan.frameworks.specinfo.IFrameworkInfo;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.cha.IClassHierarchyDweller;
import com.ibm.wala.util.io.CommandLine;
import java.util.Properties;

public class FrameworksCLI {
    public static final String INPUT_FILENAME_ARG = "input";

    public static void main(String[] args) {
        try {
            FrameworksCLI.runMain(args);
        }
        catch (Throwable e) {
            System.exit(1);
        }
    }

    public static void runMain(String[] args) throws Throwable {
        Properties parsedArgs = CommandLine.parse((String[])args);
        String inputFilename = parsedArgs.getProperty(INPUT_FILENAME_ARG);
        if (inputFilename == null) {
            throw new IllegalArgumentException("input argument not present");
        }
        try {
            FrameworksInput input = FrameworksInput.make((String)inputFilename);
            String type = input.getType();
            JavaFrameworkInfoGenerator generator = null;
            if (type.equals("Java")) {
                generator = new JavaFrameworkInfoGenerator();
            } else if (type.equals("DotNet")) {
                generator = new AspDotNetFrameworkInfoGenerator();
            }
            FrameworkGeneratorHarness.run((FrameworksInput)input, (FrameworkInfoGenerator)new HandlerJarsGenerator((FrameworkInfoGenerator)generator, input.getFileLocs().getHandlerJarDir()));
        }
        catch (Throwable t) {
            TaintLogger.i().getLogger().fatal((Object)"Exception - see log file for details", t);
            throw t;
        }
    }

    private static class HandlerJarsGenerator
    implements FrameworkInfoGenerator {
        private final FrameworkInfoGenerator delegateGenerator;
        private final String jarDir;

        public HandlerJarsGenerator(FrameworkInfoGenerator delegateGenerator, String jarDir) {
            this.delegateGenerator = delegateGenerator;
            this.jarDir = jarDir;
        }

        public IFrameworkInfo generateFrameworkInfo(FrameworksInput input) throws Exception {
            IFrameworkInfo result = this.delegateGenerator.generateFrameworkInfo(input);
            if (this.delegateGenerator instanceof IClassHierarchyDweller && this.jarDir != null) {
                IClassHierarchy cha = ((IClassHierarchyDweller)this.delegateGenerator).getClassHierarchy();
                try {
                    IFrameworkInfo handlerJarsInfo = F4FHandlerJarUtil.runAllHandlerJars((String)this.jarDir, (IClassHierarchy)cha, (FrameworksInput)input);
                    result = F4FActionProcessor.mergeFrameworkInfo((IFrameworkInfo[])new IFrameworkInfo[]{result, handlerJarsInfo});
                }
                catch (Exception e) {
                    TaintLogger.i().getLogger().warn((Object)"failure running framework handlers", (Throwable)e);
                }
            }
            return result;
        }
    }
}

