/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.filter;

import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.filter.FilterEnums;
import com.ibm.appscan.filter.FilterException;
import com.ibm.appscan.filter.processing.FilterReader;
import com.ibm.appscan.filter.processing.FilterWriter;
import com.ibm.appscan.filter.rules.Rule;
import com.ibm.appscan.filter.rules.TraceRule;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class Filter {
    private HashMap<FilterEnums.BEHAVIOR, HashMap<FilterEnums.RULE_TYPE, ArrayList<Rule>>> m_rules = new HashMap();
    private boolean m_exclude_matching_findings = true;
    private boolean m_global = false;
    private boolean m_global_exclusion = false;
    private String m_name = "";
    private String m_version = "0";
    private ArrayList<String> m_confidence;
    private ArrayList<String> m_severity;
    private TraceRule m_include_trace;
    private TraceRule m_exclude_trace;

    public Filter(File file) throws FilterException {
        FilterReader reader = new FilterReader(file);
        reader.load(this);
    }

    public Filter() {
    }

    public void save(File f) throws FilterException {
        FilterWriter w = new FilterWriter(f);
        w.saveFilter(this);
    }

    public boolean excludeMatchingFindings() {
        return this.m_exclude_matching_findings;
    }

    public void setExcludeMatchingFindings(boolean ex) {
        this.m_exclude_matching_findings = ex;
    }

    public boolean isGlobal() {
        return this.m_global;
    }

    public void setGlobal(boolean is_global) {
        this.m_global = is_global;
    }

    public boolean isGlobalExclusion() {
        return this.m_global_exclusion;
    }

    public void setGlobalExclusion(boolean is_global_exclusion) {
        this.m_global_exclusion = is_global_exclusion;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public ArrayList<Rule> getRules(FilterEnums.BEHAVIOR b, FilterEnums.RULE_TYPE rt) {
        if (!this.m_rules.containsKey((Object)b)) {
            return null;
        }
        if (!this.m_rules.get((Object)b).containsKey((Object)rt)) {
            return null;
        }
        return this.m_rules.get((Object)b).get((Object)rt);
    }

    public TraceRule getTraceRule(FilterEnums.BEHAVIOR b) {
        if (b == FilterEnums.BEHAVIOR.INCLUDE) {
            return this.m_include_trace;
        }
        return this.m_exclude_trace;
    }

    public void addRule(Rule r) {
        if (r.getRuleType() == FilterEnums.RULE_TYPE.TRACE) {
            if (r.getBehavior() == FilterEnums.BEHAVIOR.INCLUDE) {
                this.m_include_trace = (TraceRule)r;
            } else {
                this.m_exclude_trace = (TraceRule)r;
            }
        } else {
            if (!this.m_rules.containsKey((Object)r.getBehavior())) {
                this.m_rules.put(r.getBehavior(), new HashMap());
            }
            if (!this.m_rules.get((Object)r.getBehavior()).containsKey((Object)r.getRuleType())) {
                this.m_rules.get((Object)r.getBehavior()).put(r.getRuleType(), new ArrayList());
            }
            this.m_rules.get((Object)r.getBehavior()).get((Object)r.getRuleType()).add(r);
            if (r.getRuleType() == FilterEnums.RULE_TYPE.CONFIDENCE) {
                this.getIncludedConfidences().add(r.getValue());
            }
            if (r.getRuleType() == FilterEnums.RULE_TYPE.SEVERITY) {
                this.getIncludedSeverities().add(r.getValue());
            }
        }
    }

    public boolean isExcludeMatch(Finding f) {
        if (this.getIncludedConfidences().size() > 0 && !this.getIncludedConfidences().contains(f.getData().getConfidence())) {
            return true;
        }
        if (this.getIncludedSeverities().size() > 0 && !this.getIncludedSeverities().contains(f.getData().getSeverity())) {
            return true;
        }
        if (this.getTraceRule(FilterEnums.BEHAVIOR.INCLUDE) != null && this.getTraceRule(FilterEnums.BEHAVIOR.INCLUDE).getConditions().size() > 0 && f.getTrace() == null && this.m_rules.keySet().size() == 0) {
            return true;
        }
        return this.isMatch(FilterEnums.BEHAVIOR.EXCLUDE, f);
    }

    private ArrayList<String> getIncludedConfidences() {
        if (this.m_confidence == null) {
            this.m_confidence = new ArrayList();
        }
        return this.m_confidence;
    }

    private ArrayList<String> getIncludedSeverities() {
        if (this.m_severity == null) {
            this.m_severity = new ArrayList();
        }
        return this.m_severity;
    }

    public boolean isIncludeMatch(Finding f) {
        if (this.getTraceRule(FilterEnums.BEHAVIOR.EXCLUDE) != null && f.getTrace() == null && this.m_rules.keySet().size() == 0) {
            return true;
        }
        return this.isMatch(FilterEnums.BEHAVIOR.INCLUDE, f);
    }

    private boolean isMatch(FilterEnums.BEHAVIOR b, Finding f) {
        if (this.m_rules.keySet().size() == 0 && this.getTraceRule(b) == null) {
            return false;
        }
        if (this.getTraceRule(b) == null && (this.m_rules.get((Object)b) == null || this.m_rules.get((Object)b).keySet().size() == 0)) {
            return false;
        }
        if (this.m_rules.get((Object)b) != null) {
            for (FilterEnums.RULE_TYPE rt : this.m_rules.get((Object)b).keySet()) {
                boolean one_matches = false;
                for (Rule r : this.m_rules.get((Object)b).get((Object)rt)) {
                    if (!(b == FilterEnums.BEHAVIOR.EXCLUDE ? r.isExcludeMatch(f) : r.isIncludeMatch(f))) continue;
                    one_matches = true;
                    break;
                }
                if (one_matches) continue;
                return false;
            }
        }
        if (this.getTraceRule(b) != null && this.getTraceRule(b).getConditions().size() > 0) {
            return this.getTraceRule(b).isMatch(f);
        }
        return true;
    }
}

