/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.filter.processing;

import com.ibm.appscan.common.xml.DOMWriter;
import com.ibm.appscan.filter.Filter;
import com.ibm.appscan.filter.FilterEnums;
import com.ibm.appscan.filter.FilterException;
import com.ibm.appscan.filter.conditions.Condition;
import com.ibm.appscan.filter.rules.Rule;
import com.ibm.appscan.filter.rules.TraceRule;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

public class FilterWriter {
    private OutputStream m_stream;
    private Transformer m_transformer;
    private DocumentBuilder m_builder;
    private DOMWriter m_writer;

    public FilterWriter(File file) throws FilterException {
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            this.m_stream = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new FilterException(e);
        }
    }

    public FilterWriter(OutputStream stream) {
        this.m_stream = stream;
    }

    public void saveFilter(Filter f) throws FilterException {
        this.getWriter().beginElement("Filter");
        this.getWriter().setAttribute("exclude_matching_findings", Boolean.toString(f.excludeMatchingFindings()));
        this.getWriter().setAttribute("global", Boolean.toString(f.isGlobal()));
        this.getWriter().setAttribute("global_exclusion", Boolean.toString(f.isGlobalExclusion()));
        this.getWriter().setAttribute("name", f.getName());
        this.getWriter().setAttribute("version", f.getVersion());
        for (FilterEnums.RULE_TYPE rt : FilterEnums.RULE_TYPE.values()) {
            this.writeRule(FilterEnums.BEHAVIOR.EXCLUDE, rt, f);
            this.writeRule(FilterEnums.BEHAVIOR.INCLUDE, rt, f);
        }
        if (f.getTraceRule(FilterEnums.BEHAVIOR.INCLUDE) != null) {
            this.writeTraceRule(f.getTraceRule(FilterEnums.BEHAVIOR.INCLUDE));
        }
        if (f.getTraceRule(FilterEnums.BEHAVIOR.EXCLUDE) != null) {
            this.writeTraceRule(f.getTraceRule(FilterEnums.BEHAVIOR.EXCLUDE));
        }
        this.getWriter().endElement();
        try {
            this.getWriter().write(this.getTransformer());
        }
        catch (TransformerConfigurationException e) {
            throw new FilterException(e);
        }
        catch (TransformerException e) {
            throw new FilterException(e);
        }
    }

    private void writeRule(FilterEnums.BEHAVIOR b, FilterEnums.RULE_TYPE rt, Filter f) throws FilterException {
        if (f.getRules(b, rt) == null) {
            return;
        }
        if (f.getRules(b, rt).size() > 0) {
            this.getWriter().beginElement("Rule");
            this.getWriter().setAttribute("rule_behavior", Integer.toString(b.toInt()));
            this.getWriter().setAttribute("rule_type", Integer.toString(rt.toInt()));
            for (Rule r : f.getRules(b, rt)) {
                if (!r.getAttribute().equals("Condition")) continue;
                this.getWriter().beginElement(r.getAttribute());
                if (r.getRuleType() == FilterEnums.RULE_TYPE.CONFIDENCE) {
                    this.getWriter().endElement(Integer.toString(this.getConfidence(r.getValue())));
                    continue;
                }
                if (r.getRuleType() == FilterEnums.RULE_TYPE.SEVERITY) {
                    this.getWriter().endElement(Integer.toString(this.getSeverity(r.getValue())));
                    continue;
                }
                this.getWriter().endElement(r.getValue());
            }
            this.getWriter().endElement();
        }
    }

    private void writeTraceRule(TraceRule r) throws FilterException {
        this.getWriter().beginElement("Rule");
        this.getWriter().setAttribute("rule_behavior", Integer.toString(r.getBehavior().toInt()));
        this.getWriter().setAttribute("rule_type", Integer.toString(r.getRuleType().toInt()));
        this.getWriter().beginElement(FilterEnums.CONDITION_TYPE.TRACE.getAttribute());
        this.getWriter().setAttribute("condition_type", Integer.toString(FilterEnums.CONDITION_TYPE.TRACE.toInt()));
        this.getWriter().setAttribute("condition_match_type", "1");
        for (Condition c : r.getConditions()) {
            this.writeCondition(c);
        }
        this.getWriter().endElement();
        this.getWriter().endElement();
    }

    private void writeCondition(Condition c) throws FilterException {
        this.getWriter().beginElement(c.getConditionType().getAttribute());
        if (c.getConditionType() == FilterEnums.CONDITION_TYPE.PROPERTY) {
            this.getWriter().endElement(c.getValue());
        } else {
            this.getWriter().setAttribute("condition_type", Integer.toString(c.getConditionType().toInt()));
            this.getWriter().setAttribute("condition_match_type", Integer.toString(c.getMatchType().toInt()));
            if (c.getConditionType() == FilterEnums.CONDITION_TYPE.REGEX) {
                this.getWriter().setAttribute("regex", c.getValue());
                this.getWriter().setAttribute("regex_match_type", "2");
            }
            for (Condition child : c.getChildren()) {
                this.writeCondition(child);
            }
            this.getWriter().endElement();
        }
    }

    protected DOMWriter getWriter() throws FilterException {
        if (this.m_writer == null) {
            this.m_writer = new DOMWriter(this.m_stream, this.getBuilder());
        }
        return this.m_writer;
    }

    protected DocumentBuilder getBuilder() throws FilterException {
        try {
            this.m_builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new FilterException(e);
        }
        return this.m_builder;
    }

    protected Transformer getTransformer() throws TransformerConfigurationException {
        if (this.m_transformer == null) {
            TransformerFactory transform_factory = TransformerFactory.newInstance();
            this.m_transformer = transform_factory.newTransformer();
            this.m_transformer.setOutputProperty("indent", "yes");
            this.m_transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            this.m_transformer.setOutputProperty("standalone", "yes");
        }
        return this.m_transformer;
    }

    public int getConfidence(String confidence) {
        for (FilterEnums.CONFIDENCE_TYPE ct : FilterEnums.CONFIDENCE_TYPE.values()) {
            if (!ct.toString().equals(confidence)) continue;
            return ct.toInt();
        }
        return 0;
    }

    public int getSeverity(String sev) {
        for (FilterEnums.SEVERITY_TYPE st : FilterEnums.SEVERITY_TYPE.values()) {
            if (!st.toString().equals(sev)) continue;
            return st.toInt();
        }
        return 5;
    }
}

