/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.filter.rules;

import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.filter.FilterEnums;
import com.ibm.appscan.filter.conditions.Condition;
import com.ibm.appscan.filter.conditions.ProhibitedCallsFindingCondition;
import com.ibm.appscan.filter.conditions.RequiredCallsFindingCondition;
import com.ibm.appscan.filter.conditions.SinkFindingCondition;
import com.ibm.appscan.filter.conditions.SourceFindingCondition;
import com.ibm.appscan.filter.rules.Rule;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class TraceRule
extends Rule {
    private HashMap<FilterEnums.CONDITION_TYPE, ArrayList<Condition>> m_conditions = new HashMap();

    public TraceRule() {
        super(null);
    }

    public ArrayList<Condition> getConditions() {
        ArrayList<Condition> ret = new ArrayList<Condition>();
        for (FilterEnums.CONDITION_TYPE ct : this.m_conditions.keySet()) {
            for (Condition c : this.m_conditions.get((Object)ct)) {
                ret.add(c);
            }
        }
        return ret;
    }

    public void addCondition(Condition c) {
        if (this.m_conditions.get((Object)c.getConditionType()) == null) {
            this.m_conditions.put(c.getConditionType(), new ArrayList());
        }
        this.m_conditions.get((Object)c.getConditionType()).add(c);
    }

    public Condition addSinkCondition() {
        SinkFindingCondition c = new SinkFindingCondition(null, null);
        this.addCondition(c);
        return c;
    }

    public Condition addSourceCondition() {
        SourceFindingCondition c = new SourceFindingCondition(null, null);
        this.addCondition(c);
        return c;
    }

    public Condition addRequiredCallsFindingCondition() {
        RequiredCallsFindingCondition c = new RequiredCallsFindingCondition(null, null);
        this.addCondition(c);
        return c;
    }

    public Condition addProhibitedCallsFindingCondition() {
        ProhibitedCallsFindingCondition c = new ProhibitedCallsFindingCondition(null, null);
        this.addCondition(c);
        return c;
    }

    @Override
    public boolean isMatch(Finding f) {
        if (f.getTrace() == null) {
            return false;
        }
        if (this.m_conditions.keySet().size() == 0) {
            return false;
        }
        for (FilterEnums.CONDITION_TYPE ct : this.m_conditions.keySet()) {
            for (Condition c : this.m_conditions.get((Object)ct)) {
                if (c.getChildren().size() <= 0 || !(ct == FilterEnums.CONDITION_TYPE.PROHIBITED_CALL ? c.isMatch(f) : !c.isMatch(f))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public FilterEnums.RULE_TYPE getRuleType() {
        return FilterEnums.RULE_TYPE.TRACE;
    }
}

