/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.sa.prefix.constants;

import com.ibm.appscan.sa.prefix.constants.StringConstants;
import com.ibm.appscan.sa.prefix.main.ISPALangServices;
import com.ibm.appscan.sa.prefix.main.StringPrefix;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;

public class IntValue {
    public static Integer get(StringPrefix sp, BasicBlockInContext<IExplodedBasicBlock> bb, CallGraph cg, ISPALangServices langServices, int valueNumber) {
        CGNode caller = bb.getNode();
        IR ir = caller.getIR();
        SymbolTable sb = ir.getSymbolTable();
        Integer result = sp.getBodyPtrs().get(valueNumber);
        if (result != null) {
            return result;
        }
        if (sb.isNumberConstant(valueNumber)) {
            return sb.getIntValue(valueNumber);
        }
        DefUse du = new DefUse(ir);
        SSAInstruction instr = du.getDef(valueNumber);
        if (instr instanceof SSAGetInstruction) {
            SSAGetInstruction getFld = (SSAGetInstruction)instr;
            if (getFld.getDeclaredField().getName().toString().equals("length")) {
                String s = IntValue.tryGetStringConstant(bb, du, sb, getFld.getRef());
                if (s != null) {
                    return s.length();
                }
                if (IntValue.isReceiverLength(valueNumber, sp, du)) {
                    return -1;
                }
            }
        } else if (instr instanceof SSABinaryOpInstruction) {
            Integer i1 = IntValue.get(sp, bb, cg, langServices, instr.getUse(0));
            Integer i2 = IntValue.get(sp, bb, cg, langServices, instr.getUse(1));
            if (i1 != null && i2 != null && i1 != Integer.MAX_VALUE && i2 != Integer.MAX_VALUE) {
                return i1 + i2;
            }
        }
        return null;
    }

    private static boolean isReceiverLength(int valueNumber, StringPrefix sp, DefUse du) {
        SSAGetInstruction get = (SSAGetInstruction)du.getDef(valueNumber);
        int ref = get.getRef();
        if (sp.getEnvPtrs().contains(ref)) {
            return true;
        }
        SSAInstruction defInstr = du.getDef(ref);
        if (defInstr instanceof SSAPhiInstruction && defInstr.getNumberOfUses() == 2) {
            int use1 = defInstr.getUse(0);
            int use2 = defInstr.getUse(1);
            if (IntValue.isPrototypeFld(du, use1) && sp.getEnvPtrs().contains(use2) || IntValue.isPrototypeFld(du, use2) && sp.getEnvPtrs().contains(use1)) {
                return true;
            }
        }
        return false;
    }

    private static String tryGetStringConstant(BasicBlockInContext<IExplodedBasicBlock> bb, DefUse du, SymbolTable sb, int ref) {
        SSAPhiInstruction phi;
        if (StringConstants.isStringConstant(bb, ref)) {
            return StringConstants.getStringValue(bb, ref);
        }
        SSAInstruction defInstr = du.getDef(ref);
        if (defInstr instanceof SSAPhiInstruction && (phi = (SSAPhiInstruction)du.getDef(ref)).getNumberOfUses() == 2) {
            int use1 = phi.getUse(0);
            int use2 = phi.getUse(1);
            if (StringConstants.isStringConstant(bb, use1) && IntValue.isPrototypeFld(du, use2)) {
                return StringConstants.getStringValue(bb, use1);
            }
            if (StringConstants.isStringConstant(bb, use2) && IntValue.isPrototypeFld(du, use1)) {
                return StringConstants.getStringValue(bb, use2);
            }
        }
        return null;
    }

    private static boolean isPrototypeFld(DefUse du, int valueNumber) {
        SSAGetInstruction get;
        SSAInstruction def = du.getDef(valueNumber);
        return def instanceof SSAGetInstruction && (get = (SSAGetInstruction)def).getDeclaredField().getName().toString().toLowerCase().equals("prototype");
    }
}

