/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.sa.prefix.transducer;

import com.ibm.appscan.sa.prefix.constants.IntValue;
import com.ibm.appscan.sa.prefix.main.ISPALangServices;
import com.ibm.appscan.sa.prefix.main.StringPrefix;
import com.ibm.appscan.sa.prefix.transducer.StringTransducer;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collections;
import java.util.Set;

public abstract class AbstractSubstringTransducer
extends StringTransducer {
    @Override
    public Set<StringPrefix> transduce(StringPrefix sp, BasicBlockInContext<IExplodedBasicBlock> bb, CallGraph cg, SSAAbstractInvokeInstruction op, ISPALangServices langServices) {
        int startIdxValueNumber = this.getUse(op, 1);
        int endIdxValueNumber = this.getUse(op, 2);
        Integer strBeginLoc = this.getIntValue(sp, startIdxValueNumber, bb, cg, langServices);
        if (strBeginLoc == null) {
            return Collections.singleton(StringPrefix.unknown(op.getDef()));
        }
        if (endIdxValueNumber == -1) {
            return this.onlyStartIndex(sp, op, strBeginLoc);
        }
        Integer strEndLoc = this.getIntValue(sp, endIdxValueNumber, bb, cg, langServices);
        if (strEndLoc == null) {
            return Collections.singleton(StringPrefix.unknown(op.getDef()));
        }
        if (strEndLoc == -1) {
            return this.onlyStartIndex(sp, op, strBeginLoc);
        }
        return this.startAndEndIndices(sp, op, strBeginLoc, strEndLoc);
    }

    private Set<StringPrefix> startAndEndIndices(StringPrefix sp, SSAAbstractInvokeInstruction op, Integer strBeginLoc, Integer strEndLoc) {
        StringPrefix result;
        if (strBeginLoc != Integer.MAX_VALUE && strEndLoc != Integer.MAX_VALUE) {
            result = new StringPrefix(sp.getPrefix().substring(strBeginLoc, this.getEndIdx(strBeginLoc, strEndLoc)), Collections.singleton(op.getDef()), Collections.emptyMap(), false);
        } else if (strBeginLoc != Integer.MAX_VALUE && strEndLoc == Integer.MAX_VALUE) {
            assert (sp.hasSuffix());
            result = new StringPrefix(sp.getPrefix().substring(strBeginLoc), Collections.singleton(op.getDef()), Collections.emptyMap(), true);
        } else {
            if (strBeginLoc == Integer.MAX_VALUE && strEndLoc == Integer.MAX_VALUE) {
                assert (sp.hasSuffix());
                return Collections.singleton(StringPrefix.unknown(op.getDef()));
            }
            Assertions.UNREACHABLE();
            return null;
        }
        return Collections.singleton(result);
    }

    protected abstract int getEndIdx(int var1, int var2);

    private Set<StringPrefix> onlyStartIndex(StringPrefix sp, SSAAbstractInvokeInstruction op, Integer strBeginLoc) {
        if (strBeginLoc != Integer.MAX_VALUE && strBeginLoc <= sp.getPrefix().length()) {
            StringPrefix result = new StringPrefix(sp.getPrefix().substring(strBeginLoc), Collections.singleton(op.getDef()), Collections.emptyMap(), sp.hasSuffix());
            return Collections.singleton(result);
        }
        return Collections.singleton(StringPrefix.unknown(op.getDef()));
    }

    private Integer getIntValue(StringPrefix sp, int idxValueNumber, BasicBlockInContext<IExplodedBasicBlock> bb, CallGraph cg, ISPALangServices langServices) {
        Integer result = sp.getBodyPtrs().get(idxValueNumber);
        if (result == null) {
            result = IntValue.get(sp, bb, cg, langServices, idxValueNumber);
        }
        if (result != null && result > sp.getPrefix().length()) {
            result = Integer.MAX_VALUE;
        }
        return result;
    }
}

