/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.sa.prefix.transducer;

import com.ibm.appscan.sa.prefix.constants.StringConstants;
import com.ibm.appscan.sa.prefix.main.ISPALangServices;
import com.ibm.appscan.sa.prefix.main.StringPrefix;
import com.ibm.appscan.sa.prefix.transducer.StringTransducer;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SplitTransducer
extends StringTransducer {
    @Override
    public Set<StringPrefix> transduce(StringPrefix sp, BasicBlockInContext<IExplodedBasicBlock> bb, CallGraph cg, SSAAbstractInvokeInstruction op, ISPALangServices langServices) {
        int exprValueNumber = this.getUse(op, 1);
        int arrValueNumber = op.getDef();
        if (StringConstants.isStringConstant(bb, exprValueNumber)) {
            if (sp.hasSuffix()) {
                return Collections.singleton(StringPrefix.unknown(Collections.emptySet(), arrValueNumber));
            }
            String expr = StringConstants.getStringValue(bb, exprValueNumber);
            String[] splitArr = sp.getPrefix().split(expr);
            HashSet result = HashSetFactory.make((int)splitArr.length);
            for (String splitStr : splitArr) {
                result.add(new StringPrefix(splitStr, Collections.emptySet(), Collections.singleton(arrValueNumber), Collections.emptyMap(), false));
            }
            return result;
        }
        return Collections.singleton(StringPrefix.unknown(Collections.emptySet(), arrValueNumber));
    }
}

