/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.jaxwshandler.utils;

import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.HighLevelSyntheticMethod;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Local;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Param;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.FieldImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.types.generics.ClassTypeSignature;
import com.ibm.wala.types.generics.MethodTypeSignature;
import com.ibm.wala.types.generics.TypeArgument;
import com.ibm.wala.types.generics.TypeSignature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class JAXWSUtils {
    public static final String WEB_SERVICE_ANNOTATION_QN = "Ljavax/jws/WebService";
    public static final String XML_TYPE_ANNOTATION_QN = "Ljavax/xml/bind/annotation/XmlType";
    public static final String WEB_SERVICE_PROVIDER_ANNOTATION_QN = "Ljavax/xml/ws/WebServiceProvider";
    public static final String WEB_METHOD_ANNOTATION_QN = "Ljavax/jws/WebMethod";
    public static final String WEB_PARAM_ANNOTATION_QN = "Ljavax/jws/WebParam";
    public static final String WEB_PARAM_MODE = "mode";
    public static final String WEB_PARAM_MODE_OUT = "out";
    public static final String WEB_PARAM_MODE_IN_OUT = "inout";
    public static final String WEB_PARAM_MODE_IN = "in";
    public static final String WEB_SERVICE_PROVIDER_INVOKE = "invoke";
    public static final String JAX_WS_WEB_SERVICE_QN = "javax.jws.WebService";
    public static final String JAX_WS_HOLDER_QN = "javax.xml.ws.Holder";
    static final Logger logger = TaintLogger.i().getLogger();

    public static ArrayList<IMethod> findCandidateWebMethods(IClass clazz, F4FApp app) {
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        Collection interfaceMethods = clazz.getDeclaredMethods();
        for (IMethod method : interfaceMethods) {
            if (method.getSignature().endsWith(".<init>()V")) {
                logger.debug((Object)Messages.getString((String)"framework.ignored.method", (Object[])new Object[]{method.getSignature()}));
                continue;
            }
            boolean excludedWebMethod = JAXWSUtils.isWebMethodExcluded(method, app);
            if (!method.isPublic() || method.isStatic() || method.isFinal() || excludedWebMethod) continue;
            logger.info((Object)Messages.getString((String)"framework.method.found", (Object[])new Object[]{method.getSignature()}));
            methods.add(method);
        }
        return methods;
    }

    public static boolean isWebMethodExcluded(IMethod method, F4FApp app) {
        Annotation webMethodAnnotation = JAXWSUtils.getAnnotation(app, method, WEB_METHOD_ANNOTATION_QN);
        if (webMethodAnnotation == null) {
            return false;
        }
        Map namedArgs = webMethodAnnotation.getNamedArguments();
        if (namedArgs != null && namedArgs.containsKey("exclude")) {
            return ((AnnotationsReader.ElementValue)namedArgs.get("exclude")).toString().equals("1");
        }
        return false;
    }

    public static Boolean hasSameSignature(IMethod method1, IMethod method2) {
        if (method1.getNumberOfParameters() == method2.getNumberOfParameters() && method1.getName().toString().equals(method2.getName().toString())) {
            for (int i = 1; i < method1.getNumberOfParameters(); ++i) {
                if (method1.getParameterType(i).getName().equals((Object)method2.getParameterType(i).getName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Boolean hasAnnotation(F4FApp app, Object element, String annotationQN) {
        Collection elementAnnotations = null;
        if (element instanceof IClass) {
            elementAnnotations = app.getClassAnnotations((IClass)element);
        } else if (element instanceof IMethod) {
            elementAnnotations = app.getMethodAnnotations((IMethod)element);
        } else if (element instanceof IField) {
            elementAnnotations = app.getFieldAnnotations((IField)element);
        }
        if (elementAnnotations != null) {
            for (Annotation annotation : elementAnnotations) {
                if (!annotation.getType().getName().toString().equals(annotationQN)) continue;
                return true;
            }
        }
        return false;
    }

    public static Annotation getAnnotation(F4FApp app, Object element, String annotationQN) {
        Collection elementAnnotations = null;
        if (element instanceof IClass) {
            elementAnnotations = app.getClassAnnotations((IClass)element);
        } else if (element instanceof IMethod) {
            elementAnnotations = app.getMethodAnnotations((IMethod)element);
        }
        if (elementAnnotations != null) {
            for (Annotation annotation : elementAnnotations) {
                if (!annotation.getType().getName().toString().equals(annotationQN)) continue;
                return annotation;
            }
        }
        return null;
    }

    public static IField getFieldByName(F4FApp app, String clazzQN, String fieldName) {
        IClass clazz = app.getIClass(clazzQN);
        for (IField field : clazz.getAllInstanceFields()) {
            if (!field.getName().toString().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static void serializeObject(F4FApp app, HighLevelSyntheticMethod synthMethod, IClass returnIClass, Local objInstance, Local printWriterObj, Set<IClass> serializedClasses) {
        ClassType classType = JAXWSUtils.getClassType(returnIClass);
        if (classType == ClassType.APPLICATION_TYPE) {
            if (serializedClasses.contains(returnIClass)) {
                return;
            }
            serializedClasses.add(returnIClass);
            if (returnIClass.isArrayClass()) {
                return;
            }
            for (IField field : returnIClass.getAllFields()) {
                IClass genClass;
                String genType;
                Local fieldValue;
                TypeReference fieldType = field.getFieldTypeReference();
                if (fieldType == null) continue;
                IClass fieldClass = returnIClass.getClassHierarchy().lookupClass(fieldType);
                if (fieldClass == null) {
                    logger.info((Object)Messages.getString((String)"framework.generate.local", (Object[])new Object[]{"java.lang.Object"}));
                    fieldValue = synthMethod.newLocal("java.lang.Object");
                } else {
                    logger.info((Object)Messages.getString((String)"framework.generate.local", (Object[])new Object[]{fieldClass.getName().toString()}));
                    fieldValue = synthMethod.newLocal(fieldClass);
                }
                synthMethod.addInstanceVariableRead((Param)objInstance, field, (Param)fieldValue, null);
                if (JAXWSUtils.doesExtendClass(fieldClass, "Ljava/lang/Enum").booleanValue()) {
                    logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"java.io.PrintWriter.print(java.lang.Object):void"}));
                    synthMethod.addCall("java.io.PrintWriter.print(java.lang.Object):void", null, new Param[]{printWriterObj, objInstance});
                    return;
                }
                if (JAXWSUtils.findInterface(fieldClass, "Ljava/util/Collection") != null && (genType = JAXWSUtils.findGenericType(field)) != null && (genClass = app.getIClass(genType)) != null && genClass.getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) {
                    logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"java.util.Collection.iterator():java.util.Iterator"}));
                    Local iteratorObj = synthMethod.addCall("java.util.Collection.iterator():java.util.Iterator", null, new Param[]{fieldValue});
                    logger.info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"java.util.Iterator.next():java.lang.Object"}));
                    fieldValue = synthMethod.addCallWithReturnType("java.util.Iterator.next():java.lang.Object", null, genType, new Param[]{iteratorObj});
                    fieldClass = genClass;
                }
                JAXWSUtils.serializeObject(app, synthMethod, fieldClass, fieldValue, printWriterObj, serializedClasses);
            }
        }
    }

    private static String findGenericType(IField field) {
        ClassTypeSignature cts;
        TypeSignature typeSig = JAXWSUtils.getFiledGenericType(field);
        if (typeSig instanceof ClassTypeSignature && (cts = (ClassTypeSignature)typeSig).getTypeArguments() != null && cts.getTypeArguments().length == 1) {
            TypeArgument firstType = cts.getTypeArguments()[0];
            String javaName = JAXWSUtils.convertToSimpleName(firstType.toString());
            return javaName;
        }
        return null;
    }

    private static TypeSignature getFiledGenericType(IField field) {
        if (field instanceof FieldImpl && field.getDeclaringClass() instanceof ShrikeClass) {
            return ((FieldImpl)field).getGenericSignature();
        }
        return null;
    }

    public static IClass findInterface(IClass clazz, String interfaceName) {
        if (clazz == null) {
            return null;
        }
        for (IClass interf : clazz.getAllImplementedInterfaces()) {
            if (!interf.getName().toString().equals(interfaceName)) continue;
            return interf;
        }
        return null;
    }

    public static Boolean doesExtendClass(IClass clazz, String superClassName) {
        IClass superClass;
        if (clazz != null && (superClass = clazz.getSuperclass()) != null) {
            if (superClass.getName().toString().equals(superClassName)) {
                return true;
            }
            return JAXWSUtils.doesExtendClass(superClass, superClassName);
        }
        return false;
    }

    public static String findGenericType(IMethod method) {
        if (method instanceof ShrikeCTMethod) {
            try {
                ClassTypeSignature cts;
                TypeSignature rts;
                MethodTypeSignature methodSignature = ((ShrikeCTMethod)method).getMethodTypeSignature();
                if (methodSignature != null && methodSignature.getReturnType() != null && (rts = methodSignature.getReturnType()) instanceof ClassTypeSignature && (cts = (ClassTypeSignature)rts).getTypeArguments() != null && cts.getTypeArguments().length == 1) {
                    TypeArgument firstType = cts.getTypeArguments()[0];
                    String javaName = JAXWSUtils.convertToSimpleName(firstType.toString());
                    return javaName;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getHolderType(IMethod webMethod, int paramIndex) {
        if (webMethod instanceof ShrikeCTMethod) {
            try {
                ClassTypeSignature cts;
                TypeSignature rts;
                MethodTypeSignature methodSignature = ((ShrikeCTMethod)webMethod).getMethodTypeSignature();
                if (methodSignature.getArguments() != null && methodSignature.getArguments().length >= paramIndex && paramIndex != 0 && (rts = methodSignature.getArguments()[paramIndex - 1]) instanceof ClassTypeSignature && (cts = (ClassTypeSignature)rts).getTypeArguments() != null && cts.getTypeArguments().length == 1) {
                    TypeArgument firstType = cts.getTypeArguments()[0];
                    String javaName = JAXWSUtils.convertToSimpleName(firstType.toString());
                    return javaName;
                }
            }
            catch (Exception e) {
                logger.error((Object)("JAX-WS: failed to retrieve type info for Holder param in method " + webMethod.getSignature()), (Throwable)e);
            }
        }
        return null;
    }

    public static String convertToSimpleName(String className) {
        String javaClassName = className.replaceAll("\\/", ".");
        javaClassName = javaClassName.replaceAll("\\[", "");
        if ((javaClassName = javaClassName.split("<")[0]).length() > 1) {
            javaClassName = javaClassName.substring(1);
        }
        javaClassName = javaClassName.replaceAll(";", "");
        return javaClassName;
    }

    private static ClassType getClassType(IClass clazz) {
        if (clazz == null) {
            return ClassType.OTHERS;
        }
        if (JAXWSUtils.findInterface(clazz, "Ljava/util/Collection") != null) {
            return ClassType.COLLECTION_TYPE;
        }
        if (clazz.getClassLoader().getReference().equals((Object)ClassLoaderReference.Application)) {
            return ClassType.APPLICATION_TYPE;
        }
        return ClassType.OTHERS;
    }

    public static WebParamDirection getWebPramDirection(Collection<Annotation> paramAnnotationColl) {
        if (paramAnnotationColl == null || paramAnnotationColl.size() == 0) {
            return WebParamDirection.NONE;
        }
        for (Annotation paramAnnotation : paramAnnotationColl) {
            Map namedArgs;
            if (paramAnnotation == null || !paramAnnotation.getType().getName().toString().equals(WEB_PARAM_ANNOTATION_QN) || (namedArgs = paramAnnotation.getNamedArguments()) == null || !namedArgs.containsKey(WEB_PARAM_MODE) || !(namedArgs.get(WEB_PARAM_MODE) instanceof AnnotationsReader.EnumElementValue)) continue;
            AnnotationsReader.EnumElementValue modeAttrValue = (AnnotationsReader.EnumElementValue)namedArgs.get(WEB_PARAM_MODE);
            if (modeAttrValue.enumVal.equalsIgnoreCase(WEB_PARAM_MODE_OUT)) {
                return WebParamDirection.OUT;
            }
            if (modeAttrValue.enumVal.equalsIgnoreCase(WEB_PARAM_MODE_IN)) {
                return WebParamDirection.IN;
            }
            if (!modeAttrValue.enumVal.equalsIgnoreCase(WEB_PARAM_MODE_IN_OUT)) continue;
            return WebParamDirection.IN_OUT;
        }
        return WebParamDirection.NONE;
    }

    public static enum WebParamDirection {
        IN,
        IN_OUT,
        OUT,
        NONE;

    }

    private static enum ClassType {
        COLLECTION_TYPE,
        APPLICATION_TYPE,
        OTHERS;

    }
}

