/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.annotation;

import java.util.List;
import java.util.TreeMap;

public class VdbAnnotation {
    private String m_name;
    private TreeMap<String, String> m_args;

    public VdbAnnotation(String name, List<String> args) {
        this.m_name = name;
        this.m_args = new TreeMap();
        int i = 0;
        for (String arg : args) {
            this.m_args.put("key" + i, arg);
            ++i;
        }
    }

    public VdbAnnotation(String name, TreeMap<String, String> namedArgs, List<String> unnamedArgs) {
        this.m_name = name;
        this.m_args = namedArgs;
        int i = 0;
        for (String arg : unnamedArgs) {
            while (this.m_args.containsKey("key" + i)) {
                ++i;
            }
            this.m_args.put("key" + i, arg);
            ++i;
        }
    }

    public VdbAnnotation(String name, TreeMap<String, String> args) {
        this.m_name = name;
        this.m_args = args;
    }

    public VdbAnnotation(String name) {
        this.m_name = name;
        this.m_args = new TreeMap();
    }

    public String getName() {
        return this.m_name;
    }

    public TreeMap<String, String> getArgs() {
        return this.m_args;
    }

    public void addAnnotationMember(String val) {
        int i = 0;
        String createdKey = "value0";
        while (this.m_args.keySet().contains(createdKey)) {
            createdKey = "value" + ++i;
        }
        this.m_args.put(createdKey, val);
    }

    public void addAnnotationMember(String key, String val) {
        this.m_args.put(key, val);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.m_name);
        str.append(",");
        if (!this.m_args.isEmpty()) {
            for (String value : this.m_args.keySet()) {
                str.append(value + "-" + this.m_args.get(value));
                str.append(",");
            }
        }
        str.deleteCharAt(str.length() - 1);
        return str.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof VdbAnnotation)) {
            return false;
        }
        if (!this.getName().equals(((VdbAnnotation)other).getName())) {
            return false;
        }
        return this.getArgs().equals(((VdbAnnotation)other).getArgs());
    }

    public int hashCode() {
        return this.m_name.hashCode() + this.m_args.hashCode() * 12;
    }
}

