/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.cache;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.data.VdbPackage;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.provider.method.MethodProvider;
import java.io.File;
import java.util.HashMap;
import java.util.Set;

public class BaseVdbCache {
    private HashMap<String, Vdb> m_vdb = new HashMap();
    private HashMap<String, Long> m_vdb_time = new HashMap();
    private HashMap<String, Vdb> m_class_vdb = new HashMap();
    private HashMap<String, Long> m_class_vdb_time = new HashMap();
    private MethodProvider m_method_provider;
    private Vdb m_ncf;
    private int max_size = 50;
    private int max_class_size = 1000;
    private Language.LANGUAGE m_lang;
    private VDBEnums.BUCKET m_bucket;

    public BaseVdbCache(Language.LANGUAGE lang, VDBEnums.BUCKET b) {
        this.m_lang = lang;
        this.m_bucket = b;
    }

    protected Language.LANGUAGE getLanguage() {
        return this.m_lang;
    }

    protected MethodProvider initializeMethodProvider() {
        return new MethodProvider(this.getLanguage(), this.m_bucket);
    }

    public MethodProvider getMethodProvider() {
        if (this.m_method_provider == null) {
            this.m_method_provider = this.initializeMethodProvider();
        }
        return this.m_method_provider;
    }

    public Vdb getVdb(String package_name) throws VDBGeneralException {
        if (!this.m_vdb.containsKey(package_name)) {
            try {
                Vdb v = this.getMethodProvider().getVdb(package_name);
                if (v != null) {
                    this.m_vdb.put(package_name, v);
                    this.m_vdb_time.put(package_name, System.currentTimeMillis());
                }
            }
            catch (VDBGeneralException e) {
                throw new VDBGeneralException(e);
            }
        }
        if (this.m_vdb_time.containsKey(package_name)) {
            this.m_vdb_time.put(package_name, System.currentTimeMillis());
        }
        this.pruneCache();
        if (this.m_vdb.get(package_name) != null) {
            return this.m_vdb.get(package_name);
        }
        return this.getClassVdb(package_name);
    }

    public Vdb getClassVdb(String class_name) throws VDBGeneralException {
        if (!this.m_class_vdb.containsKey(class_name)) {
            try {
                Vdb v = this.getMethodProvider().getVdb(class_name);
                if (v != null) {
                    this.m_class_vdb.put(class_name, v);
                    this.m_class_vdb_time.put(class_name, System.currentTimeMillis());
                }
            }
            catch (VDBGeneralException e) {
                throw new VDBGeneralException(e);
            }
        }
        if (this.m_class_vdb.containsKey(class_name)) {
            this.m_class_vdb_time.put(class_name, System.currentTimeMillis());
        }
        this.pruneCache();
        return this.m_class_vdb.get(class_name);
    }

    private void pruneCache() {
        String pack_name_to_prune = "";
        String class_name_to_prune = "";
        long current_oldest = Long.MAX_VALUE;
        if (this.m_vdb.keySet().size() > this.max_size) {
            for (String package_name : this.m_vdb_time.keySet()) {
                if (this.m_vdb_time.get(package_name) <= current_oldest) continue;
                pack_name_to_prune = package_name;
                current_oldest = this.m_vdb_time.get(package_name);
            }
            this.pruneCache(pack_name_to_prune);
        }
        if (this.m_class_vdb.keySet().size() > this.max_class_size) {
            for (String class_name : this.m_class_vdb_time.keySet()) {
                if (this.m_class_vdb_time.get(class_name) <= current_oldest) continue;
                class_name_to_prune = class_name;
                current_oldest = this.m_class_vdb_time.get(class_name);
            }
            this.pruneClassCache(class_name_to_prune);
        }
    }

    public void pruneCache(String package_name) {
        this.m_vdb.remove(package_name);
        this.m_vdb_time.remove(package_name);
    }

    public void pruneClassCache(String class_name) {
        this.m_class_vdb.remove(class_name);
        this.m_class_vdb_time.remove(class_name);
    }

    public void clearLists() {
        this.m_ncf = null;
        this.m_vdb.clear();
        this.m_vdb_time.clear();
        this.m_class_vdb.clear();
        this.m_class_vdb_time.clear();
    }

    public synchronized String getPackages() throws VDBException {
        StringBuffer packages = new StringBuffer(10000);
        for (String pack : this.getPackageList()) {
            packages.append(pack);
            packages.append("#");
        }
        if (packages.length() > 0) {
            packages.deleteCharAt(packages.length() - 1);
        }
        return packages.toString();
    }

    public Set<String> getPackageList() throws VDBException {
        return this.getMethodProvider().getPackages();
    }

    public String getClassesForPackage(String package_name) throws VDBException {
        StringBuffer classes = new StringBuffer(10000);
        for (String c : this.getMethodProvider().getClassesForPackage(package_name)) {
            classes.append(c);
            classes.append("#");
        }
        if (classes.length() > 0) {
            classes.deleteCharAt(classes.length() - 1);
        }
        return classes.toString();
    }

    public Set<String> getClasses() throws VDBException {
        return this.getMethodProvider().getClasses();
    }

    public Set<String> getMethods() throws VDBException {
        return this.getMethodProvider().getMethods();
    }

    public Set<String> getNonClassFunctionsList() throws VDBException {
        return this.getMethodProvider().getNonClassFunctions();
    }

    public String getMethodsForClass(String package_name, String class_name) throws VDBException {
        StringBuffer methods = new StringBuffer(10000);
        for (String c : this.getMethodProvider().getMethodsForClass(package_name, class_name)) {
            methods.append(c);
            methods.append("#");
        }
        if (methods.length() > 0) {
            methods.deleteCharAt(methods.length() - 1);
        }
        return methods.toString();
    }

    public String getNonClassFunctions() throws VDBException {
        StringBuffer methods = new StringBuffer(10000);
        for (String c : this.getMethodProvider().getNonClassFunctions()) {
            methods.append(c);
            methods.append("#");
        }
        if (methods.length() > 0) {
            methods.deleteCharAt(methods.length() - 1);
        }
        return methods.toString();
    }

    public Vdb getNonClassFuncsVdb() throws VDBGeneralException {
        if (this.m_ncf == null) {
            this.m_ncf = this.getMethodProvider().getNonClassFuncsVdb();
        }
        return this.m_ncf;
    }

    public int addVdb(Vdb v) throws VDBGeneralException {
        return this.saveVdb(v);
    }

    public int addNonAuditVdb(Vdb v) throws VDBGeneralException {
        return this.saveVdb(v);
    }

    public Vdb getVdbFromSignatureLog(File f) throws VDBGeneralException {
        return this.getMethodProvider().getVdbFromSignatureLog(f);
    }

    public int saveVdb(Vdb v) throws VDBGeneralException {
        int count = 0;
        this.getMethodProvider().saveVdb(v);
        this.clearLists();
        this.pruneCache();
        return count;
    }

    public boolean deleteMethod(Method m) throws VDBGeneralException {
        if (m.isNcf()) {
            return this.getNonClassFuncsVdb().deleteMethod(m);
        }
        boolean ret = false;
        Vdb v = null;
        String id = null;
        if (m.getPackageName() != null && m.getPackageName().length() > 0) {
            v = this.getVdb(m.getPackageName());
            id = m.getPackageName();
        } else if (m.getClassName() != null && m.getClassName().length() > 0) {
            v = this.getClassVdb(m.getClassName());
            id = m.getClassName();
        }
        if (v == null) {
            return false;
        }
        if (v.deleteMethod(m)) {
            ret = true;
        }
        if (this.getVdb(m.getPackageName()).getMethods().size() == 0) {
            VdbProvider.getDataProvider(this.getLanguage()).deletePackage(this.getMethodProvider().getBucket(), id);
        }
        return ret;
    }

    public void deletePackageFile(VdbPackage p) throws VDBGeneralException {
        this.getMethodProvider().deletePackage(p);
    }

    public void deleteNonClassFuncFile() throws VDBGeneralException {
        this.getMethodProvider().deleteNcf();
    }

    public String getVdbXml(Vdb v) throws VDBGeneralException {
        return this.getMethodProvider().getVdbXml(v);
    }

    public Vdb getVdbFromVdb(Vdb v) throws VDBGeneralException {
        try {
            return this.getMethodProvider().getVdbFromVdb(v);
        }
        catch (BadMarkupException e) {
            throw new VDBGeneralException(e);
        }
    }

    public HashMap<String, Vdb> getVdbs() throws VDBException {
        return this.getMethodProvider().getVdbs(this.m_bucket);
    }
}

