/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.cache;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.cache.BaseVdbCache;
import com.ibm.appscan.vdb.cache.CacheProvider;
import com.ibm.appscan.vdb.cache.DoubleCheckCache;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.data.VdbClass;
import com.ibm.appscan.vdb.data.VdbPackage;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.method.MethodProvider;

public class VdbMissingCache
extends DoubleCheckCache {
    public VdbMissingCache(Language.LANGUAGE lang, VDBEnums.BUCKET b) {
        super(lang, b);
    }

    @Override
    protected MethodProvider initializeMethodProvider() {
        return new MethodProvider(this.getLanguage(), VDBEnums.BUCKET.MISSING);
    }

    @Override
    public int addVdb(Vdb v) throws VDBGeneralException {
        return super.addVdb(this.getFilteredVdb(v));
    }

    private Vdb getFilteredVdb(Vdb v) throws VDBGeneralException {
        boolean add_method;
        Vdb final_vdb = new Vdb(v.getLang());
        for (VdbPackage p : v.getPackageMap().values()) {
            Vdb ignore = CacheProvider.getCache(v.getLang(), VDBEnums.BUCKET.IGNORE).getVdb(p.getPackageName());
            Vdb new_vdb = CacheProvider.getCache(v.getLang(), VDBEnums.BUCKET.NEW).getVdb(p.getPackageName());
            add_method = true;
            for (VdbClass c : p.getClassMap().values()) {
                for (Method m : c.getMethods()) {
                    add_method = true;
                    if (ignore != null && ignore.getMethod(m.getSignature()) != null) {
                        add_method = false;
                    }
                    if (add_method && new_vdb != null && new_vdb.getMethod(m.getSignature()) != null) {
                        add_method = false;
                    }
                    if (!add_method) continue;
                    try {
                        final_vdb.addMethod(m);
                    }
                    catch (BadMarkupException e) {
                        throw new VDBGeneralException(e);
                    }
                }
            }
        }
        if (v.getNonClassFunctions().size() > 0) {
            Vdb ignore_ncf = CacheProvider.getCache(v.getLang(), VDBEnums.BUCKET.IGNORE).getNonClassFuncsVdb();
            Vdb new_ncf = CacheProvider.getCache(v.getLang(), VDBEnums.BUCKET.NEW).getNonClassFuncsVdb();
            for (Method m : v.getNonClassFunctions().values()) {
                add_method = true;
                if (ignore_ncf != null && ignore_ncf.getMethod(m.getSignature()) != null) {
                    add_method = false;
                }
                if (add_method && new_ncf != null && new_ncf.getMethod(m.getSignature()) != null) {
                    add_method = false;
                }
                if (!add_method) continue;
                try {
                    final_vdb.addMethod(m);
                }
                catch (BadMarkupException e) {
                    throw new VDBGeneralException(e);
                }
            }
        }
        return final_vdb;
    }

    @Override
    protected BaseVdbCache getFirstVdbCache() {
        return null;
    }

    @Override
    protected BaseVdbCache getSecondVdbCache() {
        return null;
    }
}

