/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.data;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.VdbArtifact;
import com.ibm.appscan.vdb.data.VdbClass;
import com.ibm.appscan.vdb.data.VdbPackage;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.provider.method.MethodProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import java.util.TreeSet;

public class Vdb
extends VdbArtifact
implements Comparable<Vdb> {
    private TreeMap<String, VdbPackage> m_packages;
    private TreeMap<String, VdbClass> m_classes;
    private TreeMap<String, Method> m_non_class_funcs;
    private ArrayList<Method> m_all_methods;

    public Vdb(Language.LANGUAGE lang) {
        this.setLang(lang);
    }

    public Vdb(Vdb v) throws BadMarkupException {
        this.setLang(v.getLang());
        this.merge(v);
    }

    public boolean hasMarkedUpMethods() {
        for (Method m : this.getMethods()) {
            if (!m.isMarkedUp()) continue;
            return true;
        }
        return false;
    }

    public Collection<VdbPackage> getPackages() {
        return this.getPackageMap().values();
    }

    public TreeMap<String, VdbPackage> getPackageMap() {
        if (this.m_packages == null) {
            this.m_packages = new TreeMap();
        }
        return this.m_packages;
    }

    public VdbPackage getPackage(String name) {
        return this.getPackageMap().get(name);
    }

    public boolean addPackage(VdbPackage pack) throws BadMarkupException {
        this.m_all_methods = null;
        return this.addPackage(pack, false);
    }

    public boolean addPackage(VdbPackage pack, boolean replace) throws BadMarkupException {
        this.m_all_methods = null;
        if (this.getLang() == null) {
            throw new BadMarkupException("Vdb language is null", pack.getPackageName());
        }
        if (pack.getLang() == null) {
            pack.setLang(this.getLang());
        }
        if (!this.getLang().equals((Object)pack.getLang())) {
            throw new BadMarkupException("Package language {0} and Vdb language {1} are not the same", pack.getLang(), this.getLang());
        }
        if (this.getPackageMap().containsKey(pack.getPackageName())) {
            if (replace) {
                this.getPackageMap().remove(pack.getPackageName());
                this.getPackageMap().put(pack.getPackageName(), pack);
                return true;
            }
            return this.getPackageMap().get(pack.getPackageName()).merge(pack);
        }
        this.getPackageMap().put(pack.getPackageName(), pack);
        return true;
    }

    public boolean deletePackage(String name) {
        this.m_all_methods = null;
        if (this.getPackageMap().containsKey(name)) {
            this.getPackageMap().remove(name);
            return true;
        }
        return false;
    }

    public ArrayList<VdbClass> getClassesVdb() {
        ArrayList<VdbClass> classes = new ArrayList<VdbClass>();
        for (VdbPackage p : this.getPackageMap().values()) {
            classes.addAll(p.getClassesVdb());
        }
        classes.addAll(this.getClassMap().values());
        return classes;
    }

    public VdbClass getClassVdb(String className) {
        if (this.getClassMap().containsKey(className)) {
            return this.getClassMap().get(className);
        }
        for (VdbPackage p : this.getPackageMap().values()) {
            if (p.getClassVdb(className) == null) continue;
            return p.getClassVdb(className);
        }
        return null;
    }

    public TreeSet<VdbClass> getClasses() {
        TreeSet<VdbClass> classes = new TreeSet<VdbClass>();
        classes.addAll(this.getClassMap().values());
        for (VdbPackage p : this.getPackageMap().values()) {
            classes.addAll(p.getClasses());
        }
        return classes;
    }

    public TreeMap<String, VdbClass> getClassMap() {
        if (this.m_classes == null) {
            this.m_classes = new TreeMap();
        }
        return this.m_classes;
    }

    public boolean addClassVdb(VdbClass c) throws BadMarkupException {
        this.m_all_methods = null;
        if (c.getPackageName() == null) {
            if (!this.getClassMap().containsKey(c.getClassName())) {
                this.getClassMap().put(c.getClassName(), c);
                return true;
            }
            return this.getClassMap().get(c.getClassName()).merge(c);
        }
        for (VdbPackage p : this.getPackageMap().values()) {
            if (!p.getPackageName().equals(c.getPackageName())) continue;
            return p.addClass(c);
        }
        VdbPackage p = new VdbPackage(c.getPackageName(), this.getLang());
        p.setFramework(c.getFramework());
        p.setLang(c.getLang());
        p.addClass(c);
        this.addPackage(p);
        return true;
    }

    public boolean deleteClass(String name) {
        this.m_all_methods = null;
        if (this.getClassMap().containsKey(name)) {
            this.getClassMap().remove(name);
            return true;
        }
        for (VdbPackage p : this.getPackageMap().values()) {
            if (p.getClassVdb(name) == null) continue;
            return p.deleteVdbClass(name);
        }
        return false;
    }

    public TreeMap<String, Method> getNonClassFunctions() {
        if (this.m_non_class_funcs == null) {
            this.m_non_class_funcs = new TreeMap();
        }
        return this.m_non_class_funcs;
    }

    public synchronized ArrayList<Method> getMethods() {
        if (this.m_all_methods == null) {
            this.m_all_methods = new ArrayList();
            for (VdbPackage p : this.getPackageMap().values()) {
                this.m_all_methods.addAll(p.getMethods());
            }
            for (VdbClass c : this.getClassMap().values()) {
                this.m_all_methods.addAll(c.getMethods());
            }
            this.m_all_methods.addAll(this.getNonClassFunctions().values());
        }
        return this.m_all_methods;
    }

    public Method getMethod(String signature) {
        if (this.getNonClassFunctions().containsKey(signature)) {
            return this.getNonClassFunctions().get(signature);
        }
        for (VdbPackage p : this.getPackageMap().values()) {
            if (p.getMethod(signature) == null) continue;
            return p.getMethod(signature);
        }
        for (VdbClass c : this.getClassMap().values()) {
            if (c.getMethod(signature) == null) continue;
            return c.getMethod(signature);
        }
        return null;
    }

    public boolean addMethod(Method m) throws BadMarkupException {
        if (m == null) {
            return false;
        }
        this.m_all_methods = null;
        if (this.getLang() == null) {
            throw new BadMarkupException("Vdb language is null", new Object[0]);
        }
        if (m.getLang() == null || this.getLang() == Language.LANGUAGE.UNKNOWN) {
            m.setLang(this.getLang());
        }
        if (!this.getLang().equals((Object)m.getLang())) {
            throw new BadMarkupException("Method language {0} and Vdb language {1} do not match", m.getLang(), this.getLang());
        }
        if (m.getPackageName() == null || m.getPackageName().length() == 0) {
            if (m.getClassName() != null && m.getClassName().length() > 0) {
                if (!this.getClassMap().containsKey(m.getClassName())) {
                    this.addClassVdb(new VdbClass(m.getClassName(), m.getLang()));
                }
                return this.getClassMap().get(m.getClassName()).addMethod(m);
            }
            if (!this.getNonClassFunctions().containsKey(m.getSignature())) {
                this.getNonClassFunctions().put(m.getSignature(), m);
                return true;
            }
        } else {
            if (this.getPackageMap().containsKey(m.getPackageName())) {
                return this.getPackageMap().get(m.getPackageName()).addMethod(m);
            }
            VdbPackage p = new VdbPackage(m.getPackageName(), this.getLang());
            p.addMethod(m);
            return this.addPackage(p);
        }
        return false;
    }

    public boolean deleteMethod(Method m) {
        this.m_all_methods = null;
        return this.deleteMethod(m.getSignature());
    }

    public boolean deleteMethod(String name) {
        this.m_all_methods = null;
        if (this.getNonClassFunctions().containsKey(name)) {
            this.getNonClassFunctions().remove(name);
            return true;
        }
        for (VdbPackage p : this.getPackageMap().values()) {
            if (!p.deleteMethod(name)) continue;
            return true;
        }
        for (VdbClass c : this.getClassMap().values()) {
            if (c.getMethod(name) == null) continue;
            return c.deleteMethod(name);
        }
        return false;
    }

    @Override
    public void reset() {
        this.m_packages = null;
        this.m_classes = null;
        this.m_non_class_funcs = null;
        this.m_all_methods = null;
    }

    @Override
    public void replace(VdbArtifact artifact) throws BadMarkupException {
        this.m_all_methods = null;
        if (artifact instanceof Vdb) {
            this.reset();
            this.setLang(artifact.getLang());
            this.merge(artifact);
        }
    }

    @Override
    public boolean merge(VdbArtifact artifact) throws BadMarkupException {
        this.m_all_methods = null;
        boolean _ret = false;
        if (artifact instanceof Vdb) {
            Vdb v = (Vdb)artifact;
            for (Method m : v.getMethods()) {
                try {
                    if (!this.addMethod(MethodProvider.getMethod(m))) continue;
                    _ret = true;
                }
                catch (VDBException e) {
                    throw new BadMarkupException(e.getLocalizedMessage(), new Object[0]);
                }
            }
        }
        return _ret;
    }

    @Override
    public int compareTo(Vdb v) {
        if (this.getLang().compareTo((Enum)v.getLang()) != 0) {
            return this.getLang().compareTo((Enum)v.getLang());
        }
        if (this.getPackageMap().size() > v.getPackageMap().size()) {
            return 1;
        }
        if (this.getPackageMap().size() < v.getPackageMap().size()) {
            return -1;
        }
        for (VdbPackage p : this.getPackageMap().values()) {
            if (v.getPackage(p.getPackageName()) == null) {
                return 1;
            }
            if (p.compareTo(v.getPackage(p.getPackageName())) == 0) continue;
            return p.compareTo(v.getPackage(p.getPackageName()));
        }
        for (VdbPackage p : v.getPackageMap().values()) {
            if (v.getPackage(p.getPackageName()) == null) {
                return -1;
            }
            if (p.compareTo(this.getPackage(p.getPackageName())) == 0) continue;
            return p.compareTo(this.getPackage(p.getPackageName()));
        }
        if (this.getClassMap().keySet().size() == 0 && v.getClassMap().keySet().size() > 0) {
            return -1;
        }
        if (this.getClassMap().keySet().size() > 0) {
            if (v.getClassMap().keySet().size() == 0) {
                return 1;
            }
            for (VdbClass c : this.getClassMap().values()) {
                if (v.getClassMap().get(c.getClassName()) != null) {
                    if (c.compareTo(v.getClassMap().get(c.getClassName())) == 0) continue;
                    return c.compareTo(v.getClassMap().get(c.getClassName()));
                }
                return 1;
            }
            for (VdbClass c : v.getClassMap().values()) {
                if (this.getClassMap().get(c.getClassName()) != null) {
                    if (c.compareTo(this.getClassMap().get(c.getClassName())) == 0) continue;
                    return c.compareTo(this.getClassMap().get(c.getClassName()));
                }
                return -1;
            }
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o instanceof Vdb) {
            Vdb v = (Vdb)o;
            return this.compareTo(v) == 0;
        }
        return false;
    }

    public String getVdbId() {
        if (this.getPackageMap().keySet().size() > 0) {
            return this.getPackageMap().firstKey();
        }
        if (this.getClassMap().keySet().size() > 0) {
            return this.getClassMap().firstKey();
        }
        return "nonClassFuncs";
    }

    public void save(VDBEnums.BUCKET b) throws VDBGeneralException {
        VdbProvider.saveVdb(this, b);
    }
}

