/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.method;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.method.Method;
import java.util.regex.Pattern;

public class JavaMethod
extends Method {
    private static final long serialVersionUID = 7202391022531072553L;
    public static Pattern m_java_pattern = Pattern.compile("(\\S+?\\.\\S+?\\(\\S*?\\):\\S+?)");

    public JavaMethod(String sig) throws BadMarkupException {
        super(sig, Language.LANGUAGE.JAVA);
        this.setSignature(sig);
    }

    @Override
    public void setSignature(String sig) throws BadMarkupException {
        super.setSignature(sig);
        this.setClassName(JavaMethod.getClass(sig));
        this.setPackageName(JavaMethod.getPackage(sig));
        this.setMethodName(this.getMethodName(sig));
    }

    @Override
    protected boolean isConstructor_() {
        if (this.getMethodName().endsWith("&lt;init&gt;") || this.getMethodName().endsWith("<init>") || this.getMethodName().endsWith("&lt;clinit&gt;") || this.getMethodName().endsWith("<clinit>")) {
            return true;
        }
        return this.getClassName() != null && this.getClassName().length() > 0 && this.getClassName().equals(this.getMethodName());
    }

    @Override
    protected boolean isGetter_() {
        return this.getMethodName().startsWith("get") && !this.isStatic() && !this.getReturn().equals("void");
    }

    @Override
    protected boolean isSetter_() {
        return this.getMethodName().startsWith("set") && this.getArgs().size() == 1 && !this.isStatic();
    }

    @Override
    protected Pattern getPatternMatch() {
        return m_java_pattern;
    }
}

