/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.method;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.NonClassFunction;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class PhpMethod
extends NonClassFunction {
    private static final long serialVersionUID = -877086417788554318L;
    public static Pattern m_pattern = Pattern.compile("([\\S|\\s]+?\\([\\S|\\s]*?\\):[\\S|\\s]+?)");

    public PhpMethod(String signature) throws BadMarkupException {
        super(signature, Language.LANGUAGE.PHP);
    }

    public PhpMethod(Method m) throws BadMarkupException {
        super(m);
    }

    @Override
    protected Pattern getPatternMatch() {
        return m_pattern;
    }

    @Override
    protected boolean isConstructor_() {
        return this.getSignature().contains("__construct");
    }

    @Override
    protected boolean isGetter_() {
        return this.getSignature().contains("__get");
    }

    @Override
    protected boolean isSetter_() {
        return this.getSignature().contains("__set");
    }

    @Override
    public boolean isWebTechMech() {
        if (this.getSignature().contains("___Php.get_$_REQUEST")) {
            return true;
        }
        if (this.getSignature().contains("___Php.get_$_GET")) {
            return true;
        }
        if (this.getSignature().contains("___Php.get_$_POST")) {
            return true;
        }
        if (this.getSignature().contains("___Php.echo")) {
            return true;
        }
        if (this.getSignature().contains("___Php.get_$_COOKIE")) {
            return true;
        }
        return super.isWebTechMech();
    }

    @Override
    public boolean isFileTechMech() {
        if (this.getSignature().contains("___Php.get_$_FILES")) {
            return true;
        }
        return super.isFileTechMech();
    }

    @Override
    public boolean isDbTechMech() {
        if (this.getSignature().contains("mys")) {
            return true;
        }
        return super.isDbTechMech();
    }

    @Override
    protected ArrayList<String> getMethodNameParts() {
        ArrayList<String> ret = new ArrayList<String>();
        String method_name = this.getMethodName();
        if (method_name.contains("_")) {
            String[] split = method_name.split("_");
            for (int i = 0; i < split.length; ++i) {
                if (split[i].length() <= 0) continue;
                if (split[i].indexOf(46) != -1) {
                    for (String s : split[i].split("\\.")) {
                        if (s.equals("Php") || s.indexOf(36) != -1) continue;
                        ret.add(s);
                    }
                    continue;
                }
                if (split[i].equals("Php") || split[i].indexOf(36) != -1) continue;
                ret.add(split[i]);
            }
        }
        return ret;
    }
}

