/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.method.markup;

import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.VdbProvider;
import java.util.ArrayList;

public class Parameter
implements Comparable<Parameter> {
    private boolean m_all = false;
    private boolean m_this = false;
    private boolean m_default = false;
    private boolean m_none = false;
    private boolean m_varargs = false;
    private boolean m_ret = false;
    private boolean[] m_args;
    private StringBuffer m_param;
    private String m_givenParam;

    public Parameter(String param) throws BadMarkupException {
        this(param, false);
    }

    public boolean affectsArg(int arg) {
        if (this.isAll() || this.isDefault()) {
            return true;
        }
        return this.m_args[arg];
    }

    public boolean workForArgs(Method m) throws VDBException {
        if (this.isAll()) {
            return true;
        }
        if (m.isStatic() && this.isThis()) {
            return false;
        }
        if (this.isDefault()) {
            if (m.getArgs().size() > 0) {
                int count = 0;
                for (String a : m.getArgs()) {
                    if (VdbProvider.isTaintType(m.getSimpleArg(a))) continue;
                    ++count;
                }
                return count != m.getArgs().size();
            }
            return false;
        }
        if (this.isNone()) {
            return true;
        }
        boolean match = false;
        if (this.m_varargs) {
            if (m.getArgString().toString().contains("...") || m.getArgString().toString().contains("var_args")) {
                match = true;
            }
        } else {
            match = true;
        }
        if (this.m_args.length - 1 <= m.getArgs().size() && match) {
            for (int i = 1; i < this.m_args.length; ++i) {
                if (!this.m_args[i] || VdbProvider.isTaintType(m.getSimpleArgString(i - 1))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Parameter(String param, boolean force) throws BadMarkupException {
        if (param == null || param.length() == 0) {
            throw new BadMarkupException("Unable to use null or empty string for parameter", new Object[0]);
        }
        if (param.equals(".")) {
            param = "default";
        }
        this.m_givenParam = param.replaceAll("\\.", ",");
        this.m_args = new boolean[0];
        this.initialize();
        this.validate();
    }

    public boolean isNone() {
        return this.m_ret || this.m_none;
    }

    public boolean isAll() {
        return this.m_all;
    }

    public boolean isThis() {
        return this.m_this;
    }

    public boolean isDefault() {
        return this.m_default;
    }

    public boolean isRtn() {
        return this.m_ret;
    }

    public String getGivenParam() {
        return this.m_givenParam;
    }

    public String toString() {
        if (this.m_param == null) {
            ArrayList<String> _entries = new ArrayList<String>();
            this.m_param = new StringBuffer();
            if (this.m_none) {
                this.m_param.append("none");
                return this.m_param.toString();
            }
            if (this.m_all) {
                this.m_param.append("all");
                return this.m_param.toString();
            }
            if (this.m_this) {
                _entries.add("this");
            }
            if (this.m_default) {
                _entries.add("default");
            }
            if (this.m_varargs) {
                _entries.add("var_args");
            }
            if (!(this.m_all || this.m_default || this.m_none)) {
                for (int i = 1; i < this.m_args.length; ++i) {
                    if (!this.m_args[i]) continue;
                    _entries.add(Integer.toString(i));
                }
            }
            if (_entries.size() > 0) {
                for (String _entry : _entries) {
                    this.m_param.append(_entry);
                    this.m_param.append(",");
                }
            }
            if (this.m_param.toString().length() > 0) {
                this.m_param.deleteCharAt(this.m_param.length() - 1);
            } else if (this.m_ret) {
                this.m_param.append("none");
            }
        }
        return this.m_param.toString();
    }

    public String toString(Method m) {
        StringBuffer ret = new StringBuffer();
        ArrayList<String> _entries = new ArrayList<String>();
        ret = new StringBuffer();
        if (this.m_none) {
            return "none";
        }
        if (this.m_all) {
            return "all";
        }
        if (this.m_this) {
            _entries.add("this");
        }
        if (this.m_default) {
            _entries.add("default");
        }
        if (this.m_varargs) {
            _entries.add("var_args");
        }
        if (this.m_ret) {
            _entries.add("ret");
        }
        if (!(this.m_all || this.m_default || this.m_none)) {
            int i;
            int i2;
            boolean[] args = new boolean[m.getArgs().size()];
            for (i2 = 1; i2 < args.length; ++i2) {
                args[i2] = false;
            }
            for (i2 = 1; i2 < args.length; ++i2) {
                if (this.m_args.length <= i2 || !this.m_args[i2]) continue;
                args[i2] = true;
            }
            boolean default_value = true;
            for (i = 1; i < args.length; ++i) {
                if (args[i]) continue;
                default_value = false;
            }
            if (default_value) {
                if (!_entries.contains("default")) {
                    _entries.add("default");
                }
            } else {
                for (i = 1; i < this.m_args.length; ++i) {
                    if (!this.m_args[i]) continue;
                    _entries.add(Integer.toString(i));
                }
            }
        }
        if (_entries.contains("default") && _entries.contains("this")) {
            return "all";
        }
        if (_entries.size() > 0) {
            for (String _entry : _entries) {
                ret.append(_entry);
                ret.append(",");
            }
        }
        if (ret.length() != 0) {
            ret.deleteCharAt(ret.length() - 1);
        }
        return ret.toString();
    }

    public String toSimplifiedString() {
        StringBuffer ret = new StringBuffer();
        if (this.m_none) {
            return "none";
        }
        if (this.m_all) {
            return "all";
        }
        boolean arg = false;
        for (int i = 1; i < this.m_args.length; ++i) {
            if (!this.m_args[i]) continue;
            arg = true;
            break;
        }
        if (this.m_default) {
            return "default";
        }
        if (this.m_this) {
            if (arg || this.m_default) {
                return "all";
            }
            return "this";
        }
        if (arg) {
            return "default";
        }
        if (this.m_varargs) {
            return "default";
        }
        return ret.toString();
    }

    public void merge(Parameter o) {
        this.m_param = null;
        if (o.m_all) {
            this.m_all = true;
            this.m_default = false;
            this.m_ret = false;
            this.m_args = new boolean[0];
            this.m_none = false;
            this.m_this = false;
        }
        if (o.m_default) {
            this.m_all = false;
            this.m_default = true;
            this.m_ret = false;
            this.m_args = new boolean[0];
            this.m_none = false;
            this.m_this = false;
        }
        if (o.m_this) {
            this.m_this = true;
        }
        if (o.m_none) {
            this.m_all = false;
            this.m_default = false;
            this.m_ret = false;
            this.m_args = new boolean[0];
            this.m_none = true;
            this.m_this = false;
        }
        if (o.m_varargs) {
            this.m_varargs = true;
        }
        if (o.m_ret) {
            this.m_ret = true;
        }
        if (this.m_args.length != o.m_args.length) {
            int i;
            boolean[] args = new boolean[this.m_args.length];
            for (i = 1; i < this.m_args.length; ++i) {
                if (!this.m_args[i]) continue;
                args[i] = true;
            }
            this.m_args = new boolean[o.m_args.length];
            for (i = 1; i < args.length; ++i) {
                if (!args[i] || this.m_args.length <= i) continue;
                this.m_args[i] = true;
            }
        }
        for (int i = 1; i < o.m_args.length; ++i) {
            if (!o.m_args[i] || this.m_args.length <= i) continue;
            this.m_args[i] = true;
        }
    }

    public boolean canBeMerged(Parameter o) {
        if (o == null) {
            return false;
        }
        if (this.toString().equals(o.toString())) {
            return true;
        }
        if (this.m_all || o.m_all) {
            return true;
        }
        if (this.m_default || o.m_default) {
            return true;
        }
        if (this.m_none && o.m_none) {
            return true;
        }
        return !this.m_all && !this.m_default && !this.m_none && !o.m_all && !o.m_default && !o.m_none;
    }

    @Override
    public int compareTo(Parameter o) {
        if (this.toString().equals(o.toString())) {
            return 0;
        }
        if (this.m_all && !o.m_all) {
            return 1;
        }
        if (!this.m_all && o.m_all) {
            return -1;
        }
        if (this.m_default && !o.m_default) {
            return 1;
        }
        if (!this.m_default && o.m_default) {
            return -1;
        }
        if (this.m_none && !o.m_none) {
            return 1;
        }
        if (!this.m_none && o.m_none) {
            return -1;
        }
        if (this.m_this && !o.m_this) {
            return 1;
        }
        if (!this.m_this && o.m_this) {
            return -1;
        }
        if (this.m_varargs && !o.m_varargs) {
            return 1;
        }
        if (!this.m_varargs && o.m_varargs) {
            return -1;
        }
        if (this.m_ret && !o.m_ret) {
            return 1;
        }
        if (!this.m_ret && o.m_ret) {
            return -1;
        }
        if (this.m_args.length > o.m_args.length) {
            return 1;
        }
        if (this.m_args.length < o.m_args.length) {
            return -1;
        }
        for (int i = 1; i < this.m_args.length; ++i) {
            if (this.m_args[i]) {
                if (o.m_args[i]) continue;
                return 1;
            }
            if (this.m_args[i] || !o.m_args[i]) continue;
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Parameter) {
            Parameter p = (Parameter)obj;
            return this.compareTo(p) == 0;
        }
        return false;
    }

    public boolean isSuperSet(Parameter p) {
        if (this.toString().equals(p.toString())) {
            return true;
        }
        if (this.isAll()) {
            return true;
        }
        if (p.isNone() && !this.isNone()) {
            return true;
        }
        return p.m_args.length > 0 && this.isDefault();
    }

    public void setReturn(boolean rtn) {
        this.m_ret = rtn;
    }

    private void initialize() throws BadMarkupException {
        int _high = 0;
        if (this.m_givenParam.indexOf(",") > -1) {
            for (String _comma_par : this.parse(this.m_givenParam.toString(), ",")) {
                if (_comma_par.indexOf("-") > -1) {
                    for (String _dash_par : this.parse(_comma_par, "-")) {
                        if (!Parameter.isNumeric(_dash_par)) {
                            throw new BadMarkupException("Parameters specified in a dash list must be numeric. Bad param:{0}, given param:{1}", _dash_par, this.m_givenParam);
                        }
                        if (Integer.parseInt(_dash_par) <= _high) continue;
                        _high = Integer.parseInt(_dash_par);
                    }
                    continue;
                }
                if (Parameter.isNumeric(_comma_par) && Integer.parseInt(_comma_par) > _high) {
                    _high = Integer.parseInt(_comma_par);
                    continue;
                }
                this.processEntry(_comma_par);
            }
            if (_high > 0) {
                this.m_args = new boolean[_high + 1];
                if (this.m_givenParam.indexOf(",") > -1) {
                    for (String _comma_par : this.parse(this.m_givenParam.toString(), ",")) {
                        if (_comma_par.indexOf("-") > -1) {
                            String comma_low = _comma_par.split("-")[0];
                            String comma_high = _comma_par.split("-")[1];
                            if (Parameter.isNumeric(comma_low) && Parameter.isNumeric(comma_high)) {
                                for (int i = Integer.parseInt(comma_low); i <= Integer.parseInt(comma_high); ++i) {
                                    this.m_args[i] = true;
                                }
                                continue;
                            }
                            throw new BadMarkupException("Dash parameters must be numeric: {0}", _comma_par);
                        }
                        if (!Parameter.isNumeric(_comma_par)) continue;
                        this.m_args[Integer.parseInt((String)_comma_par)] = true;
                    }
                }
            }
        } else if (this.m_givenParam.indexOf("-") > -1) {
            for (String _dash_par : this.parse(this.m_givenParam, "-")) {
                if (!Parameter.isNumeric(_dash_par)) {
                    throw new BadMarkupException("Parameters specified in a dash list must be numeric. Bad param:{0}, given param:{1}", _dash_par, this.m_givenParam);
                }
                if (Integer.parseInt(_dash_par) <= _high) continue;
                _high = Integer.parseInt(_dash_par);
            }
            if (_high > 0) {
                this.m_args = new boolean[_high + 1];
                for (int i = 1; i <= _high; ++i) {
                    this.m_args[i] = true;
                }
            }
        } else if (Parameter.isNumeric(this.m_givenParam)) {
            this.m_args = new boolean[Integer.parseInt(this.m_givenParam) + 1];
            this.m_args[Integer.parseInt((String)this.m_givenParam)] = true;
        } else {
            this.processEntry(this.m_givenParam);
        }
    }

    private void validate() throws BadMarkupException {
        if (this.m_none && (this.m_ret || this.m_this || this.m_varargs || this.m_args.length > 0)) {
            throw new BadMarkupException("Parameters using none cannot use additional parameters. Supplied parameter:{0}", this.m_givenParam);
        }
        if (!(this.m_all || this.m_default || this.m_none || this.m_ret || this.m_varargs || this.m_this || this.m_args.length != 0)) {
            throw new BadMarkupException("Supplied parameter:{0} is not valid. Use one of the following:all,default,this,ret,var_args,single integer, comma separater list of integers(1,2,3), range of integers usign a dash(1-3), comma separated list (this,1,2,3-5)", this.m_givenParam);
        }
    }

    private String[] parse(String param, String regex) {
        String[] _ret = new String[param.split(regex).length];
        int _i = 0;
        String[] stringArray = param.split(regex);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String s;
            _ret[_i] = s = stringArray[i];
            ++_i;
        }
        return _ret;
    }

    private void processEntry(String param) throws BadMarkupException {
        if (param.equals("default")) {
            if (this.m_all || this.m_default || this.m_none || this.m_args.length > 0) {
                this.throwBadMarkup("default");
            }
            this.m_default = true;
        } else if (param.equals("all")) {
            if (this.m_all || this.m_default || this.m_none || this.m_ret || this.m_args.length > 0 || this.m_varargs) {
                this.throwBadMarkup("all");
            }
            this.m_all = true;
        } else if (param.equals("this")) {
            if (this.m_all || this.m_none) {
                this.throwBadMarkup("this");
            }
            this.m_this = true;
        } else if (param.contains("none") || param.equals("false")) {
            if (this.m_all || this.m_default || this.m_none || this.m_args.length > 0 || this.m_this || this.m_ret || this.m_varargs) {
                this.throwBadMarkup("none");
            }
            this.m_none = true;
        } else if (param.equals("var_args")) {
            if (this.m_all || this.m_none) {
                this.throwBadMarkup("var_args");
            }
            this.m_varargs = true;
        } else if (param.equals("ret")) {
            if (this.m_all || this.m_none) {
                this.throwBadMarkup("ret");
            }
            this.m_ret = true;
        }
    }

    private void throwBadMarkup(String parameter) throws BadMarkupException {
        ArrayList<String> _entries = new ArrayList<String>();
        if (this.m_all) {
            _entries.add("All is true");
        }
        if (this.m_default) {
            _entries.add("Default is true");
        }
        if (this.m_none) {
            _entries.add("None is true");
        }
        if (this.m_ret) {
            _entries.add("Return is true");
        }
        if (this.m_this) {
            _entries.add("This is true");
        }
        if (this.m_varargs) {
            _entries.add("var_args is true");
        }
        if (this.m_args.length > 0) {
            _entries.add("args were supplied");
        }
        StringBuffer _error = new StringBuffer();
        _error.append("Cannot set ");
        _error.append(parameter);
        _error.append(". Reasons:");
        for (String e : _entries) {
            _error.append(e);
            _error.append(",");
        }
        _error.deleteCharAt(_error.length() - 1);
        _error.append(".");
        throw new BadMarkupException(_error.toString(), new Object[0]);
    }

    private static boolean isNumeric(String param) {
        if (param == null || param.isEmpty()) {
            return false;
        }
        for (char c : param.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }
}

