/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.method.markup.ao;

import com.ibm.appscan.vdb.VdbArtifact;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.markup.MarkupBase;
import com.ibm.appscan.vdb.method.markup.Parameter;
import com.ibm.appscan.vdb.method.markup.ao.Option;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import java.util.ArrayList;
import java.util.Collections;

public class ActionObject
extends MarkupBase
implements Comparable<ActionObject> {
    private ArrayList<Option> m_options;
    private int m_vuln = 0;
    private VDBEnums.AO_TYPE m_type = VDBEnums.AO_TYPE.DEFAULT;
    private VDBEnums.SEVERITY m_sev = VDBEnums.SEVERITY.DEFAULT;
    private Parameter m_param;
    private boolean m_return = false;
    private String m_id = "0";

    public ActionObject() {
    }

    public ActionObject(ActionObject a) throws BadMarkupException {
        this.replace(a);
    }

    public ActionObject(String vuln, VDBEnums.AO_TYPE type, VDBEnums.SEVERITY sev) throws BadMarkupException {
        this.setVulnerability(vuln);
        this.setAoType(type);
        this.setSeverity(sev);
    }

    public void setVulnerability(String vuln) throws BadMarkupException {
        try {
            this.m_vuln = VdbProvider.getPropertyProvider().getPropertyId(vuln);
            if (this.m_vuln == 0) {
                throw new BadMarkupException("Invalid vuln supplied:" + vuln, new Object[0]);
            }
        }
        catch (VDBGeneralException e) {
            throw new BadMarkupException(e);
        }
    }

    public int getVulnerabilityId() {
        return this.m_vuln;
    }

    public String getVulnerability() {
        try {
            return VdbProvider.getPropertyProvider().getPropertyFqn(this.m_vuln);
        }
        catch (VDBGeneralException e) {
            e.logException();
            return "";
        }
    }

    public VDBEnums.AO_TYPE getAoType() {
        return this.m_type;
    }

    public void setAoType(VDBEnums.AO_TYPE type) throws BadMarkupException {
        if (type == VDBEnums.AO_TYPE.DEFAULT) {
            throw new BadMarkupException("Unknown ao type specified", new Object[0]);
        }
        this.m_type = type;
    }

    public VDBEnums.SEVERITY getSeverity() {
        return this.m_sev;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public String getId() {
        return this.m_id;
    }

    public void setSeverity(VDBEnums.SEVERITY sev) throws BadMarkupException {
        if (sev == VDBEnums.SEVERITY.DEFAULT) {
            throw new BadMarkupException("Cannot use invalid severity", new Object[0]);
        }
        this.m_sev = sev;
    }

    public boolean isSimpleType() {
        return this.getAoType() == VDBEnums.AO_TYPE.AnyHigh || this.getAoType() == VDBEnums.AO_TYPE.AnyMedium || this.getAoType() == VDBEnums.AO_TYPE.AnyLow;
    }

    public boolean isOptionBasedTester() {
        return this.getAoType() == VDBEnums.AO_TYPE.OptionBasedTester || this.getOptions().size() > 0;
    }

    public boolean isSink() {
        if (this.isSimpleType() || this.isOptionBasedTester() || this.isSource()) {
            return false;
        }
        return this.getParameter() != null;
    }

    public boolean isSource() {
        return this.getAoType() == VDBEnums.AO_TYPE.InputAnyTainted;
    }

    public void setParam(String param) throws BadMarkupException {
        if (param.equals("none") && this.isSink()) {
            throw new BadMarkupException("Parameter cannot be  \"none\" for a sink", param);
        }
        this.m_param = new Parameter(param);
        if (this.m_param.isRtn()) {
            this.m_return = true;
        }
    }

    public Parameter getParameter() {
        return this.m_param;
    }

    public boolean isReturn() {
        if (this.m_return) {
            return true;
        }
        return this.getParameter() != null && this.getParameter().isRtn();
    }

    public void setReturn(boolean isRtn) {
        this.m_return = isRtn;
    }

    public boolean addOption(Option option) throws BadMarkupException {
        option.isValid();
        if (this.getAoType() == VDBEnums.AO_TYPE.DEFAULT) {
            this.setAoType(VDBEnums.AO_TYPE.OptionBasedTester);
        }
        if (this.getOptions().contains(option)) {
            return false;
        }
        for (Option o : this.getOptions()) {
            if (!o.canCoexist(option)) {
                return false;
            }
            if (!this.mergeOption(o, option)) continue;
            return true;
        }
        this.getOptions().add(option);
        Collections.sort(this.getOptions());
        return true;
    }

    public boolean deleteOption(Option option) {
        if (this.getOptions().contains(option)) {
            this.getOptions().remove(option);
            return true;
        }
        return false;
    }

    public ArrayList<Option> getOptions() {
        if (this.m_options == null) {
            this.m_options = new ArrayList();
        }
        return this.m_options;
    }

    public boolean equals(Object o) {
        ActionObject ao = (ActionObject)o;
        return this.compareTo(ao) == 0;
    }

    @Override
    public int compareTo(ActionObject ao) {
        if (this.getVulnerabilityId() != ao.getVulnerabilityId()) {
            if (this.getVulnerabilityId() > ao.getVulnerabilityId()) {
                return 1;
            }
            return -1;
        }
        if (this.getSeverity().toString().compareToIgnoreCase(ao.getSeverity().toString()) != 0) {
            return this.getSeverity().toString().compareToIgnoreCase(ao.getSeverity().toString());
        }
        if (this.isOptionBasedTester() || ao.isOptionBasedTester()) {
            if (this.isOptionBasedTester() && ao.isOptionBasedTester()) {
                if (this.getOptions().size() > ao.getOptions().size()) {
                    return 1;
                }
                if (this.getOptions().size() < ao.getOptions().size()) {
                    return -1;
                }
                for (int i = 0; i < this.getOptions().size(); ++i) {
                    if (this.getOptions().get(i).compareTo(ao.getOptions().get(i)) == 0) continue;
                    return this.getOptions().get(i).compareTo(ao.getOptions().get(i));
                }
            }
            if (this.isOptionBasedTester() && !ao.isOptionBasedTester()) {
                return 1;
            }
            if (!this.isOptionBasedTester() && ao.isOptionBasedTester()) {
                return -1;
            }
        } else if (this.getAoType().toString().compareToIgnoreCase(ao.getAoType().toString()) != 0) {
            return this.getAoType().toString().compareToIgnoreCase(ao.getAoType().toString());
        }
        if (this.getParameter() != null) {
            if (ao.getParameter() == null) {
                return 1;
            }
            return this.getParameter().compareTo(ao.getParameter());
        }
        if (this.isReturn() && !ao.isReturn()) {
            return 1;
        }
        if (!this.isReturn() && ao.isReturn()) {
            return -1;
        }
        return 0;
    }

    public boolean equalsWithoutOptions(ActionObject ao) {
        if (this.getVulnerabilityId() == ao.getVulnerabilityId() && this.getSeverity() == ao.getSeverity()) {
            if (this.isOptionBasedTester() && ao.isOptionBasedTester()) {
                return true;
            }
            if (this.getAoType() != ao.getAoType()) {
                return false;
            }
        }
        if (this.getParameter() != null) {
            if (ao.getParameter() == null) {
                return false;
            }
            if (this.getParameter().equals(ao.getParameter())) {
                return true;
            }
        }
        return false;
    }

    public boolean mergeOption(Option source, Option target) {
        if (source.getOptionName() == target.getOptionName() && source.getOptionOperator() == target.getOptionOperator() && source.getOptionValue().equals(target.getOptionValue()) && source.getMaxCon() == target.getMaxCon() && source.getMinCon() == target.getMinCon() && this.getParameter() != null && target.getParameter() != null && this.getParameter().canBeMerged(target.getParameter())) {
            source.getParameter().merge(target.getParameter());
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.m_type = VDBEnums.AO_TYPE.DEFAULT;
        this.m_sev = VDBEnums.SEVERITY.DEFAULT;
        this.m_options = null;
    }

    @Override
    public void replace(VdbArtifact e) throws BadMarkupException {
        if (e instanceof ActionObject) {
            ActionObject ao = (ActionObject)e;
            this.reset();
            this.setId(ao.getId());
            this.m_type = ao.getAoType();
            this.m_sev = ao.getSeverity();
            this.m_vuln = ao.getVulnerabilityId();
            if (ao.getParameter() != null) {
                this.m_param = ao.getParameter();
            }
            if (ao.isReturn()) {
                this.setReturn(ao.isReturn());
            }
            for (Option o : ao.getOptions()) {
                this.addOption(o);
            }
        }
    }

    @Override
    public boolean isValid() throws BadMarkupException {
        try {
            if (VdbProvider.getPropertyProvider().getPropertyFqn(this.getVulnerabilityId()) == null) {
                throw new BadMarkupException("Vulnerability id {0} is invalid", this.getVulnerabilityId());
            }
        }
        catch (VDBGeneralException e) {
            throw new BadMarkupException(e);
        }
        if (this.getSeverity() == VDBEnums.SEVERITY.DEFAULT) {
            throw new BadMarkupException("Severity is invalid", new Object[0]);
        }
        if (this.getAoType() == VDBEnums.AO_TYPE.DEFAULT) {
            throw new BadMarkupException("Action Object type is invalid", new Object[0]);
        }
        return true;
    }

    @Override
    public boolean merge(VdbArtifact artifact) throws BadMarkupException {
        boolean _ret = false;
        if (artifact instanceof ActionObject) {
            ActionObject ao = (ActionObject)artifact;
            if (this.getSeverity() == ao.getSeverity() && this.getAoType() == ao.getAoType() && this.getVulnerabilityId() == ao.getVulnerabilityId()) {
                if (this.getParameter() != null && ao.getParameter() != null && this.getParameter().canBeMerged(ao.getParameter())) {
                    this.getParameter().merge(ao.getParameter());
                    _ret = true;
                }
                for (Option o : ao.getOptions()) {
                    if (!this.addOption(o)) continue;
                    _ret = true;
                }
            }
        }
        return _ret;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.getClass().getName());
        str.append("," + this.getVulnerability());
        str.append("," + (Object)((Object)this.getSeverity()));
        str.append("," + (Object)((Object)this.getAoType()));
        if (this.getParameter() != null) {
            str.append("," + this.getParameter());
        }
        if (this.isReturn()) {
            str.append(",Return: true");
        }
        for (Option o : this.getOptions()) {
            str.append(o.toString());
        }
        return str.toString();
    }

    public boolean isComplex() {
        return !this.isSimpleType() && !this.isSource() && !this.isOptionBasedTester() && this.getAoType() != VDBEnums.AO_TYPE.OutputAnyNotValidated;
    }
}

